/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.util;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.system.msgCenter.model.message.EmailModel2;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class EmailUtil {
    public static JSONObject sendMail(EmailModel2 emailModel2) {
        JSONObject retMsg = new JSONObject();
        String from = emailModel2.getEmailAccount();
        String to = emailModel2.getEmailToUsers();
        Properties props = System.getProperties();
        props.setProperty("mail.smtp.host", emailModel2.getEmailSmtpHost());
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.transport.protocol", "smtp");
        Session session = Session.getInstance((Properties)props);
        session.setDebug(true);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from, emailModel2.getEmailSenderName(), "UTF-8"));
            InternetAddress[] sendTo = InternetAddress.parse((String)to);
            message.setRecipients(MimeMessage.RecipientType.TO, (Address[])sendTo);
            message.setSubject(emailModel2.getEmailTitle());
            message.setContent((Object)emailModel2.getEmailContent(), "text/html;charset=utf-8");
            Transport transport = session.getTransport();
            transport.connect(emailModel2.getEmailSmtpHost(), Integer.parseInt(emailModel2.getEmailSmtpPort()), emailModel2.getEmailAccount(), emailModel2.getEmailPassword());
            transport.sendMessage((Message)message, (Address[])sendTo);
            transport.close();
            retMsg.put("code", (Object)true);
            retMsg.put("error", (Object)"");
            return retMsg;
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)e.toString());
            return retMsg;
        }
    }
}

