/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.util;

import com.bringspring.common.base.MailAccount;
import com.bringspring.common.base.MailFile;
import com.bringspring.common.base.MailModel;
import com.bringspring.common.util.file.UploadUtil;
import java.io.File;
import java.util.Collections;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class SmtpUtil2 {
    private static final Logger log = LoggerFactory.getLogger(SmtpUtil2.class);
    private String host = null;
    private Integer port = null;
    private String username = null;
    private String password = null;
    private String emailform = null;
    private String timeout = "2500";
    private String personal = null;
    private JavaMailSenderImpl mailSender = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkConnected(MailAccount mailAccount) {
        String string;
        block6: {
            Properties props = SmtpUtil2.getProperties(mailAccount.getSsl());
            Session session = SmtpUtil2.getSession(props);
            Transport transport = SmtpUtil2.getTransport(session, mailAccount);
            try {
                string = "true";
                if (Collections.singletonList(transport).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(transport).get(0) != null) {
                        transport.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    return e.getMessage();
                }
            }
            transport.close();
        }
        return string;
    }

    private static Session getSession(Properties props) {
        Session session = Session.getInstance((Properties)props);
        session.setDebug(true);
        return session;
    }

    private static Properties getProperties(boolean ssl) {
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.smtp.timeout", "2500");
        props.put("mail.smtp.connectiontimeout", "5000");
        props.put("mail.smtp.writetimeout", "25000");
        if (ssl) {
            props.put("mail.smtp.ssl.enable", "true");
            props.put("mail.smtp.socketFactory.fallback", "false");
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        return props;
    }

    private static Transport getTransport(Session session, MailAccount mailAccount) throws Exception {
        Transport transport = session.getTransport();
        transport.connect(mailAccount.getSmtpHost(), mailAccount.getSmtpPort(), mailAccount.getAccount(), mailAccount.getPassword());
        return transport;
    }

    public SmtpUtil2(MailAccount mailAccount) {
        this.host = mailAccount.getSmtpHost();
        this.port = mailAccount.getSmtpPort();
        this.username = mailAccount.getAccount();
        this.password = mailAccount.getPassword();
        this.emailform = mailAccount.getAccount();
        this.personal = mailAccount.getAccountName();
        this.mailSender = this.createMailSender();
    }

    private JavaMailSenderImpl createMailSender() {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(this.host);
        sender.setPort(this.port.intValue());
        sender.setUsername(this.username);
        sender.setPassword(this.password);
        sender.setDefaultEncoding("UTF-8");
        Properties props = new Properties();
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.smtp.timeout", this.timeout);
        props.put("mail.smtp.connectiontimeout", "5000");
        props.put("mail.smtp.writetimeout", "25000");
        props.setProperty("mail.smtp.starttls.enable", "true");
        props.setProperty("mail.smtp.starttls.required", "true");
        props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        sender.setJavaMailProperties(props);
        return sender;
    }

    public void sendMail(String type, String path, MailModel mailModel) throws Exception {
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
        messageHelper.setFrom(this.emailform, mailModel.getFromName());
        messageHelper.setTo(mailModel.getRecipient());
        if (mailModel.getBcc() != null) {
            messageHelper.setBcc(mailModel.getBcc());
        }
        if (mailModel.getCc() != null) {
            messageHelper.setCc(mailModel.getCc());
        }
        messageHelper.setSubject(mailModel.getSubject());
        messageHelper.setText(mailModel.getBodyText(), true);
        if (mailModel.getAttachment().size() > 0) {
            for (MailFile mailFile : mailModel.getAttachment()) {
                UploadUtil.downToLocal((String)type, (String)mailFile.getFileId(), (String)"mail", (String)path);
                File file = new File(path + mailFile.getFileId());
                String fileName = mailFile.getFileId();
                messageHelper.addAttachment(fileName, file);
            }
        }
        this.mailSender.send(mimeMessage);
    }
}

