/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgCenter.entity.McMessageEntity;
import com.bringspring.system.msgCenter.entity.McMessageReceiveEntity;
import com.bringspring.system.msgCenter.enums.ContentTypeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.article.NewArticle;
import me.chanjar.weixin.cp.bean.message.WxCpLinkedCorpMessage;
import me.chanjar.weixin.cp.bean.message.WxCpLinkedCorpMessageSendResult;
import me.chanjar.weixin.cp.bean.message.WxCpMessage;
import me.chanjar.weixin.cp.bean.message.WxCpMessageSendResult;
import me.chanjar.weixin.cp.bean.messagebuilder.NewsBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TextBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TextCardBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxCpMessageUtils {
    private static final Logger log = LoggerFactory.getLogger(WxCpMessageUtils.class);
    @Autowired
    WxCpConfiguration wxCpConfiguration;
    @Autowired
    private SynThirdInfoService synThirdInfoService;

    public Map<String, WxCpMessageSendResult> sendMessage(McMessageEntity info, List<McMessageReceiveEntity> list) throws WxErrorException {
        HashMap<String, WxCpMessageSendResult> resultMap;
        block8: {
            block7: {
                if (ObjectUtil.isEmpty((Object)info) || CollectionUtil.isEmpty(list)) {
                    log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u4e0b\u53d1\uff0c\u4f46message info\u4e3a\u7a7a \u6216 \u63a5\u6536\u4eba\u5217\u8868\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
                }
                Boolean toUserIdAll = false;
                if (list.size() == 1 && "@ALL".equals(list.get(0).getReceiveUserId())) {
                    toUserIdAll = true;
                }
                resultMap = new HashMap<String, WxCpMessageSendResult>();
                if (toUserIdAll.booleanValue()) break block7;
                List thirdInfoIds = list.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
                List synThirdInfoEntities = this.synThirdInfoService.listByIds(thirdInfoIds);
                HashMap corpUserMap = new HashMap();
                if (CollectionUtil.isNotEmpty((Collection)synThirdInfoEntities)) {
                    for (SynThirdInfoEntity synThirdInfoEntity : synThirdInfoEntities) {
                        if (!StringUtils.isNotEmpty((String)synThirdInfoEntity.getThirdObjectId())) continue;
                        String corpid = synThirdInfoEntity.getCropId();
                        String userid = synThirdInfoEntity.getThirdObjectId();
                        if (corpUserMap.containsKey(corpid)) {
                            ((List)corpUserMap.get(corpid)).add(userid);
                            continue;
                        }
                        ArrayList<String> useridList = new ArrayList<String>();
                        useridList.add(userid);
                        corpUserMap.put(corpid, useridList);
                    }
                }
                if (!CollectionUtil.isNotEmpty(corpUserMap)) break block8;
                for (Map.Entry entry : corpUserMap.entrySet()) {
                    WeComModel weComModel = this.wxCpConfiguration.getWeComModel((String)entry.getKey());
                    String corpId = weComModel.getQyhCorpId();
                    Integer agentId = Integer.valueOf(weComModel.getQyhAgentId());
                    String touser = StringUtils.join((Iterable)((Iterable)entry.getValue()), (String)"|");
                    WxCpMessageSendResult result = this.postMessageSend(info, corpId, agentId, touser);
                    System.out.println("~\u00b7~\u53d1\u9001\u6d88\u606f\uff1a" + corpId + result);
                    resultMap.put(corpId, result);
                }
                break block8;
            }
            Map<String, WeComModel> weComModels = this.wxCpConfiguration.getWeComModels();
            for (WeComModel weComModel : weComModels.values()) {
                String corpId = weComModel.getQyhCorpId();
                Integer n = Integer.valueOf(weComModel.getQyhAgentId());
                WxCpMessageSendResult result = this.postMessageSend(info, corpId, n, "@all");
                System.out.println("~\u00b7~\u53d1\u9001\u6d88\u606f@all\uff1a" + corpId + result);
                resultMap.put(corpId, result);
            }
        }
        return resultMap;
    }

    public WxCpMessageSendResult postMessageSend(McMessageEntity info, String corpId, Integer agentId, String touser) throws WxErrorException {
        if (ObjectUtil.isEmpty((Object)info) || StringUtils.isEmpty((String)corpId) || StringUtils.isEmpty((String)touser)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u6267\u884c \u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u6d88\u606fpost\u4e0b\u53d1\uff0c\u4f46message info \u6216 corpId\u4f01\u4e1aid \u6216 touser\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        WxCpService corpService = this.wxCpConfiguration.getCpService(corpId, agentId);
        String contentType = StringUtils.isNotEmpty((String)info.getContentType()) ? info.getContentType() : ContentTypeEnum.TEXT_MSG.getCode();
        String title = info.getTitle();
        String content = info.getContent();
        String detailUrl = info.getDetailUrl();
        if (ContentTypeEnum.TEXT_MSG.getCode().equals(contentType)) {
            WxCpMessage message = ((TextBuilder)WxCpMessage.TEXT().toUser(touser)).content(content).build();
            return corpService.getMessageService().send(message);
        }
        if (ContentTypeEnum.LINK_MSG.getCode().equals(contentType)) {
            WxCpMessage message = ((TextCardBuilder)WxCpMessage.TEXTCARD().toUser(touser)).description(content).url(detailUrl).title(title).build();
            return corpService.getMessageService().send(message);
        }
        if (ContentTypeEnum.IMG_TEXT_MSG.getCode().equals(contentType)) {
            NewArticle article1 = new NewArticle();
            article1.setUrl(detailUrl);
            article1.setPicUrl(info.getPicUrl());
            article1.setDescription(content);
            article1.setTitle(title);
            WxCpMessage message = ((NewsBuilder)WxCpMessage.NEWS().toUser(touser)).addArticle(new NewArticle[]{article1}).build();
            return corpService.getMessageService().send(message);
        }
        return null;
    }

    public WxCpLinkedCorpMessageSendResult sendLinkedCorpMessage(McMessageEntity info, List<McMessageReceiveEntity> list) throws WxErrorException {
        Map<String, WeComModel> weComModels;
        Optional<WeComModel> firstValue;
        if (ObjectUtil.isEmpty((Object)info) || CollectionUtil.isEmpty(list)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u4e92\u8054\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u4e0b\u53d1\uff0c\u4f46message info\u4e3a\u7a7a \u6216 \u63a5\u6536\u4eba\u5217\u8868\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        Boolean toUserIdAll = false;
        if (list.size() == 1 && "@ALL".equals(list.get(0).getReceiveUserId())) {
            toUserIdAll = true;
        }
        if ((firstValue = (weComModels = this.wxCpConfiguration.getWeComModels()).values().stream().findFirst()).isPresent() && firstValue.get().getIsLinkedCorp().booleanValue()) {
            String qyhCorpId = firstValue.get().getQyhCorpId();
            Integer qyhAgentId = Integer.valueOf(firstValue.get().getQyhAgentId());
            if (!toUserIdAll.booleanValue()) {
                List thirdInfoIds = list.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
                List synThirdInfoEntities = this.synThirdInfoService.listByIds(thirdInfoIds);
                String[] toUsers = synThirdInfoEntities.stream().map(t -> t.getThirdObjectId()).collect(Collectors.toList()).toArray(new String[0]);
                return this.postLinkedCorpMessageSend(info, qyhCorpId, qyhAgentId, toUserIdAll, toUsers);
            }
            return this.postLinkedCorpMessageSend(info, qyhCorpId, qyhAgentId, toUserIdAll, null);
        }
        return null;
    }

    public WxCpLinkedCorpMessageSendResult postLinkedCorpMessageSend(McMessageEntity info, String corpId, Integer agentId, Boolean isToAll, String[] toUsers) throws WxErrorException {
        if (ObjectUtil.isEmpty((Object)info) || StringUtils.isEmpty((String)corpId)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u6267\u884c \u4e92\u8054\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u6d88\u606fpost\u4e0b\u53d1\uff0c\u4f46message info \u6216 corpId\u4f01\u4e1aid \u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        WxCpService corpService = this.wxCpConfiguration.getCpService(corpId, agentId);
        String contentType = info.getContentType();
        String title = info.getTitle();
        String content = info.getContent();
        String detailUrl = info.getDetailUrl();
        if (ContentTypeEnum.TEXT_MSG.getCode().equals(contentType)) {
            WxCpLinkedCorpMessage message = WxCpLinkedCorpMessage.builder().msgType("text").toUsers(toUsers).isToAll(isToAll).isSafe(Boolean.valueOf(false)).content(content).build();
            return corpService.getMessageService().sendLinkedCorpMessage(message);
        }
        if (ContentTypeEnum.LINK_MSG.getCode().equals(contentType)) {
            WxCpLinkedCorpMessage message = WxCpLinkedCorpMessage.builder().msgType("textcard").toUsers(toUsers).isToAll(isToAll).title(title).description(content).url(detailUrl).build();
            return corpService.getMessageService().sendLinkedCorpMessage(message);
        }
        if (ContentTypeEnum.IMG_TEXT_MSG.getCode().equals(contentType)) {
            WxCpLinkedCorpMessage message = WxCpLinkedCorpMessage.builder().msgType("news").toUsers(toUsers).isToAll(isToAll).articles((List)Lists.newArrayList((Object[])new NewArticle[]{NewArticle.builder().title(title).description(content).url(detailUrl).picUrl(info.getPicUrl()).build()})).build();
            return corpService.getMessageService().sendLinkedCorpMessage(message);
        }
        return null;
    }
}

