/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.enums.DictionaryDataEnum;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.entity.GroupEntity;
import com.bringspring.system.permission.model.usergroup.GroupCrForm;
import com.bringspring.system.permission.model.usergroup.GroupInfoVO;
import com.bringspring.system.permission.model.usergroup.GroupPaginationVO;
import com.bringspring.system.permission.model.usergroup.GroupSelectorVO;
import com.bringspring.system.permission.model.usergroup.GroupTreeModel;
import com.bringspring.system.permission.model.usergroup.GroupUpForm;
import com.bringspring.system.permission.service.GroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5206\u7ec4\u7ba1\u7406"}, value="UserGroupController")
@RequestMapping(value={"/api/permission/Group"})
public class GroupController {
    @Autowired
    private GroupService userGroupService;
    @Autowired
    private DictionaryDataService dictionaryDataService;

    @ApiOperation(value="\u83b7\u53d6\u5206\u7ec4\u7ba1\u7406\u5217\u8868")
    @GetMapping
    public ActionResult list(Pagination pagination) {
        List<GroupEntity> list = this.userGroupService.getList(pagination);
        List jsonToList = JsonUtil.getJsonToList(list, GroupPaginationVO.class);
        List<DictionaryDataEntity> dictionaryDataEntities = this.dictionaryDataService.getDicList(DictionaryDataEnum.PERMISSION_GROUP.getDictionaryTypeId());
        for (GroupPaginationVO userGroupPaginationVO : jsonToList) {
            DictionaryDataEntity dictionaryDataEntity = dictionaryDataEntities.stream().filter(t -> t.getId().equals(userGroupPaginationVO.getType())).findFirst().orElse(null);
            userGroupPaginationVO.setType(dictionaryDataEntity != null ? dictionaryDataEntity.getFullName() : userGroupPaginationVO.getId());
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page((List)jsonToList, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u7ec4\u7ba1\u7406\u4e0b\u62c9\u6846")
    @GetMapping(value={"/Selector"})
    public ActionResult<List<GroupSelectorVO>> selector() {
        ArrayList<GroupTreeModel> tree = new ArrayList<GroupTreeModel>();
        List<GroupEntity> data = this.userGroupService.list();
        List<DictionaryDataEntity> dataEntityList = this.dictionaryDataService.getList(DictionaryDataEnum.PERMISSION_GROUP.getDictionaryTypeId());
        for (DictionaryDataEntity dictionaryDataEntity : dataEntityList) {
            GroupTreeModel firstModel = (GroupTreeModel)((Object)JsonUtil.getJsonToBean((Object)dictionaryDataEntity, GroupTreeModel.class));
            firstModel.setId(dictionaryDataEntity.getId());
            firstModel.setType("0");
            long num = data.stream().filter(t -> t.getType().equals(dictionaryDataEntity.getId())).count();
            firstModel.setNum(num);
            if (num <= 0L) continue;
            tree.add(firstModel);
        }
        for (GroupEntity entity : data) {
            GroupTreeModel treeModel = (GroupTreeModel)((Object)JsonUtil.getJsonToBean((Object)entity, GroupTreeModel.class));
            treeModel.setType(entity.getType());
            treeModel.setParentId(entity.getType());
            treeModel.setId(entity.getId());
            DictionaryDataEntity dataEntity = this.dictionaryDataService.getInfo(entity.getType());
            if (dataEntity == null) continue;
            tree.add(treeModel);
        }
        List sumTrees = TreeDotUtils.convertListToTreeDot(tree);
        List list = JsonUtil.getJsonToList((Object)sumTrees, GroupSelectorVO.class);
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)list);
    }

    @ApiOperation(value="\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<GroupInfoVO> info(@PathVariable(value="id") String id) {
        GroupEntity entity = this.userGroupService.getInfo(id);
        GroupInfoVO vo = (GroupInfoVO)JsonUtil.getJsonToBean((Object)entity, GroupInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping
    public ActionResult create(@RequestBody @Valid GroupCrForm userGroupCrForm) {
        GroupEntity entity = (GroupEntity)JsonUtil.getJsonToBean((Object)userGroupCrForm, GroupEntity.class);
        if (this.userGroupService.isExistByFullName(entity.getFullName(), entity.getId()).booleanValue()) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        if (this.userGroupService.isExistByEnCode(entity.getEnCode(), entity.getId()).booleanValue()) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        this.userGroupService.crete(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid GroupUpForm userGroupUpForm) {
        GroupEntity entity = (GroupEntity)JsonUtil.getJsonToBean((Object)userGroupUpForm, GroupEntity.class);
        if (this.userGroupService.isExistByFullName(entity.getFullName(), id).booleanValue()) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        if (this.userGroupService.isExistByEnCode(entity.getEnCode(), id).booleanValue()) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        Boolean flag = this.userGroupService.update(id, entity);
        if (!flag.booleanValue()) {
            return ActionResult.fail((String)MsgCode.FA013.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        GroupEntity entity = this.userGroupService.getInfo(id);
        if (entity != null) {
            this.userGroupService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }
}

