/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.entity.AuthorizeEntity;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.mapper.PositionMapper;
import com.bringspring.system.permission.model.organize.OrganizePagination;
import com.bringspring.system.permission.model.position.PaginationPosition;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PositionServiceImpl
extends ServiceImpl<PositionMapper, PositionEntity>
implements PositionService {
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private UserService userService;

    @Override
    public List<PositionEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<PositionEntity> getListByOrgIds(List<String> orgIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(PositionEntity::getOrganizeId, orgIds);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<PositionEntity> getPositionList(List<String> idList) {
        if (idList.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.lambda().in(PermissionEntityBase::getId, idList)).select(new SFunction[]{PermissionEntityBase::getId, PermissionEntityBase::getFullName});
            return this.list((Wrapper)queryWrapper);
        }
        return new ArrayList<PositionEntity>();
    }

    @Override
    public List<PositionEntity> getPositionList(Set<String> idList) {
        if (idList.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
            queryWrapper.lambda().select(new SFunction[]{PermissionEntityBase::getId, PermissionEntityBase::getFullName}).in(PermissionEntityBase::getId, idList);
            return this.list((Wrapper)queryWrapper);
        }
        return new ArrayList<PositionEntity>();
    }

    @Override
    public List<PositionEntity> getPositionRedisList() {
        if (this.redisUtil.exists(this.cacheKeyUtil.getPositionList())) {
            return JsonUtil.getJsonToList((String)this.redisUtil.getString(this.cacheKeyUtil.getPositionList()).toString(), PositionEntity.class);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PermissionEntityBase::getEnabledMark, (Object)1);
        List list = this.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            this.redisUtil.insert(this.cacheKeyUtil.getPositionList(), (Object)JsonUtil.getObjectToString((Object)list), 300L);
        }
        return list;
    }

    @Override
    public List<PositionEntity> getList(PaginationPosition paginationPosition) {
        List<OrganizeEntity> organizeByDataAuthorize;
        List organizeIds;
        UserInfo userInfo = this.userProvider.get();
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtils.isEmpty((String)paginationPosition.getOrganizeId())) {
            flag = true;
            List<String> childOrganizeIds = this.organizeService.getUnderOrganizations(paginationPosition.getOrganizeId());
            childOrganizeIds.add(paginationPosition.getOrganizeId());
            if (CollectionUtil.isNotEmpty(childOrganizeIds)) {
                queryWrapper.lambda().in(PositionEntity::getOrganizeId, childOrganizeIds);
            }
        }
        if (!userInfo.getIsAdministrator().booleanValue() && CollectionUtil.isNotEmpty(organizeIds = (organizeByDataAuthorize = this.organizeService.getOrganizeByDataPermission(new OrganizePagination(paginationPosition.getMenuId()))).stream().map(OrganizeEntity::getId).collect(Collectors.toList()))) {
            queryWrapper.lambda().in(PositionEntity::getOrganizeId, organizeIds);
        }
        if (!StringUtils.isEmpty((String)paginationPosition.getKeyword())) {
            flag = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(PermissionEntityBase::getFullName, (Object)paginationPosition.getKeyword())).or()).like(PermissionEntityBase::getEnCode, (Object)paginationPosition.getKeyword());
            });
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(PermissionEntityBase::getLastModifyTime);
        }
        Page page = new Page(paginationPosition.getCurrentPage(), paginationPosition.getPageSize());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return paginationPosition.setData(iPage.getRecords(), page.getTotal());
    }

    @Override
    public List<PositionEntity> getListByUserId(String userId) {
        QueryWrapper query = new QueryWrapper();
        ArrayList ids = new ArrayList();
        this.userRelationService.getListByObjectType(userId, "Position").forEach(r -> ids.add(r.getObjectId()));
        if (ids.size() > 0) {
            query.lambda().in(PermissionEntityBase::getId, ids);
            return this.list((Wrapper)query);
        }
        return new ArrayList<PositionEntity>();
    }

    @Override
    public PositionEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PermissionEntityBase::getId, (Object)id);
        return (PositionEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public PositionEntity getByFullName(String fullName) {
        PositionEntity positionEntity = new PositionEntity();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PermissionEntityBase::getFullName, (Object)fullName);
        queryWrapper.lambda().select(new SFunction[]{PermissionEntityBase::getId});
        List list = this.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            positionEntity = (PositionEntity)list.get(0);
        }
        return positionEntity;
    }

    @Override
    public boolean isExistByFullName(PositionEntity entity, boolean isFilter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (entity != null) {
            queryWrapper.lambda().eq(PermissionEntityBase::getFullName, (Object)entity.getFullName());
        }
        if (isFilter) {
            queryWrapper.lambda().ne(PermissionEntityBase::getId, (Object)entity.getId());
        }
        List entityList = this.list((Wrapper)queryWrapper);
        for (PositionEntity positionEntity : entityList) {
            if (entity == null || !entity.getOrganizeId().equals(positionEntity.getOrganizeId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExistByEnCode(PositionEntity entity, boolean isFilter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (entity != null) {
            queryWrapper.lambda().eq(PermissionEntityBase::getEnCode, (Object)entity.getEnCode());
            if (isFilter) {
                queryWrapper.lambda().ne(PermissionEntityBase::getId, (Object)entity.getId());
            }
        }
        List entityList = this.list((Wrapper)queryWrapper);
        for (PositionEntity positionEntity : entityList) {
            if (entity == null || !entity.getOrganizeId().equals(positionEntity.getOrganizeId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void create(PositionEntity entity) {
        if (StringUtils.isEmpty((String)entity.getId())) {
            entity.setId(RandomUtil.uuId());
        }
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    public boolean update(String id, PositionEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(PositionEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(UserRelationEntity::getObjectId, (Object)entity.getId());
        this.userRelationService.remove((Wrapper)queryWrapper);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(AuthorizeEntity::getObjectId, (Object)entity.getId());
        this.authorizeService.remove((Wrapper)wrapper);
    }

    @Override
    @DSTransactional
    public boolean first(String id) {
        boolean isOk = false;
        PositionEntity upEntity = (PositionEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = upEntity.getSortCode() == null ? 0L : upEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().lt(PermissionEntityBase::getSortCode, (Object)upSortCode)).eq(PositionEntity::getOrganizeId, (Object)upEntity.getOrganizeId())).orderByDesc(PermissionEntityBase::getSortCode);
        List downEntity = this.list((Wrapper)queryWrapper);
        if (downEntity.size() > 0) {
            Long temp = upEntity.getSortCode();
            upEntity.setSortCode(((PositionEntity)downEntity.get(0)).getSortCode());
            ((PositionEntity)downEntity.get(0)).setSortCode(temp);
            this.updateById(downEntity.get(0));
            this.updateById(upEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    @DSTransactional
    public boolean next(String id) {
        boolean isOk = false;
        PositionEntity downEntity = (PositionEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = downEntity.getSortCode() == null ? 0L : downEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().gt(PermissionEntityBase::getSortCode, (Object)upSortCode)).eq(PositionEntity::getOrganizeId, (Object)downEntity.getOrganizeId())).orderByAsc(PermissionEntityBase::getSortCode);
        List upEntity = this.list((Wrapper)queryWrapper);
        if (upEntity.size() > 0) {
            Long temp = downEntity.getSortCode();
            downEntity.setSortCode(((PositionEntity)upEntity.get(0)).getSortCode());
            ((PositionEntity)upEntity.get(0)).setSortCode(temp);
            this.updateById(upEntity.get(0));
            this.updateById(downEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    public List<PositionEntity> getListPositionDataPermission(PaginationPosition paginationPosition) {
        UserInfo userInfo = this.userProvider.get();
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        List<Object> childOrganizeIds = new ArrayList();
        if (!StringUtils.isEmpty((String)paginationPosition.getOrganizeId())) {
            List<OrganizeEntity> list;
            if ("1".equals(paginationPosition.getOrganizeId()) && !userInfo.getIsAdministrator().booleanValue() && !(list = this.organizeService.getOrganizeListDataPermission(paginationPosition.getMenuId())).isEmpty()) {
                for (OrganizeEntity organizeEntity : list) {
                    if (!organizeEntity.getCategory().equals("company")) continue;
                    childOrganizeIds.add(organizeEntity.getOrganizeId());
                }
                if (CollectionUtil.isNotEmpty(childOrganizeIds)) {
                    queryWrapper.lambda().in(PositionEntity::getOrganizeId, childOrganizeIds);
                }
            }
            flag = true;
            childOrganizeIds = this.organizeService.getUnderOrganizations(paginationPosition.getOrganizeId());
            childOrganizeIds.add(paginationPosition.getOrganizeId());
            if (CollectionUtil.isNotEmpty(childOrganizeIds)) {
                queryWrapper.lambda().in(PositionEntity::getOrganizeId, childOrganizeIds);
            }
        }
        if (!StringUtils.isEmpty((String)paginationPosition.getKeyword())) {
            flag = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(PermissionEntityBase::getFullName, (Object)paginationPosition.getKeyword())).or()).like(PermissionEntityBase::getEnCode, (Object)paginationPosition.getKeyword());
            });
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(PermissionEntityBase::getLastModifyTime);
        }
        Page page = new Page(paginationPosition.getCurrentPage(), paginationPosition.getPageSize());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return paginationPosition.setData(iPage.getRecords(), page.getTotal());
    }

    @Override
    public List<PositionEntity> getPositionName(List<String> id) {
        List<PositionEntity> roleList = new ArrayList<PositionEntity>();
        if (id.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(PermissionEntityBase::getId, id);
            roleList = this.list((Wrapper)queryWrapper);
        }
        return roleList;
    }

    @Override
    public List<PositionEntity> getListByOrganizeId(String organizeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PositionEntity::getOrganizeId, (Object)organizeId);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        queryWrapper.lambda().select(new SFunction[]{PermissionEntityBase::getId, PermissionEntityBase::getFullName});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<PositionEntity> getListByOrgIdAndUserId(String organizeId, String userId) {
        List positionIds = this.userRelationService.getListByUserIdAndObjType(userId, "Position").stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
        if (positionIds.size() > 0) {
            List positionEntities = this.listByIds(positionIds);
            return positionEntities.stream().filter(p -> p.getOrganizeId().equals(organizeId)).collect(Collectors.toList());
        }
        return new ArrayList<PositionEntity>();
    }

    @Override
    public List<PositionEntity> getListByFullName(String fullName, String enCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(PermissionEntityBase::getFullName, (Object)fullName)).eq(PermissionEntityBase::getEnCode, (Object)enCode);
        return this.list((Wrapper)queryWrapper);
    }
}

