/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.GlobalMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.permission.entity.AuthorizeEntity;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.OrganizeRelationEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.mapper.RoleMapper;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.model.organize.OrganizePagination;
import com.bringspring.system.permission.model.role.RolePagination;
import com.bringspring.system.permission.model.role.RoleUpForm;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.BasePositionRelationService;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DSTransactional
public class RoleServiceImpl
extends ServiceImpl<RoleMapper, RoleEntity>
implements RoleService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private BasePositionRelationService positionRelationService;

    @Override
    public List<RoleEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RoleEntity> getList(RolePagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            QueryWrapper obj = queryWrapper;
            queryWrapper = (QueryWrapper)this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "BASE_ROLE"));
        }
        int globalMark = "0".equals(pagination.getOrganizeId()) ? 1 : (StringUtils.isEmpty((String)pagination.getOrganizeId()) ? -1 : 0);
        boolean flag = false;
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(PermissionEntityBase::getFullName, (Object)pagination.getKeyword())).or()).like(PermissionEntityBase::getEnCode, (Object)pagination.getKeyword());
            });
        }
        if (globalMark == 0) {
            List<OrganizeEntity> listLikeOrgIdTree = this.organizeService.getListLikeOrgIdTree(pagination.getOrganizeId());
            QueryWrapper queryRelation = new QueryWrapper();
            queryRelation.lambda().eq(OrganizeRelationEntity::getOrganizeId, (Object)pagination.getOrganizeId());
            ArrayList ids = new ArrayList();
            this.organizeRelationService.list((Wrapper)queryRelation).forEach(o -> ids.add(o.getObjectId()));
            if (ids.size() > 0) {
                queryWrapper.lambda().in(PermissionEntityBase::getId, ids);
            } else {
                queryWrapper.lambda().in(PermissionEntityBase::getId, new Object[]{"0"});
            }
        }
        if (globalMark != -1) {
            queryWrapper.lambda().eq(RoleEntity::getGlobalMark, (Object)globalMark);
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(PermissionEntityBase::getLastModifyTime);
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<RoleEntity> getListByDataPermission(RolePagination pagination) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        QueryWrapper queryRelation = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getOrganizeId())) {
            List<String> childOrganizeIds = this.organizeService.getUnderOrganizations(pagination.getOrganizeId());
            childOrganizeIds.add(pagination.getOrganizeId());
            queryRelation.lambda().in(CollectionUtil.isNotEmpty(childOrganizeIds), OrganizeRelationEntity::getOrganizeId, childOrganizeIds);
        }
        if (StringUtils.isNotEmpty((String)pagination.getOrganizeId()) && "0".equals(pagination.getOrganizeId())) {
            queryWrapper.lambda().eq(RoleEntity::getGlobalMark, (Object)GlobalMarkEnum.NOT_ORGANIZE.getCode());
        }
        if (!userInfo.getIsAdministrator().booleanValue()) {
            queryWrapper.lambda().eq(RoleEntity::getGlobalMark, (Object)GlobalMarkEnum.ORGANIZE.getCode());
            List<OrganizeEntity> organizeByDataAuthorize = this.organizeService.getOrganizeByDataPermission(new OrganizePagination(pagination.getMenuId()));
            List organizeIds = organizeByDataAuthorize.stream().map(OrganizeEntity::getId).collect(Collectors.toList());
            queryRelation.lambda().in(CollectionUtil.isNotEmpty(organizeIds), OrganizeRelationEntity::getOrganizeId, organizeIds);
        }
        ArrayList ids = new ArrayList();
        this.organizeRelationService.list((Wrapper)queryRelation).forEach(o -> ids.add(o.getObjectId()));
        if (!"0".equals(pagination.getOrganizeId())) {
            if (CollectionUtil.isEmpty(ids)) {
                queryWrapper.lambda().in(PermissionEntityBase::getId, new Object[]{""});
            } else {
                queryWrapper.lambda().in(PermissionEntityBase::getId, ids);
            }
        }
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(PermissionEntityBase::getFullName, (Object)pagination.getKeyword())).or()).like(PermissionEntityBase::getEnCode, (Object)pagination.getKeyword());
            });
        }
        if (CollectionUtil.isNotEmpty(pagination.getTypeList())) {
            queryWrapper.lambda().in(RoleEntity::getType, pagination.getTypeList());
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getLastModifyTime);
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<RoleEntity> getListPositionDataPermission(RolePagination rolePagination) {
        UserInfo userInfo = this.userProvider.get();
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        List<Object> childOrganizeIds = new ArrayList();
        if (!StringUtils.isEmpty((String)rolePagination.getPositionId())) {
            flag = true;
            childOrganizeIds = this.positionRelationService.getListByTypeAndPosId("Role", rolePagination.getPositionId()).stream().map(v -> v.getObjectId()).collect(Collectors.toList());
            childOrganizeIds.add(rolePagination.getOrganizeId());
            if (CollectionUtil.isNotEmpty(childOrganizeIds)) {
                queryWrapper.lambda().in(PermissionEntityBase::getId, childOrganizeIds);
            }
        }
        if (!StringUtils.isEmpty((String)rolePagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(PermissionEntityBase::getFullName, (Object)rolePagination.getKeyword())).or()).like(PermissionEntityBase::getEnCode, (Object)rolePagination.getKeyword());
            });
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(PermissionEntityBase::getLastModifyTime);
        }
        Page page = new Page(rolePagination.getCurrentPage(), rolePagination.getPageSize());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return rolePagination.setData(iPage.getRecords(), page.getTotal());
    }

    @Override
    public List<RoleEntity> getListByEnCode(String enCode) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().in(PermissionEntityBase::getEnCode, new Object[]{enCode});
        return this.list((Wrapper)query);
    }

    @Override
    public List<RoleEntity> getListByUserId(String userId) {
        QueryWrapper query = new QueryWrapper();
        List roleRelations = this.userRelationService.getListByObjectType(userId, "Role").stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
        if (roleRelations.size() > 0) {
            query.lambda().in(PermissionEntityBase::getId, roleRelations);
            return this.list((Wrapper)query);
        }
        return new ArrayList<RoleEntity>();
    }

    @Override
    public List<RoleEntity> getListByUserIdAndOrgId(String userId, String orgId) {
        return this.getListByUserId(userId).stream().filter(role -> this.organizeRelationService.existByObejctIdAndOrgIdAndObjectType(orgId, role.getId(), "Role")).collect(Collectors.toList());
    }

    @Override
    public List<String> getRoleIdsByCurrentUser() {
        UserEntity userEntity = this.userService.getInfo(this.userProvider.get().getUserId());
        return this.getAllRoleIdsByUserIdAndOrgId(userEntity.getId(), userEntity.getOrganizeId());
    }

    @Override
    public List<String> getRoleIdsByCurrentUser(String orgId) {
        UserEntity userEntity = this.userService.getInfo(this.userProvider.get().getUserId());
        return this.getAllRoleIdsByUserIdAndOrgId(userEntity.getId(), orgId);
    }

    @Override
    public List<String> getAllRoleIdsByUserIdAndOrgId(String userId, String orgId) {
        List roleIds = this.getListByUserIdAndOrgId(userId, orgId).stream().map(PermissionEntityBase::getId).collect(Collectors.toList());
        List<String> globalRoleIds = this.userRelationService.getListByUserIdAndObjType(userId, "Role").stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
        globalRoleIds = this.roleService.getListByIds(globalRoleIds).stream().filter(r -> r.getGlobalMark() != null && r.getGlobalMark() == GlobalMarkEnum.NOT_ORGANIZE.getCode()).map(PermissionEntityBase::getId).collect(Collectors.toList());
        roleIds.addAll(globalRoleIds);
        return roleIds.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public RoleEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PermissionEntityBase::getId, (Object)id);
        return (RoleEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public Boolean isExistByFullName(String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PermissionEntityBase::getFullName, (Object)fullName);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(PermissionEntityBase::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public Boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PermissionEntityBase::getEnCode, (Object)enCode);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(PermissionEntityBase::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public Boolean update(String id, RoleEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void create(RoleEntity entity) {
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void copyRole(RoleUpForm roleUpForm, String fromId) throws BaseException {
        RoleEntity entity = (RoleEntity)JsonUtil.getJsonToBean((Object)roleUpForm, RoleEntity.class);
        if (this.roleService.isExistByFullName(roleUpForm.getFullName(), null).booleanValue()) {
            throw new BaseException("\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.roleService.isExistByEnCode(roleUpForm.getEnCode(), null).booleanValue()) {
            throw new BaseException("\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        entity.setId(RandomUtil.uuId());
        this.save(entity);
        this.createOrganizeRoleRelation(roleUpForm.getOrganizeIdsTree(), entity.getId(), entity.getGlobalMark());
        List<AuthorizeEntity> authorizeEntities = this.authorizeService.getListByObjectId(fromId);
        for (AuthorizeEntity authorizeEntity : authorizeEntities) {
            authorizeEntity.setObjectId(entity.getId());
            authorizeEntity.setId(RandomUtil.uuId());
            this.authorizeService.save(authorizeEntity);
        }
    }

    @Override
    @DSTransactional
    public Boolean createOrganizeRoleRelation(List<List<String>> organizeIdsTree, String roleId, Integer globalMark) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)"Role");
        query.lambda().eq(OrganizeRelationEntity::getObjectId, (Object)roleId);
        this.organizeRelationService.remove((Wrapper)query);
        if (globalMark.equals(0)) {
            ArrayList<OrganizeRelationEntity> relationList = new ArrayList<OrganizeRelationEntity>();
            for (List<String> organizeIds : organizeIdsTree) {
                String organizeId = organizeIds.get(organizeIds.size() - 1);
                OrganizeRelationEntity organizeRelationEntity = new OrganizeRelationEntity();
                organizeRelationEntity.setId(RandomUtil.uuId());
                organizeRelationEntity.setOrganizeId(organizeId);
                organizeRelationEntity.setObjectType("Role");
                organizeRelationEntity.setObjectId(roleId);
                relationList.add(organizeRelationEntity);
            }
            this.organizeRelationService.saveBatch(relationList);
        }
        return true;
    }

    @Override
    @DSTransactional
    public void delete(RoleEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(AuthorizeEntity::getObjectId, (Object)entity.getId());
            this.authorizeService.remove((Wrapper)queryWrapper);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.lambda().eq(UserRelationEntity::getObjectId, (Object)entity.getId());
            this.userRelationService.remove((Wrapper)wrapper);
        }
    }

    @Override
    public List<AuthorizeEntity> getListBymenuId(String menuId) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(AuthorizeEntity::getItemId, (Object)menuId);
        query.lambda().eq(AuthorizeEntity::getObjectType, (Object)"Role");
        List ls = this.authorizeService.list((Wrapper)query);
        List<AuthorizeEntity> distinctPersons = ls.stream().collect(Collectors.toMap(AuthorizeEntity::getObjectId, p -> p, (p1, p2) -> p1)).values().stream().collect(Collectors.toList());
        return distinctPersons;
    }

    @Override
    public List<RoleEntity> getListByIds(List<String> id) {
        List<RoleEntity> roleList = new ArrayList<RoleEntity>();
        if (id.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(PermissionEntityBase::getId, id);
            roleList = this.list((Wrapper)queryWrapper);
        }
        return roleList;
    }

    @Override
    public RoleEntity getInfoByFullName(String fullName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PermissionEntityBase::getFullName, (Object)fullName);
        return (RoleEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<RoleEntity> getGlobalList() {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(RoleEntity::getGlobalMark, (Object)GlobalMarkEnum.NOT_ORGANIZE.getCode());
        return this.list((Wrapper)query);
    }

    @Override
    public List<RoleEntity> getCurRolesByOrgId(String orgId) {
        String userId = this.userProvider.get().getUserId();
        List<UserRelationEntity> userRelations = this.userRelationService.getListByObjectType(userId, "Role");
        ArrayList<RoleEntity> roles = new ArrayList<RoleEntity>();
        userRelations.forEach(ur -> {
            RoleEntity roleEntity = this.getInfo(ur.getObjectId());
            if (roleEntity != null && roleEntity.getGlobalMark() != null && roleEntity.getGlobalMark() == GlobalMarkEnum.NOT_ORGANIZE.getCode()) {
                roles.add(roleEntity);
            } else {
                this.organizeRelationService.getRelationListByRoleId(ur.getObjectId()).forEach(or -> {
                    if (or.getOrganizeId().equals(orgId)) {
                        roles.add(roleEntity);
                    }
                });
            }
        });
        return roles;
    }

    @Override
    public List<RoleEntity> getRolesByOrgId(String orgId) {
        ArrayList ids = new ArrayList();
        this.organizeRelationService.getListByTypeAndOrgId("Role", orgId).forEach(o -> ids.add(o.getObjectId()));
        QueryWrapper query = new QueryWrapper();
        if (ids.size() > 0) {
            query.lambda().in(PermissionEntityBase::getId, ids);
            return this.list((Wrapper)query);
        }
        return new ArrayList<RoleEntity>();
    }

    @Override
    public String getBindInfo(String roleId, List<String> reduceOrgIds) {
        if (reduceOrgIds.size() > 0) {
            StringBuilder info = new StringBuilder();
            RoleEntity roleEntity = this.getInfo(roleId);
            List<UserRelationEntity> bingUserByRoleList = this.userRelationService.getListByObjectId(roleId, "Role");
            if (bingUserByRoleList.size() < 1) {
                return null;
            }
            info.append("\u5df2\u7ed1\u5b9a\u7528\u6237\uff1a");
            boolean bindFlag = false;
            for (UserRelationEntity bingUser : bingUserByRoleList) {
                String userId = bingUser.getUserId();
                if (roleEntity.getGlobalMark() == GlobalMarkEnum.NOT_ORGANIZE.getCode()) {
                    UserEntity user = this.userService.getInfo(userId);
                    info.append("[ ").append(user.getRealName()).append(" ] ");
                    bindFlag = true;
                    continue;
                }
                List<UserRelationEntity> bingUserByOrg = this.userRelationService.getListByObjectType(userId, "Organize");
                block1: for (UserRelationEntity bingOrg : bingUserByOrg) {
                    String orgId = bingOrg.getObjectId();
                    for (String reduceOrgId : reduceOrgIds) {
                        if (reduceOrgId.equals(orgId)) {
                            OrganizeEntity org = this.organizeService.getInfo(orgId);
                            UserEntity user = this.userService.getInfo(bingOrg.getUserId());
                            info.append("[").append(org.getFullName()).append("\uff1a\u7528\u6237\uff08").append(user.getRealName()).append("\uff09]; ");
                            bindFlag = false;
                            continue block1;
                        }
                        bindFlag = true;
                    }
                }
            }
            if (bindFlag) {
                return info.toString();
            }
            return null;
        }
        return null;
    }
}

