/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.PinYinUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.base.util.RemoveUtil;
import com.bringspring.system.external.service.SynPushToThirdQyService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.model.message.SynThirdInfoCrForm;
import com.bringspring.system.message.service.SynThirdDingTalkService;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.permission.entity.AuthorizeEntity;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.mapper.OrganizeMapper;
import com.bringspring.system.permission.mapper.UserMapper;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.model.user.mod.UserImportModel;
import com.bringspring.system.permission.model.user.page.PaginationUser;
import com.bringspring.system.permission.model.user.vo.UserExportExceptionVO;
import com.bringspring.system.permission.model.user.vo.UserExportVO;
import com.bringspring.system.permission.model.user.vo.UserImportVO;
import com.bringspring.system.permission.model.user.vo.UserListVO;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DSTransactional
public class UserServiceImpl
extends ServiceImpl<UserMapper, UserEntity>
implements UserService {
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private DataSourceModel dataSourceModel;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private SynThirdDingTalkService synThirdDingTalkService;
    @Autowired
    private SynPushToThirdQyService synPushToThirdQyService;
    @Autowired
    private OrganizeMapper organizeMapper;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private Executor threadPoolExecutor;

    @Override
    public List<UserEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<UserEntity> getUserByIds(List<String> ids) {
        List<UserEntity> list = new ArrayList<UserEntity>();
        ids.removeAll(Collections.singleton(null));
        if (ids.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserEntity::getId, ids);
            ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
            list = this.list((Wrapper)queryWrapper);
        }
        return list;
    }

    @Override
    public List<UserEntity> getUserByOrgIds(List<String> orgIds) {
        List<UserEntity> list = new ArrayList<UserEntity>();
        if (orgIds.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserEntity::getOrganizeId, orgIds);
            ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
            list = this.list((Wrapper)queryWrapper);
        }
        return list;
    }

    @Override
    public List<UserEntity> getUserNameList(Set<String> idList) {
        if (idList.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().select(new SFunction[]{UserEntity::getId, UserEntity::getRealName}).in(UserEntity::getId, idList);
            return this.list((Wrapper)queryWrapper);
        }
        return new ArrayList<UserEntity>();
    }

    @Override
    public UserEntity getByRealName(String realName) {
        UserEntity userEntity = new UserEntity();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(UserEntity::getRealName, (Object)realName);
        queryWrapper.lambda().select(new SFunction[]{UserEntity::getId});
        List list = this.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            userEntity = (UserEntity)list.get(0);
        }
        return userEntity;
    }

    @Override
    public List<UserEntity> getAdminList() {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(UserEntity::getIsAdministrator, (Object)1);
        ((LambdaQueryWrapper)query.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
        return this.list((Wrapper)query);
    }

    @Override
    public List<UserEntity> getList(Pagination pagination, String organizeId, Boolean flag) {
        Page page;
        IPage iPage;
        boolean filterLastTime = false;
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(new SFunction[]{UserEntity::getId});
        if (flag.booleanValue()) {
            queryWrapper.lambda().ne(UserEntity::getId, (Object)userId);
        }
        if (!StringUtils.isEmpty((String)organizeId)) {
            List<String> orgIdList = this.organizeService.getUnderOrganizations(organizeId);
            PageHelper.startPage((int)((int)pagination.getCurrentPage()), (int)((int)pagination.getPageSize()));
            List<String> query = null;
            String dbSchema = "";
            dbSchema = Boolean.parseBoolean(this.configValueUtil.getMultiTenancy()) ? DataSourceContextHolder.getDatasourceName() : this.dataSourceModel.getDbSchema();
            query = "kingbasees".equalsIgnoreCase(this.dataSourceModel.getDbType()) ? this.userMapper.queryKingbase(organizeId, orgIdList, pagination.getKeyword(), dbSchema, null, null) : ("oracle".equalsIgnoreCase(this.dataSourceModel.getDbType()) ? this.userMapper.queryOracle(organizeId, orgIdList, pagination.getKeyword(), null, null) : ("dm8".equalsIgnoreCase(this.dataSourceModel.getDbType()) ? this.userMapper.queryDm(organizeId, orgIdList, pagination.getKeyword(), dbSchema, null, null) : this.userMapper.query(organizeId, orgIdList, pagination.getKeyword(), null, null)));
            PageInfo pageInfo = new PageInfo(query);
            pagination.setTotal(pageInfo.getTotal());
            pagination.setCurrentPage((long)pageInfo.getPageNum());
            pagination.setPageSize((long)pageInfo.getPageSize());
            if (pageInfo.getList().size() > 0) {
                ArrayList<UserEntity> entityList = new ArrayList<UserEntity>(16);
                for (Object userIds : pageInfo.getList()) {
                    QueryWrapper queryWrapper1 = new QueryWrapper();
                    queryWrapper1.lambda().eq(UserEntity::getId, userIds);
                    entityList.add((UserEntity)this.getOne((Wrapper)queryWrapper1));
                }
                return entityList;
            }
            return new ArrayList<UserEntity>();
        }
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            filterLastTime = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(UserEntity::getAccount, (Object)pagination.getKeyword())).or()).like(UserEntity::getRealName, (Object)pagination.getKeyword())).or()).like(UserEntity::getMobilePhone, (Object)pagination.getKeyword());
            });
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
        if (filterLastTime) {
            queryWrapper.lambda().orderByDesc(UserEntity::getLastModifyTime);
        }
        if (!(iPage = this.page((IPage)(page = new Page(pagination.getCurrentPage(), pagination.getPageSize())), (Wrapper)queryWrapper)).getRecords().isEmpty()) {
            List ids = iPage.getRecords().stream().map(m -> m.getId()).collect(Collectors.toList());
            queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserEntity::getId, ids);
            ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
            if (filterLastTime) {
                queryWrapper.lambda().orderByDesc(UserEntity::getLastModifyTime);
            }
            iPage.setRecords(this.list((Wrapper)queryWrapper));
        }
        return pagination.setData(iPage.getRecords(), iPage.getTotal());
    }

    @Override
    public List<UserEntity> authorizeAddressGetList(PaginationUser pagination, String organizeId, Boolean flag) {
        Page page;
        IPage iPage;
        boolean filterLastTime = false;
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(new SFunction[]{UserEntity::getId});
        if (flag.booleanValue()) {
            queryWrapper.lambda().ne(UserEntity::getId, (Object)userId);
        }
        if (!StringUtils.isEmpty((String)organizeId)) {
            List<String> orgIdList = this.organizeService.getUnderOrganizations(organizeId);
            PageHelper.startPage((int)((int)pagination.getCurrentPage()), (int)((int)pagination.getPageSize()));
            List<String> query = null;
            String dbSchema = "";
            dbSchema = Boolean.parseBoolean(this.configValueUtil.getMultiTenancy()) ? DataSourceContextHolder.getDatasourceName() : this.dataSourceModel.getDbSchema();
            query = "kingbasees".equalsIgnoreCase(this.dataSourceModel.getDbType()) ? this.userMapper.queryKingbase(organizeId, orgIdList, pagination.getKeyword(), dbSchema, null, null) : ("oracle".equalsIgnoreCase(this.dataSourceModel.getDbType()) ? this.userMapper.queryOracle(organizeId, orgIdList, pagination.getKeyword(), null, null) : ("dm8".equalsIgnoreCase(this.dataSourceModel.getDbType()) ? this.userMapper.queryDm(organizeId, orgIdList, pagination.getKeyword(), dbSchema, null, null) : this.userMapper.query(organizeId, orgIdList, pagination.getKeyword(), null, null)));
            PageInfo pageInfo = new PageInfo(query);
            pagination.setTotal(pageInfo.getTotal());
            pagination.setCurrentPage(pageInfo.getPageNum());
            pagination.setPageSize(pageInfo.getPageSize());
            if (pageInfo.getList().size() > 0) {
                ArrayList<UserEntity> entityList = new ArrayList<UserEntity>(16);
                for (Object userIds : pageInfo.getList()) {
                    QueryWrapper queryWrapper1 = new QueryWrapper();
                    queryWrapper1.lambda().eq(UserEntity::getId, userIds);
                    entityList.add((UserEntity)this.getOne((Wrapper)queryWrapper1));
                }
                return entityList;
            }
            return new ArrayList<UserEntity>();
        }
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            filterLastTime = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(UserEntity::getAccount, (Object)pagination.getKeyword())).or()).like(UserEntity::getRealName, (Object)pagination.getKeyword())).or()).like(UserEntity::getMobilePhone, (Object)pagination.getKeyword());
            });
        }
        if (StringUtils.isNotEmpty((String)pagination.getAlreadyAuthorize())) {
            List area = this.userRelationService.list((Wrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)"Area"));
            if (ObjectUtil.isNull((Object)area)) {
                return new ArrayList<UserEntity>();
            }
            List collect = area.stream().map(UserRelationEntity::getUserId).distinct().collect(Collectors.toList());
            ((LambdaQueryWrapper)queryWrapper.lambda().in(UserEntity::getId, collect)).eq(UserEntity::getEnabledMark, (Object)"1");
        }
        if (StringUtils.isNotEmpty((String)pagination.getAlreadyAuthorize()) && StringUtils.isNotEmpty((String)pagination.getOrganizeFlag())) {
            OrganizeEntity one = (OrganizeEntity)this.organizeService.getOne((Wrapper)Wrappers.lambdaQuery().eq(OrganizeEntity::getId, (Object)pagination.getOrganizeFlag()));
            List allUserList = this.list((Wrapper)Wrappers.lambdaQuery().like(UserEntity::getCode, (Object)one.getEnCode()));
            List areaUserList = this.userRelationService.list((Wrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)"Area"));
            List allUserListIds = allUserList.stream().map(UserEntity::getId).collect(Collectors.toList());
            List areaUserListIds = areaUserList.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
            List userListIds = allUserListIds.stream().filter(areaUserListIds::contains).collect(Collectors.toList());
            queryWrapper.lambda().in(UserEntity::getId, userListIds);
        }
        if (StringUtils.isNotEmpty(pagination.getAddress()) && pagination.getAddress().size() < 2 && pagination.getAddress().get(0).equals("10")) {
            pagination.setAddress(null);
        }
        if (!StringUtils.isEmpty(pagination.getAddress())) {
            QueryWrapper userRelationEntityQueryWrapper = new QueryWrapper();
            List addressList = JsonUtil.getJsonToList(pagination.getAddress(), String.class);
            if (addressList.size() > 1) {
                String collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                collect = "[" + collect;
                String s2 = (String)addressList.get(0);
                s2 = "[\"" + s2 + "\"]";
                ((LambdaQueryWrapper)((LambdaQueryWrapper)userRelationEntityQueryWrapper.lambda().like(UserRelationEntity::getObjectId, (Object)collect)).or()).eq(UserRelationEntity::getObjectId, (Object)s2);
            } else {
                String s3 = (String)addressList.get(addressList.size() - 1);
                s3 = "[\"" + s3;
                ((LambdaQueryWrapper)userRelationEntityQueryWrapper.lambda().likeRight(UserRelationEntity::getObjectType, (Object)"Area")).like(UserRelationEntity::getObjectId, (Object)s3);
            }
            List list = this.userRelationService.list((Wrapper)userRelationEntityQueryWrapper);
            if (ObjectUtil.isNotEmpty((Object)list)) {
                List collect = list.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
                queryWrapper.lambda().in(UserEntity::getId, collect);
            } else {
                return new ArrayList<UserEntity>();
            }
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
        if (filterLastTime) {
            queryWrapper.lambda().orderByDesc(UserEntity::getLastModifyTime);
        }
        if (!(iPage = this.page((IPage)(page = new Page(pagination.getCurrentPage(), pagination.getPageSize())), (Wrapper)queryWrapper)).getRecords().isEmpty()) {
            List ids = iPage.getRecords().stream().map(m -> m.getId()).collect(Collectors.toList());
            queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserEntity::getId, ids);
            ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
            if (filterLastTime) {
                queryWrapper.lambda().orderByDesc(UserEntity::getLastModifyTime);
            }
            iPage.setRecords(this.list((Wrapper)queryWrapper));
        }
        return pagination.setData(iPage.getRecords(), iPage.getTotal());
    }

    @Override
    public List<UserEntity> getList(String keyword) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().ne(UserEntity::getEnabledMark, (Object)0);
        if (StringUtils.isNotEmpty((String)keyword)) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(UserEntity::getAccount, (Object)keyword)).or()).like(UserEntity::getRealName, (Object)keyword)).or()).like(UserEntity::getMobilePhone, (Object)keyword);
            });
        }
        queryWrapper.lambda().select(new SFunction[]{UserEntity::getId, UserEntity::getAccount, UserEntity::getRealName});
        Page page = new Page(1L, 50L);
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return iPage.getRecords();
    }

    @Override
    public List<UserEntity> getListByOrganizeId(String organizeId, String keyword) {
        List userIds = this.userRelationService.getListByObjectId(organizeId, "Organize").stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
        if (userIds.size() > 0) {
            QueryWrapper query = new QueryWrapper();
            if (userIds.size() > 0) {
                query.lambda().in(UserEntity::getId, userIds);
            }
            if (StringUtils.isNotEmpty((String)keyword)) {
                query.lambda().and(t -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(UserEntity::getAccount, (Object)keyword)).or()).like(UserEntity::getRealName, (Object)keyword);
                });
            }
            query.lambda().eq(UserEntity::getEnabledMark, (Object)1);
            ((LambdaQueryWrapper)query.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
            return this.list((Wrapper)query);
        }
        return new ArrayList<UserEntity>(0);
    }

    @Override
    public List<UserEntity> getListByManagerId(String managerId, String keyword) {
        List<UserRelationEntity> listByOrgId;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(UserEntity::getManagerId, (Object)managerId);
        List<OrganizeEntity> listAscByManagerId = this.organizeService.getListAscByManagerId(managerId);
        List<String> orgIds = listAscByManagerId.stream().map(OrganizeEntity::getId).collect(Collectors.toList());
        List<Object> userIds = new ArrayList();
        if (null != orgIds && orgIds.size() > 0 && null != (userIds = (listByOrgId = this.userRelationService.getListByOrgId(orgIds)).stream().map(UserRelationEntity::getUserId).collect(Collectors.toList())) && userIds.size() > 0) {
            ((LambdaQueryWrapper)queryWrapper.lambda().or()).in(UserEntity::getId, userIds);
        }
        if (StringUtils.isNotEmpty((String)keyword)) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(UserEntity::getAccount, (Object)keyword)).or()).like(UserEntity::getRealName, (Object)keyword);
            });
        }
        queryWrapper.lambda().eq(UserEntity::getEnabledMark, (Object)1);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public UserEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(UserEntity::getId, (Object)id);
        return (UserEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<UserEntity> getInfoByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(UserEntity::getCode, (Object)code);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public UserEntity getUserByAccount(String account) throws LoginException {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(UserEntity::getAccount, (Object)account)).or()).eq(UserEntity::getEmail, (Object)account)).or()).eq(UserEntity::getMobilePhone, (Object)account);
        List userEntityList = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)userEntityList) && userEntityList.size() > 1) {
            String errorMessage = String.format(MsgCode.LOG014.get(), new Object[0]);
            throw new LoginException(errorMessage);
        }
        UserEntity userEntity = userEntityList.stream().findFirst().orElse(null);
        return userEntity;
    }

    @Override
    public UserEntity getUserEntity(String account, String phone, String email) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(UserEntity::getAccount, (Object)account)).or()).eq(UserEntity::getEmail, (Object)phone)).or()).eq(UserEntity::getMobilePhone, (Object)email);
        List userEntityList = this.list((Wrapper)queryWrapper);
        UserEntity userEntity = userEntityList.stream().findFirst().orElse(null);
        return userEntity;
    }

    @Override
    public Boolean setAdminListByIds(List<String> adminIds) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(UserEntity::getIsAdministrator, (Object)1);
        query.lambda().ne(UserEntity::getId, (Object)"admin");
        List list1 = this.list((Wrapper)query);
        for (UserEntity entity : list1) {
            entity.setIsAdministrator(0);
            this.updateById(entity);
        }
        ArrayList list = new ArrayList();
        adminIds.remove("admin");
        adminIds.stream().forEach(adminId -> {
            UserEntity userEntity = new UserEntity();
            userEntity.setId((String)adminId);
            userEntity.setIsAdministrator(1);
            list.add(userEntity);
        });
        return this.updateBatchById(list);
    }

    @Override
    public boolean isExistByAccount(String account) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(UserEntity::getAccount, (Object)account)).or()).eq(UserEntity::getEmail, (Object)account)).or()).eq(UserEntity::getMobilePhone, (Object)account);
        UserEntity entity = (UserEntity)this.getOne((Wrapper)queryWrapper);
        return entity != null;
    }

    @Override
    @DSTransactional
    public Boolean create(UserEntity entity) throws PermissionException {
        String oldHeadIcon = entity.getHeadIcon();
        if (StringUtils.isEmpty((String)oldHeadIcon)) {
            entity.setHeadIcon("/api/file/Image/userAvatar/001.png");
        }
        if (this.isExistByAccount(entity.getAccount())) {
            throw new PermissionException("\u8d26\u6237\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        String userId = "";
        if (ObjectUtil.isEmpty((Object)entity.getId())) {
            userId = RandomUtil.uuId();
            entity.setId(userId);
        } else {
            userId = entity.getId();
        }
        entity.setSecretkey(RandomUtil.uuId());
        entity.setPassword(this.getDefaultPassword(entity.getSecretkey()));
        entity.setIsAdministrator(0);
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.saveOrUpdateCommon(userId, entity);
        this.save(entity);
        UserInfo operatorUser = this.userProvider.get();
        this.threadPoolExecutor.execute(() -> {
            try {
                this.synPushToThirdQyService.createUserSysToQy(operatorUser, false, entity, null);
            }
            catch (Exception e) {
                this.log.error("\u6dfb\u52a0\u7528\u6237\u4e4b\u540e\u540c\u6b65\u5931\u8d25\u5230\u4f01\u4e1a\u5fae\u4fe1\u6216\u9489\u9489\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
            }
        });
        String catchKey = this.cacheKeyUtil.getAllUser();
        if (this.redisUtil.exists(catchKey)) {
            this.redisUtil.remove(catchKey);
        }
        return true;
    }

    @Override
    @DSTransactional
    public Boolean createUser(UserEntity entity) {
        entity.setSecretkey(RandomUtil.uuId());
        entity.setId(RandomUtil.uuId());
        entity.setPassword(this.getDefaultPassword(entity.getSecretkey()));
        entity.setIsAdministrator(0);
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.saveOrUpdateCommon(entity.getId(), entity);
        this.save(entity);
        return true;
    }

    @Override
    @DSTransactional
    public Boolean update(String userId, UserEntity entity) throws PermissionException {
        UserEntity originUser = this.getInfo(userId);
        UserInfo operatorUser = this.userProvider.get();
        if ("1".equals(String.valueOf(originUser.getIsAdministrator()))) {
            if (operatorUser.getIsAdministrator().booleanValue()) {
                if (!"admin".equals(operatorUser.getUserId()) && !operatorUser.getUserId().equals(userId)) {
                    throw new PermissionException("\u7ba1\u7406\u5458\u53ea\u80fd\u4fee\u6539\u81ea\u5df1\uff0c\u4e0d\u80fd\u4fee\u6539\u5176\u4ed6\u7ba1\u7406\u5458");
                }
            } else {
                throw new PermissionException("\u65e0\u6cd5\u4fee\u6539\u7ba1\u7406\u5458\u8d26\u6237");
            }
        }
        if (userId.equals(entity.getManagerId())) {
            throw new PermissionException("\u76f4\u5c5e\u4e3b\u7ba1\u4e0d\u80fd\u662f\u81ea\u5df1");
        }
        if (!originUser.getAccount().equals(entity.getAccount()) && this.isExistByAccount(entity.getAccount())) {
            throw new PermissionException("\u8d26\u6237\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        boolean subordinate = this.isSubordinate(userId, entity.getManagerId());
        if (subordinate) {
            throw new PermissionException("\u76f4\u5c5e\u4e3b\u7ba1\u4e0d\u80fd\u662f\u6211\u7684\u4e0b\u5c5e\u7528\u6237");
        }
        if ("2".equals(String.valueOf(entity.getEnabledMark()))) {
            entity.setUnlockTime(null);
            entity.setLogErrorCount(0);
        }
        if (originUser.getEnabledMark() == 2 && entity.getEnabledMark() == 1) {
            entity.setUnlockTime(null);
            entity.setLogErrorCount(0);
        }
        entity.setId(userId);
        entity.setLastModifyTime(DateUtil.getNowDate());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        this.saveOrUpdateCommon(userId, entity);
        this.updateById(entity);
        List area = this.userRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)"Area")).eq(UserRelationEntity::getUserId, (Object)originUser.getId()));
        List<String> ids = area.stream().map(UserRelationEntity::getId).collect(Collectors.toList());
        this.userRelationService.delete(ids.toArray(new String[0]));
        if (ObjectUtil.isNotEmpty(entity.getAuthorizeAddress())) {
            UserRelationEntity userRelationEntity = new UserRelationEntity();
            userRelationEntity.setUserId(originUser.getId());
            userRelationEntity.setObjectType("Area");
            userRelationEntity.setCreatorUserId(operatorUser.getUserId());
            userRelationEntity.setCreatorTime(DateUtil.getNowDate());
            for (String authorizeAddress : entity.getAuthorizeAddress()) {
                String mainId = RandomUtil.uuId();
                userRelationEntity.setId(mainId);
                String collect = "";
                String[] split = authorizeAddress.replace("[\"", "").replace("\"]", "").replaceAll("\"", "").split(",");
                ArrayList<String> list1 = new ArrayList<String>();
                for (String s2 : split) {
                    list1.add(s2);
                }
                collect = list1.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                collect = "[" + collect + "]";
                userRelationEntity.setObjectId(collect);
                this.userRelationService.save(userRelationEntity);
            }
        }
        if (this.synPushToThirdQyService.triggeringCondition(originUser, entity)) {
            this.threadPoolExecutor.execute(() -> {
                try {
                    this.synPushToThirdQyService.updateUserSysToQy(operatorUser, false, entity, null);
                }
                catch (Exception e) {
                    this.log.error("\u4fee\u6539\u7528\u6237\u4e4b\u540e\u540c\u6b65\u5931\u8d25\u5230\u4f01\u4e1a\u5fae\u4fe1\u6216\u9489\u9489\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
        this.delCurUser(Collections.singletonList(userId));
        return true;
    }

    @Override
    public Boolean saveOrUpdateCommon(String userId, UserEntity entity) {
        List<String> userAllOrgIds = Arrays.asList(entity.getOrganizeId().split(","));
        ArrayList<String> userAllPosIds = StringUtils.isNotEmpty((String)entity.getPositionId()) ? Arrays.asList(entity.getPositionId().split(",")) : new ArrayList<String>();
        ArrayList<String> userAllRoleIds = StringUtils.isNotEmpty((String)entity.getRoleId()) ? Arrays.asList(entity.getRoleId().split(",")) : new ArrayList<String>();
        ArrayList<UserRelationEntity> relationList = new ArrayList<UserRelationEntity>();
        this.setUserRelation(relationList, "Organize", userAllOrgIds, entity);
        this.setUserRelation(relationList, "Position", userAllPosIds, entity);
        this.setUserRelation(relationList, "Role", userAllRoleIds, entity);
        if (userId != null) {
            this.userRelationService.deleteAllByUserId(userId);
        }
        if (relationList.size() > 0) {
            this.userRelationService.saveBatch(relationList);
        }
        String majorOrgId = "";
        String majorPosId = "";
        UserEntity userEntity = this.getInfo(userId);
        if (userEntity != null) {
            majorOrgId = userEntity.getOrganizeId();
            majorPosId = userEntity.getPositionId();
        }
        majorOrgId = this.organizeRelationService.autoGetMajorOrganizeId(userId, userAllOrgIds, majorOrgId);
        entity.setOrganizeId(majorOrgId);
        if (userAllPosIds.size() > 0) {
            entity.setPositionId(this.organizeRelationService.autoGetMajorPositionId(userId, majorOrgId, majorPosId));
        } else {
            entity.setPositionId("");
        }
        entity.setQuickQuery(PinYinUtil.getFirstSpell((String)entity.getRealName()));
        this.redisUtil.remove(this.cacheKeyUtil.getAllUser());
        return true;
    }

    private void setUserRelation(List<UserRelationEntity> relationList, String objectType, List<String> ids, UserEntity userEntity) {
        for (String id : ids) {
            UserRelationEntity relationEntity = new UserRelationEntity();
            relationEntity.setId(RandomUtil.uuId());
            relationEntity.setObjectType(objectType);
            relationEntity.setObjectId(id);
            relationEntity.setUserId(userEntity.getId());
            relationEntity.setCreatorTime(userEntity.getCreatorTime());
            relationEntity.setCreatorUserId(userEntity.getCreatorUserId());
            relationList.add(relationEntity);
        }
    }

    @Override
    @DSTransactional
    public Boolean updateMangerIdByOrganizeId(String organizeId, String managerId) {
        List userIds = this.userRelationService.getListByObjectId(organizeId, "Organize").stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
        if (userIds.size() > 0) {
            QueryWrapper query = new QueryWrapper();
            if (userIds.size() > 0) {
                query.lambda().in(UserEntity::getId, userIds);
            }
            ((LambdaQueryWrapper)query.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
            List userList = this.list((Wrapper)query);
            for (UserEntity userEntity : userList) {
                userEntity.setManagerId(managerId);
            }
            this.updateBatchById(userList);
        }
        return true;
    }

    @Override
    @DSTransactional
    public void delete(UserEntity entity) throws PermissionException {
        this.delete(entity, null);
    }

    @Override
    @DSTransactional
    public void delete(UserEntity entity, String actionType) throws PermissionException {
        if ("1".equals(String.valueOf(entity.getIsAdministrator()))) {
            throw new PermissionException("\u65e0\u6cd5\u5220\u9664\u7ba1\u7406\u5458\u8d26\u6237");
        }
        if (this.organizeService.getList().stream().filter(t -> entity.getId().equals(t.getManagerId())).collect(Collectors.toList()).size() > 0) {
            throw new PermissionException("\u6b64\u7528\u6237\u4e3a\u67d0\u90e8\u95e8\u4e3b\u7ba1\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        if (this.getListByManagerId(entity.getId(), null).size() > 0) {
            throw new PermissionException("\u6b64\u7528\u6237\u6709\u4e0b\u5c5e\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        String tenantId = StringUtils.isEmpty((String)this.userProvider.get().getTenantId()) ? "" : this.userProvider.get().getTenantId();
        String catchKey = tenantId + "allUser";
        if (this.redisUtil.exists(catchKey)) {
            this.redisUtil.remove(catchKey);
        }
        this.removeById((Serializable)((Object)entity.getId()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(UserRelationEntity::getUserId, (Object)entity.getId());
        this.userRelationService.remove((Wrapper)queryWrapper);
        if (StringUtils.isEmpty((String)actionType) || actionType.equals("sys_delete")) {
            UserInfo operatorUser = this.userProvider.get();
            this.threadPoolExecutor.execute(() -> {
                try {
                    this.synPushToThirdQyService.deleteUserSysToQy(operatorUser, false, entity.getId(), null);
                }
                catch (Exception e) {
                    this.log.error("\u5220\u9664\u7528\u6237\u4e4b\u540e\u540c\u6b65\u5931\u8d25\u5230\u4f01\u4e1a\u5fae\u4fe1\u6216\u9489\u9489\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
        this.userProvider.removeOnLine(entity.getId());
        RemoveUtil.removeOnline(entity.getId());
    }

    @Override
    public void updatePassword(UserEntity entity) {
        entity.setSecretkey(RandomUtil.uuId());
        entity.setPassword(Md5Util.getStringMd5((String)(entity.getPassword().toLowerCase() + entity.getSecretkey().toLowerCase())));
        entity.setChangePasswordDate(DateUtil.getNowDate());
        this.updateById(entity);
    }

    @Override
    public List<UserEntity> getUserName(List<String> id) {
        List<UserEntity> list = new ArrayList<UserEntity>();
        id.removeAll(Collections.singleton(null));
        if (id.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserEntity::getId, id);
            list = this.list((Wrapper)queryWrapper);
        }
        return list;
    }

    @Override
    public List<UserEntity> getUserList(List<String> id) {
        List<UserEntity> list = new ArrayList<UserEntity>();
        id.removeAll(Collections.singleton(null));
        if (id.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserEntity::getId, id);
            queryWrapper.lambda().ne(UserEntity::getEnabledMark, (Object)0);
            queryWrapper.lambda().select(new SFunction[]{UserEntity::getId});
            list = this.list((Wrapper)queryWrapper);
        }
        return list;
    }

    @Override
    public List<String> getListId() {
        return ((UserMapper)this.baseMapper).getListId();
    }

    @Override
    public void update(UserEntity entity, String type) {
        UpdateWrapper wrapper = new UpdateWrapper();
        if ("Position".equals(type)) {
            wrapper.lambda().set(UserEntity::getPositionId, (Object)entity.getPositionId());
        } else {
            wrapper.lambda().set(UserEntity::getRoleId, (Object)entity.getRoleId());
        }
        wrapper.lambda().eq(UserEntity::getId, (Object)entity.getId());
        this.update((Wrapper)wrapper);
    }

    @Override
    public boolean isSubordinate(String id, String managerId) {
        int num = 0;
        return this.recursionSubordinates(id, managerId, num);
    }

    @Override
    public DownloadVO exportExcel(String dataType, String selectKey, PaginationUser pagination) {
        List<Object> entityList = new ArrayList();
        if ("0".equals(dataType)) {
            entityList = this.getList(pagination, pagination.getOrganizeId(), false);
        } else if ("1".equals(dataType)) {
            entityList = this.getList();
        }
        ArrayList<UserExportVO> modeList = new ArrayList<UserExportVO>();
        List<Object> organizeList = null;
        if (entityList.size() > 300) {
            organizeList = new ArrayList(100);
            List<String> organizeId = entityList.stream().map(t -> t.getOrganizeId()).collect(Collectors.toList());
            organizeList = this.organizeService.getOrganizeName(organizeId);
        }
        for (UserEntity userEntity : entityList) {
            DictionaryDataEntity dictionaryDataEntity;
            Object positionEntity;
            UserExportVO model = new UserExportVO();
            model.setAccount(userEntity.getAccount());
            model.setRealName(userEntity.getRealName());
            StringBuffer stringBuffer = new StringBuffer();
            List<UserRelationEntity> allOrgRelationByUserId = this.userRelationService.getAllOrgRelationByUserId(userEntity.getId());
            for (UserRelationEntity userRelationEntity : allOrgRelationByUserId) {
                String id = userRelationEntity.getObjectId();
                Object organize = null;
                organize = organizeList != null ? (OrganizeEntity)organizeList.stream().filter(t -> id.equals(t.getId())).findFirst().orElse(null) : this.organizeService.getInfo(id);
                if (organize == null || !StringUtils.isNotEmpty((String)((OrganizeEntity)organize).getOrganizeIdTree())) continue;
                String[] split = ((OrganizeEntity)organize).getOrganizeIdTree().split(",");
                StringBuffer organizeIdTree = new StringBuffer();
                for (String parentId : split) {
                    OrganizeEntity organizes = null;
                    organizes = organizeList != null ? (OrganizeEntity)organizeList.stream().filter(t -> parentId.equals(t.getId())).findFirst().orElse(null) : this.organizeService.getInfo(parentId);
                    if (!Objects.nonNull(organizes) || !StringUtils.isNotEmpty((String)organizes.getFullName())) continue;
                    organizeIdTree.append("/" + organizes.getFullName());
                }
                String toString = organizeIdTree.toString();
                if (!StringUtils.isNotEmpty((String)toString)) continue;
                String organizeId = toString.replaceFirst("/", "");
                stringBuffer.append("," + organizeId);
            }
            model.setOrganizeId(stringBuffer.toString().replaceFirst(",", ""));
            UserEntity info = this.getInfo(userEntity.getManagerId());
            if (Objects.nonNull(info) && StringUtils.isNotEmpty((String)info.getRealName()) && StringUtils.isNotEmpty((String)info.getAccount())) {
                model.setManagerId(info.getRealName());
            }
            List<UserRelationEntity> listByObjectType = this.userRelationService.getListByObjectType(userEntity.getId(), "Position");
            StringBuffer positionName = new StringBuffer();
            for (UserRelationEntity userRelationEntity : listByObjectType) {
                if (!StringUtils.isNotEmpty((String)userRelationEntity.getObjectId()) || !Objects.nonNull(positionEntity = this.positionService.getInfo(userRelationEntity.getObjectId()))) continue;
                positionName.append("," + ((PermissionEntityBase)positionEntity).getFullName() + "/" + ((PermissionEntityBase)positionEntity).getEnCode());
            }
            if (positionName.length() > 0) {
                model.setPositionId(positionName.toString().replaceFirst(",", ""));
            }
            List<UserRelationEntity> listByObjectType1 = this.userRelationService.getListByObjectType(userEntity.getId(), "Role");
            StringBuffer roleName = new StringBuffer();
            positionEntity = listByObjectType1.iterator();
            while (positionEntity.hasNext()) {
                RoleEntity roleEntity;
                UserRelationEntity userRelationEntity = (UserRelationEntity)positionEntity.next();
                if (!StringUtils.isNotEmpty((String)userRelationEntity.getObjectId()) || !Objects.nonNull(roleEntity = this.roleService.getInfo(userRelationEntity.getObjectId()))) continue;
                roleName.append("," + roleEntity.getFullName());
            }
            if (roleName.length() > 0) {
                model.setRoleId(roleName.toString().replaceFirst(",", ""));
            }
            model.setDescription(userEntity.getDescription());
            if (userEntity.getGender() != null) {
                if (userEntity.getGender() == 1) {
                    model.setGender("\u7537");
                } else if (userEntity.getGender() == 2) {
                    model.setGender("\u5973");
                } else if (userEntity.getGender() == 3) {
                    model.setGender("\u4fdd\u5bc6");
                }
            }
            if (Objects.nonNull(dictionaryDataEntity = this.dictionaryDataService.getInfo(userEntity.getNation()))) {
                model.setNation(dictionaryDataEntity.getFullName());
            }
            model.setNativePlace(userEntity.getNativePlace());
            DictionaryDataEntity dictionaryDataEntity1 = this.dictionaryDataService.getInfo(userEntity.getCertificatesType());
            if (Objects.nonNull(dictionaryDataEntity1)) {
                model.setCertificatesType(dictionaryDataEntity1.getFullName());
            }
            model.setCertificatesNumber(userEntity.getCertificatesNumber());
            DictionaryDataEntity dictionaryDataEntity2 = this.dictionaryDataService.getInfo(userEntity.getEducation());
            if (Objects.nonNull(dictionaryDataEntity2)) {
                model.setEducation(dictionaryDataEntity2.getFullName());
            }
            SimpleDateFormat sf1 = new SimpleDateFormat("yyyy-MM-dd");
            if (userEntity.getBirthday() != null) {
                String birthday = sf1.format(userEntity.getBirthday());
                model.setBirthday(birthday);
            }
            model.setTelePhone(userEntity.getTelePhone());
            model.setLandline(userEntity.getLandline());
            model.setMobilePhone(userEntity.getMobilePhone());
            model.setEmail(userEntity.getEmail());
            model.setUrgentContacts(userEntity.getUrgentContacts());
            model.setUrgentTelePhone(userEntity.getUrgentTelePhone());
            model.setPostalAddress(userEntity.getPostalAddress());
            model.setSortCode(userEntity.getSortCode());
            if (userEntity.getEnabledMark() == 0) {
                model.setEnabledMark("\u7981\u7528");
            } else if (userEntity.getEnabledMark() == 1) {
                model.setEnabledMark("\u6b63\u5e38");
            } else {
                model.setEnabledMark("\u9501\u5b9a");
            }
            if (userEntity.getEntryDate() != null) {
                String entryDate = sf1.format(userEntity.getEntryDate());
                model.setEntryDate(entryDate);
            }
            modeList.add(model);
        }
        return this.exportUtil(selectKey, "\u7528\u6237\u4fe1\u606f", modeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadVO exportUtil(String selectKey, String explain, List<UserExportVO> modeList) {
        List list = JsonUtil.listToJsonField((List)JsonUtil.getJsonToList(modeList, UserExportVO.class));
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        String[] splitData = selectKey.split(",");
        if (splitData.length > 0) {
            for (int i = 0; i < splitData.length; ++i) {
                if (splitData[i].equals("account")) {
                    entitys.add(new ExcelExportEntity("\u8d26\u53f7", (Object)"account"));
                }
                if (splitData[i].equals("realName")) {
                    entitys.add(new ExcelExportEntity("\u59d3\u540d", (Object)"realName"));
                }
                if (splitData[i].equals("organizeId")) {
                    entitys.add(new ExcelExportEntity("\u6240\u5c5e\u7ec4\u7ec7", (Object)"organizeId"));
                }
                if (splitData[i].equals("managerId")) {
                    entitys.add(new ExcelExportEntity("\u76f4\u5c5e\u4e3b\u7ba1", (Object)"managerId"));
                }
                if (splitData[i].equals("positionId")) {
                    entitys.add(new ExcelExportEntity("\u5c97\u4f4d", (Object)"positionId"));
                }
                if (splitData[i].equals("roleId")) {
                    entitys.add(new ExcelExportEntity("\u89d2\u8272", (Object)"roleId"));
                }
                if (splitData[i].equals("description")) {
                    entitys.add(new ExcelExportEntity("\u8bf4\u660e", (Object)"description", 25));
                }
                if (splitData[i].equals("gender")) {
                    entitys.add(new ExcelExportEntity("\u6027\u522b", (Object)"gender"));
                }
                if (splitData[i].equals("nation")) {
                    entitys.add(new ExcelExportEntity("\u6c11\u65cf", (Object)"nation"));
                }
                if (splitData[i].equals("nativePlace")) {
                    entitys.add(new ExcelExportEntity("\u7c4d\u8d2f", (Object)"nativePlace"));
                }
                if (splitData[i].equals("certificatesType")) {
                    entitys.add(new ExcelExportEntity("\u8bc1\u4ef6\u7c7b\u578b", (Object)"certificatesType"));
                }
                if (splitData[i].equals("certificatesNumber")) {
                    entitys.add(new ExcelExportEntity("\u8bc1\u4ef6\u53f7\u7801", (Object)"certificatesNumber"));
                }
                if (splitData[i].equals("education")) {
                    entitys.add(new ExcelExportEntity("\u6587\u5316\u7a0b\u5ea6", (Object)"education"));
                }
                if (splitData[i].equals("birthday")) {
                    entitys.add(new ExcelExportEntity("\u751f\u65e5", (Object)"birthday"));
                }
                if (splitData[i].equals("telePhone")) {
                    entitys.add(new ExcelExportEntity("\u7535\u8bdd", (Object)"telePhone"));
                }
                if (splitData[i].equals("landline")) {
                    entitys.add(new ExcelExportEntity("\u56fa\u5b9a\u7535\u8bdd", (Object)"landline"));
                }
                if (splitData[i].equals("mobilePhone")) {
                    entitys.add(new ExcelExportEntity("\u624b\u673a", (Object)"mobilePhone"));
                }
                if (splitData[i].equals("email")) {
                    entitys.add(new ExcelExportEntity("\u90ae\u7bb1", (Object)"email"));
                }
                if (splitData[i].equals("urgentContacts")) {
                    entitys.add(new ExcelExportEntity("\u7d27\u6025\u8054\u7cfb\u4eba", (Object)"urgentContacts"));
                }
                if (splitData[i].equals("urgentTelePhone")) {
                    entitys.add(new ExcelExportEntity("\u7d27\u6025\u7535\u8bdd", (Object)"urgentTelePhone"));
                }
                if (splitData[i].equals("postalAddress")) {
                    entitys.add(new ExcelExportEntity("\u901a\u8baf\u5730\u5740", (Object)"postalAddress", 25));
                }
                if (splitData[i].equals("sortCode")) {
                    entitys.add(new ExcelExportEntity("\u6392\u5e8f\u7801", (Object)"sortCode"));
                }
                if (splitData[i].equals("enabledMark")) {
                    entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                }
                if (!splitData[i].equals("entryDate")) continue;
                entitys.add(new ExcelExportEntity("\u5165\u804c\u65e5\u671f", (Object)"entryDate"));
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u7528\u6237\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        DownloadVO vo = DownloadVO.builder().build();
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, (Collection)list);
                }
                String name = explain + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(fileName);
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(this.userProvider.get().getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u7528\u6237\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return vo;
    }

    @Override
    public Map<String, Object> importPreview(List<UserExportVO> personList) {
        int i;
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        for (i = 0; i < personList.size(); ++i) {
            HashMap<String, Object> dataRowMap = new HashMap<String, Object>();
            UserExportVO model = personList.get(i);
            dataRowMap.put("account", model.getAccount());
            dataRowMap.put("realName", model.getRealName());
            dataRowMap.put("organizeId", model.getOrganizeId());
            dataRowMap.put("managerId", model.getManagerId());
            dataRowMap.put("positionId", model.getPositionId());
            dataRowMap.put("roleId", model.getRoleId());
            dataRowMap.put("description", model.getDescription());
            dataRowMap.put("gender", model.getGender());
            dataRowMap.put("nation", model.getNation());
            dataRowMap.put("nativePlace", model.getNativePlace());
            dataRowMap.put("certificatesType", model.getCertificatesType());
            dataRowMap.put("certificatesNumber", model.getCertificatesNumber());
            dataRowMap.put("education", model.getEducation());
            dataRowMap.put("birthday", model.getBirthday());
            dataRowMap.put("telePhone", model.getTelePhone());
            dataRowMap.put("landline", model.getLandline());
            dataRowMap.put("mobilePhone", model.getMobilePhone());
            dataRowMap.put("email", model.getEmail());
            dataRowMap.put("urgentContacts", model.getUrgentContacts());
            dataRowMap.put("urgentTelePhone", model.getUrgentTelePhone());
            dataRowMap.put("postalAddress", model.getPostalAddress());
            dataRowMap.put("sortCode", model.getSortCode());
            dataRowMap.put("enabledMark", model.getEnabledMark());
            dataRowMap.put("entryDate", model.getEntryDate());
            dataRow.add(dataRowMap);
        }
        for (i = 1; i <= personList.size(); ++i) {
            HashMap<String, Object> columnsMap = new HashMap<String, Object>();
            columnsMap.put("AllowDBNull", true);
            columnsMap.put("AutoIncrement", false);
            columnsMap.put("AutoIncrementSeed", 0);
            columnsMap.put("AutoIncrementStep", 1);
            columnsMap.put("Caption", this.getColumns(i));
            columnsMap.put("ColumnMapping", 1);
            columnsMap.put("ColumnName", this.getColumns(i));
            columnsMap.put("Container", null);
            columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
            columnsMap.put("DateTimeMode", 3);
            columnsMap.put("DefaultValue", null);
            columnsMap.put("DesignMode", false);
            columnsMap.put("Expression", "");
            columnsMap.put("ExtendedProperties", "");
            columnsMap.put("MaxLength", -1);
            columnsMap.put("Namespace", "");
            columnsMap.put("Ordinal", 0);
            columnsMap.put("Prefix", "");
            columnsMap.put("ReadOnly", false);
            columnsMap.put("Site", null);
            columnsMap.put("Table", personList);
            columnsMap.put("Unique", false);
            columns.add(columnsMap);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    @Override
    public UserImportVO importData(List<UserExportVO> dataList) throws PermissionException {
        ArrayList<UserImportModel> importModels = new ArrayList<UserImportModel>(16);
        ArrayList<Object> exceptionList = new ArrayList<Object>(16);
        List<DictionaryDataEntity> dataServiceList = this.dictionaryDataService.getList("b6cd65a763fa45eb9fe98e5057693e40");
        List<DictionaryDataEntity> dataServiceList1 = this.dictionaryDataService.getList("7866376d5f694d4d851c7164bd00ebfc");
        List<DictionaryDataEntity> dataServiceList2 = this.dictionaryDataService.getList("6a6d6fb541b742fbae7e8888528baa16");
        Map<String, Long> collect = dataList.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getAccount())).collect(Collectors.groupingBy(t -> t.getAccount(), Collectors.counting()));
        List collect1 = collect.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        for (String account : collect1) {
            List collect2 = dataList.stream().filter(t -> account.equals(t.getAccount())).collect(Collectors.toList());
            dataList.removeAll(collect2);
            exceptionList.addAll(collect2);
        }
        for (UserExportVO exportVO : dataList) {
            String positionId;
            String account;
            UserEntity entity;
            String[] split1;
            UserImportModel model = new UserImportModel();
            if (StringUtils.isNotEmpty((String)exportVO.getAccount())) {
                UserEntity userByAccount = this.getUserByAccount(exportVO.getAccount());
                if (Objects.nonNull(userByAccount)) {
                    exceptionList.add(exportVO);
                    continue;
                }
                String regex = "^[a-z0-9A-Z\u4e00-\u9fa5]+$";
                if (!exportVO.getAccount().matches(regex)) {
                    exceptionList.add(exportVO);
                    continue;
                }
            } else {
                exceptionList.add(exportVO);
                continue;
            }
            model.setAccount(exportVO.getAccount());
            if (StringUtils.isEmpty((String)exportVO.getRealName())) {
                exceptionList.add(exportVO);
                continue;
            }
            model.setRealName(exportVO.getRealName());
            String organizeId = exportVO.getOrganizeId();
            if (StringUtils.isEmpty((String)organizeId)) {
                exceptionList.add(exportVO);
                continue;
            }
            String[] organizeIds = organizeId.split(",");
            StringBuffer stringBuffer = new StringBuffer();
            for (String id : organizeIds) {
                String[] split = id.split("/");
                boolean isOk = false;
                if (split.length > 0) {
                    OrganizeEntity organizeEntity = null;
                    List<OrganizeEntity> infoByFullName = this.organizeService.getListByFullName(split[0]);
                    for (OrganizeEntity entity2 : infoByFullName) {
                        if (!"-1".equals(entity2.getParentId())) continue;
                        organizeEntity = entity2;
                        break;
                    }
                    if (split.length > 1) {
                        block6: for (int i = 1; i < split.length; ++i) {
                            List<OrganizeEntity> infoByFullName1 = this.organizeService.getListByFullName(split[i]);
                            if (infoByFullName1.size() < 1) {
                                isOk = true;
                                break;
                            }
                            for (OrganizeEntity entity3 : infoByFullName1) {
                                if (organizeEntity == null || !organizeEntity.getId().equals(entity3.getParentId())) continue;
                                organizeEntity = entity3;
                                continue block6;
                            }
                        }
                    }
                    if (isOk || !Objects.nonNull(organizeEntity) || model == null) continue;
                    stringBuffer.append("," + organizeEntity.getId());
                    continue;
                }
                exceptionList.add(exportVO);
            }
            if (stringBuffer.length() < 1) {
                exceptionList.add(exportVO);
                continue;
            }
            model.setOrganizeId(stringBuffer.toString().replaceFirst(",", ""));
            String managerId = exportVO.getManagerId();
            if (StringUtils.isNotEmpty((String)managerId) && (split1 = managerId.split("/")).length > 0 && Objects.nonNull(entity = this.getUserByAccount(account = split1[split1.length - 1])) && StringUtils.isNotEmpty((String)entity.getAccount())) {
                model.setManagerId(entity.getId());
            }
            if (StringUtils.isNotEmpty((String)(positionId = exportVO.getPositionId()))) {
                String[] positionIds;
                StringBuffer positionIdBuffer = new StringBuffer();
                for (String id : positionIds = positionId.split(",")) {
                    List<PositionEntity> positionEntityList;
                    String[] positionName = id.split("/");
                    if (positionName == null || positionName.length <= 1 || (positionEntityList = this.positionService.getListByFullName(positionName[0], positionName[1])) == null || positionEntityList.size() <= 0) continue;
                    PositionEntity positionEntity = positionEntityList.get(0);
                    positionIdBuffer.append("," + positionEntity.getId());
                }
                model.setPositionId(positionIdBuffer.toString().replaceFirst(",", ""));
            }
            if (StringUtils.isNotEmpty((String)exportVO.getRoleId())) {
                String[] roleNames = exportVO.getRoleId().split(",");
                StringBuffer roleId = new StringBuffer();
                for (String roleName : roleNames) {
                    RoleEntity roleEntity = this.roleService.getInfoByFullName(roleName);
                    if (!Objects.nonNull(roleEntity)) continue;
                    roleId.append("," + roleEntity.getId());
                }
                model.setRoleId(roleId.toString().replaceFirst(",", ""));
            }
            model.setDescription(exportVO.getDescription());
            if (StringUtils.isEmpty((String)exportVO.getGender())) {
                exceptionList.add(exportVO);
                continue;
            }
            if ("\u7537".equals(exportVO.getGender())) {
                model.setGender(1);
            } else if ("\u5973".equals(exportVO.getGender())) {
                model.setGender(2);
            } else {
                model.setGender(3);
            }
            if (StringUtils.isNotEmpty((String)exportVO.getNation())) {
                DictionaryDataEntity dataEntity = dataServiceList.stream().filter(t -> exportVO.getNation().equals(t.getFullName())).findFirst().orElse(null);
                model.setNation(dataEntity != null ? dataEntity.getFullName() : null);
            }
            model.setNativePlace(exportVO.getNativePlace());
            if (StringUtils.isNotEmpty((String)exportVO.getCertificatesType())) {
                DictionaryDataEntity dataEntity = dataServiceList1.stream().filter(t -> exportVO.getCertificatesType().equals(t.getFullName())).findFirst().orElse(null);
                model.setNation(dataEntity != null ? dataEntity.getFullName() : null);
            }
            model.setCertificatesNumber(exportVO.getCertificatesNumber());
            if (StringUtils.isNotEmpty((String)exportVO.getEducation())) {
                DictionaryDataEntity dataEntity = dataServiceList2.stream().filter(t -> exportVO.getEducation().equals(t.getFullName())).findFirst().orElse(null);
                model.setNation(dataEntity != null ? dataEntity.getFullName() : null);
            }
            if (StringUtils.isNotEmpty((String)exportVO.getBirthday())) {
                Date date = DateUtil.stringToDate((String)exportVO.getBirthday());
                model.setBirthday(date);
            }
            model.setTelePhone(exportVO.getTelePhone());
            model.setLandline(exportVO.getLandline());
            model.setEmail(exportVO.getEmail());
            model.setUrgentContacts(exportVO.getUrgentContacts());
            model.setUrgentTelePhone(exportVO.getUrgentTelePhone());
            model.setPostalAddress(exportVO.getPostalAddress());
            model.setSortCode(exportVO.getSortCode());
            if (StringUtils.isNotEmpty((String)exportVO.getEntryDate())) {
                Date date = DateUtil.stringToDate((String)exportVO.getEntryDate());
                model.setEntryDate(date);
            }
            if ("\u7981\u7528".equals(exportVO.getEnabledMark())) {
                model.setEnabledMark(0);
            } else if ("\u6b63\u5e38".equals(exportVO.getEnabledMark())) {
                model.setEnabledMark(1);
            } else {
                model.setEnabledMark(2);
            }
            importModels.add(model);
        }
        List entitys = JsonUtil.getJsonToList(importModels, UserEntity.class);
        int sum = 0;
        int num = 0;
        for (UserEntity entity : entitys) {
            entity.setHeadIcon("/api/file/Image/userAvatar/001.png");
            try {
                this.create(entity);
                ++sum;
            }
            catch (Exception e) {
                UserExportVO exportVO = dataList.stream().filter(t -> entity.getAccount().equals(t.getAccount())).findFirst().orElse(null);
                exceptionList.add(exportVO);
                this.log.error("\u5bfc\u5165\u7b2c" + (num + 1) + "\u6761\u6570\u636e\u5931\u8d25");
            }
        }
        UserImportVO vo = new UserImportVO();
        vo.setSnum(sum);
        if (exceptionList.size() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList(exceptionList, UserExportExceptionVO.class));
            vo.setFnum(exceptionList.size());
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    @Override
    public void getOrganizeIdTree(String organizeId, StringBuffer organizeParentIdList) {
        OrganizeEntity entity = this.organizeService.getInfo(organizeId);
        if (Objects.nonNull(entity) && StringUtils.isNotEmpty((String)entity.getParentId())) {
            organizeParentIdList.append(organizeId + ",");
            this.getOrganizeIdTree(entity.getParentId(), organizeParentIdList);
        }
    }

    @Override
    public DownloadVO exportExceptionData(List<UserExportVO> dataList) {
        DownloadVO vo = this.exportUtil("account,realName,gender,email,organizeId,managerId,positionId,roleId,sortCode,enabledMark,description,nation,nativePlace,entryDate,certificatesType,certificatesNumber,education,birthday,telePhone,landline,mobilePhone,urgentContacts,urgentTelePhone,postalAddress", "\u9519\u8bef\u62a5\u544a", dataList);
        return vo;
    }

    @Override
    public List<UserEntity> getUserName(List<String> id, Pagination pagination) {
        ArrayList list = new ArrayList();
        id.removeAll(Collections.singleton(null));
        if (id.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
                queryWrapper.lambda().and(t -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(UserEntity::getRealName, (Object)pagination.getKeyword())).or()).like(UserEntity::getAccount, (Object)pagination.getKeyword());
                });
            }
            queryWrapper.lambda().in(UserEntity::getId, id);
            queryWrapper.lambda().select(new SFunction[]{UserEntity::getId, UserEntity::getRealName, UserEntity::getAccount});
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(iPage.getRecords(), iPage.getTotal());
        }
        return pagination.setData(list, (long)list.size());
    }

    @Override
    public List<UserEntity> getListByRoleId(String roleId) {
        ArrayList<UserEntity> list = new ArrayList<UserEntity>();
        this.userRelationService.getListByRoleId(roleId).forEach(u -> list.add(this.getInfo(u.getUserId())));
        return list;
    }

    @Override
    public Boolean delCurRoleUser(List<String> objectIdAll) {
        List<UserRelationEntity> data = this.userRelationService.getListByObjectIdAll(objectIdAll);
        List<String> userIds = data.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
        this.delCurUser(userIds);
        return true;
    }

    @Override
    public Boolean delCurUser(List<String> userIds) {
        for (String id : userIds) {
            this.userProvider.removeOnLine(id);
        }
        return true;
    }

    @Override
    public List<UserEntity> getList(List<String> orgIdList, String keyword) {
        List<UserRelationEntity> listByObjectId = this.userRelationService.getListByOrgId(orgIdList);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().in(UserEntity::getId, (Collection)listByObjectId.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList()))).and(t -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(UserEntity::getRealName, (Object)keyword)).or()).like(UserEntity::getAccount, (Object)keyword);
        });
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<UserEntity> getListByOraganizetionId(String companyId) {
        if (StringUtils.isEmpty((String)companyId)) {
            return null;
        }
        List<String> underCompanyAllList = this.organizeService.getUnderOrganizations(companyId);
        return this.getList(underCompanyAllList, "");
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u8d26\u53f7");
        map.put(2, "\u59d3\u540d");
        map.put(3, "\u6027\u522b");
        map.put(4, "\u624b\u673a");
        map.put(5, "\u8bf4\u660e");
        map.put(6, "\u72b6\u6001");
        map.put(7, "\u6392\u5e8f");
        map.put(8, "\u662f\u5426\u7ba1\u7406\u5458");
        map.put(9, "\u9501\u5b9a\u6807\u5fd7");
        map.put(10, "\u6dfb\u52a0\u65f6\u95f4");
        map.put(11, "\u90e8\u95e8");
        return (String)map.get(key);
    }

    private boolean recursionSubordinates(String id, String managerId, int num) {
        UserEntity entity = this.getInfo(managerId);
        ++num;
        if (entity != null && entity.getId().equals(id)) {
            return true;
        }
        if (num < 10) {
            if (entity != null) {
                return this.recursionSubordinates(id, entity.getManagerId(), num);
            }
            return false;
        }
        return false;
    }

    @Override
    public String getDefaultPassword(String secretKey) {
        BaseSystemInfo baseSystemInfo = this.sysConfigService.getSysInfo();
        return Md5Util.getStringMd5((String)(Md5Util.getStringMd5((String)baseSystemInfo.getDefaultPassword()).toLowerCase() + secretKey.toLowerCase()));
    }

    @Override
    public List<UserEntity> getUserListByRoleId(String objectId) {
        List<UserRelationEntity> userRelationEntityList = this.userRelationService.getListByObjectId(objectId, "Role");
        ArrayList<String> userIds = new ArrayList<String>();
        List<UserEntity> list = new ArrayList<UserEntity>();
        if (userRelationEntityList.size() > 0) {
            for (UserRelationEntity entity : userRelationEntityList) {
                userIds.add(entity.getUserId());
            }
            Set uniqueStrings = userIds.stream().collect(Collectors.toSet());
            ArrayList uniqueStringList = new ArrayList(uniqueStrings);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserEntity::getId, uniqueStringList);
            list = this.list((Wrapper)queryWrapper);
        }
        return list;
    }

    @Override
    public List<UserEntity> getUserListByMenuId(List<AuthorizeEntity> authorizeEntityList, PaginationUser pagination) {
        ArrayList list = new ArrayList();
        ArrayList<String> roleIds = new ArrayList<String>();
        for (AuthorizeEntity authorizeEntity : authorizeEntityList) {
            roleIds.add("'" + authorizeEntity.getObjectId() + "'");
        }
        String roleIdsStr = "''";
        if (roleIds.size() > 0) {
            roleIdsStr = roleIdsStr + "," + String.join((CharSequence)",", roleIds);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        String querySql = "";
        querySql = StringUtils.isNotEmpty((String)pagination.getKeyword()) ? " where (really_name like '%" + pagination.getKeyword() + "%' OR ACCOUNT like '%" + pagination.getKeyword() + "%'   OR ACCOUNT like '%" + pagination.getKeyword() + "%')  AND id in(SELECT  distinct bur.user_id FROM BASE_USER_RELATION bur WHERE bur.object_type = 'Role' and  bur.object_id in (" + roleIdsStr + ")) ORDER BY SORT_CODE ASC,CREATOR_TIME DESC" : " where id in(SELECT  distinct bur.user_id FROM BASE_USER_RELATION bur WHERE bur.object_type = 'Role' and  bur.object_id in (" + roleIdsStr + ")) ORDER BY SORT_CODE ASC,CREATOR_TIME DESC";
        queryWrapper.last(querySql);
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(iPage.getRecords(), iPage.getTotal());
    }

    @Override
    public List<UserEntity> getJurisDictionList(PaginationUser pagination) {
        Page page;
        IPage iPage;
        boolean filterLastTime = false;
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(new SFunction[]{UserEntity::getId});
        if (!StringUtils.isEmpty((String)pagination.getOrganizeId())) {
            List<String> orgIdList = this.organizeService.getUnderOrganizations(pagination.getOrganizeId());
            List<String> idDataPermission = this.userService.getIdDataPermission(pagination);
            orgIdList.retainAll(idDataPermission);
            PageHelper.startPage((int)((int)pagination.getCurrentPage()), (int)((int)pagination.getPageSize()));
            List<String> query = null;
            String dbSchema = "";
            dbSchema = Boolean.parseBoolean(this.configValueUtil.getMultiTenancy()) ? DataSourceContextHolder.getDatasourceName() : this.dataSourceModel.getDbSchema();
            query = "kingbasees".equalsIgnoreCase(this.dataSourceModel.getDbType()) ? this.userMapper.queryKingbase(pagination.getOrganizeId(), orgIdList, pagination.getKeyword(), dbSchema, null, null) : ("oracle".equalsIgnoreCase(this.dataSourceModel.getDbType()) ? this.userMapper.queryOracle(pagination.getOrganizeId(), orgIdList, pagination.getKeyword(), null, null) : ("dm8".equalsIgnoreCase(this.dataSourceModel.getDbType()) ? this.userMapper.queryDm(pagination.getOrganizeId(), orgIdList, pagination.getKeyword(), dbSchema, null, null) : this.userMapper.query(pagination.getOrganizeId(), orgIdList, pagination.getKeyword(), null, null)));
            PageInfo pageInfo = new PageInfo(query);
            pagination.setTotal(pageInfo.getTotal());
            pagination.setCurrentPage(pageInfo.getPageNum());
            pagination.setPageSize(pageInfo.getPageSize());
            if (pageInfo.getList().size() > 0) {
                ArrayList<UserEntity> entityList = new ArrayList<UserEntity>(16);
                for (Object userIds : pageInfo.getList()) {
                    QueryWrapper queryWrapper1 = new QueryWrapper();
                    queryWrapper1.lambda().eq(UserEntity::getId, userIds);
                    entityList.add((UserEntity)this.getOne((Wrapper)queryWrapper1));
                }
                return entityList;
            }
            return new ArrayList<UserEntity>();
        }
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            filterLastTime = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(UserEntity::getAccount, (Object)pagination.getKeyword())).or()).like(UserEntity::getRealName, (Object)pagination.getKeyword())).or()).like(UserEntity::getMobilePhone, (Object)pagination.getKeyword());
            });
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
        if (filterLastTime) {
            queryWrapper.lambda().orderByDesc(UserEntity::getLastModifyTime);
        }
        if (!(iPage = this.page((IPage)(page = new Page(pagination.getCurrentPage(), pagination.getPageSize())), (Wrapper)queryWrapper)).getRecords().isEmpty()) {
            List ids = iPage.getRecords().stream().map(m -> m.getId()).collect(Collectors.toList());
            queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserEntity::getId, ids);
            ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
            if (filterLastTime) {
                queryWrapper.lambda().orderByDesc(UserEntity::getLastModifyTime);
            }
            iPage.setRecords(this.list((Wrapper)queryWrapper));
        }
        if (!StringUtils.isNotEmpty((String)pagination.getOrganizeId())) {
            iPage.setTotal(0L);
        }
        return pagination.setData(iPage.getRecords(), iPage.getTotal());
    }

    @Override
    public List<String> getIdDataPermission(PaginationUser pagination) {
        QueryWrapper queryWrapperOrganizeEntity = new QueryWrapper();
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapperOrganizeEntity, pagination.getMenuId(), "base_organize"));
            if (ObjectUtil.isEmpty((Object)companyAuth)) {
                return new ArrayList<String>();
            }
            queryWrapperOrganizeEntity = (QueryWrapper)companyAuth;
        }
        List organizeEntities = this.organizeMapper.selectList((Wrapper)queryWrapperOrganizeEntity);
        ArrayList<String> orgIdQuXian = new ArrayList<String>();
        if (!this.userProvider.get().getIsAdministrator().booleanValue() && "1".equals(pagination.getOrganizeId())) {
            for (OrganizeEntity organizeEntity : organizeEntities) {
                orgIdQuXian.add(organizeEntity.getId());
            }
            return orgIdQuXian;
        }
        if (organizeEntities.size() == 1) {
            List<OrganizeEntity> allList2 = this.organizeService.getList();
            for (OrganizeEntity organizeEntity : allList2) {
                if (!organizeEntity.getOrganizeIdTree().contains(pagination.getOrganizeId())) continue;
                orgIdQuXian.add(organizeEntity.getId());
            }
        } else {
            for (OrganizeEntity organizeEntity : organizeEntities) {
                if (!organizeEntity.getOrganizeIdTree().contains(pagination.getOrganizeId())) continue;
                orgIdQuXian.add(organizeEntity.getId());
            }
        }
        return orgIdQuXian;
    }

    @Override
    public String getUserCompany(String userId) {
        UserEntity info = this.getInfo(userId);
        if (!ObjectUtil.isNull((Object)info)) {
            OrganizeEntity companyListById = this.organizeService.getCompanyListById(info.getOrganizeId());
            return companyListById.getId();
        }
        return null;
    }

    @Override
    public List<UserListVO> getAuditList(PaginationUser pagination) throws BaseException {
        List<UserEntity> userList = this.getUserListByType(pagination, pagination.getAudit());
        ArrayList<UserListVO> list = new ArrayList<UserListVO>();
        List newEmailUserList = userList.stream().filter(user -> StringUtils.isNotEmpty((String)user.getEmail())).collect(Collectors.toList());
        List newMobilePhoneUserList = userList.stream().filter(user -> StringUtils.isNotEmpty((String)user.getMobilePhone())).collect(Collectors.toList());
        Map<String, Long> emailCountMap = newEmailUserList.stream().collect(Collectors.groupingBy(UserEntity::getEmail, Collectors.counting()));
        List duplicateEmails = emailCountMap.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        Map<String, Long> mobilePhoneCountMap = newMobilePhoneUserList.stream().collect(Collectors.groupingBy(UserEntity::getMobilePhone, Collectors.counting()));
        List duplicateMobilePhonels = mobilePhoneCountMap.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        for (UserEntity userEntity : userList) {
            UserListVO userVO = (UserListVO)JsonUtil.getJsonToBean((Object)userEntity, UserListVO.class);
            if (userVO.getEnabledMark() != null && userVO.getEnabledMark() != 0 && Objects.nonNull(userEntity.getUnlockTime()) && userEntity.getUnlockTime().getTime() > System.currentTimeMillis()) {
                userVO.setEnabledMark(2);
            }
            String organizeStr = this.userRelationService.getAllOrganizeNameInfoById(userEntity.getId());
            userVO.setOrganize(organizeStr);
            String defaultPassword = this.userService.getDefaultPassword(userEntity.getSecretkey());
            StringBuffer stringBuffer = new StringBuffer();
            if (StringUtils.isNull((Object)userEntity.getChangePasswordDate()) || defaultPassword.equals(userEntity.getPassword())) {
                stringBuffer.append("\u672a\u4fee\u6539\u521d\u59cb\u5bc6\u7801");
            }
            int changPasswordDay = 0;
            changPasswordDay = StringUtils.isNull((Object)userEntity.getChangePasswordDate()) ? DateUtil.getDiffDays((Date)userEntity.getCreatorTime(), (Date)DateUtil.getNowDate()) : DateUtil.getDiffDays((Date)userEntity.getChangePasswordDate(), (Date)DateUtil.getNowDate());
            if (changPasswordDay > 30) {
                stringBuffer.append(",\u5b9a\u671f\u672a\u4fee\u6539\u5bc6\u7801");
            }
            if (StringUtils.isNull((Object)userEntity.getLastLogTime()) || DateUtil.getDiffDays((Date)userEntity.getLastLogTime(), (Date)DateUtil.getNowDate()) > 30) {
                stringBuffer.append(",\u957f\u671f\u672a\u767b\u5f55");
            }
            List<UserRelationEntity> relationOrganizeList = this.userRelationService.getListByUserIdAndObjectId(userEntity.getId(), userEntity.getOrganizeId(), "Organize");
            boolean roleStatus = true;
            List<UserRelationEntity> relationRoleList = this.userRelationService.getListByUserIdAndObjType(userEntity.getId(), "Role");
            if (StringUtils.isNull(relationRoleList) || relationRoleList.size() < 1) {
                roleStatus = false;
            }
            SynThirdInfoCrForm synThirdInfoCrForm = new SynThirdInfoCrForm();
            synThirdInfoCrForm.setThirdtype(1);
            synThirdInfoCrForm.setSynstate(1);
            synThirdInfoCrForm.setSysObjId(userEntity.getId());
            List<SynThirdInfoEntity> synThirdList = this.synThirdInfoService.getList(synThirdInfoCrForm);
            if (StringUtils.isNull((Object)userEntity.getOrganizeId())) {
                stringBuffer.append(",\u7528\u6237\u90e8\u95e8\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isNull((Object)userEntity.getRoleId())) {
                stringBuffer.append(",\u7528\u6237\u89d2\u8272\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isNull(relationOrganizeList) || relationOrganizeList.size() < 1) {
                stringBuffer.append(",\u7528\u6237\u90e8\u95e8\u5173\u7cfb\u4e0d\u5b58\u5728");
            }
            if (!roleStatus) {
                stringBuffer.append(",\u7528\u6237\u89d2\u8272\u5173\u7cfb\u4e0d\u5b58\u5728/\u5f02\u5e38");
            }
            if (StringUtils.isNull(synThirdList) || synThirdList.size() < 1) {
                stringBuffer.append(",\u672a\u5173\u8054\u7b2c\u4e09\u65b9\u8d26\u6237\u6570\u636e");
            }
            if (StringUtils.isNotEmpty((String)userEntity.getMobilePhone()) && duplicateMobilePhonels.contains(userEntity.getMobilePhone())) {
                stringBuffer.append(",\u624b\u673a\u53f7\u91cd\u590d");
            }
            if (StringUtils.isNotEmpty((String)userEntity.getEmail()) && duplicateEmails.contains(userEntity.getEmail())) {
                stringBuffer.append(",\u90ae\u7bb1\u91cd\u590d");
            }
            userVO.setAuditResult(stringBuffer.toString());
            list.add(userVO);
        }
        return list;
    }

    public List<UserEntity> getUserListByType(Pagination pagination, String type) {
        Page page;
        IPage iPage;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(new SFunction[]{UserEntity::getId});
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(UserEntity::getAccount, (Object)pagination.getKeyword())).or()).like(UserEntity::getRealName, (Object)pagination.getKeyword())).or()).like(UserEntity::getMobilePhone, (Object)pagination.getKeyword());
            });
        }
        switch (type) {
            case "1": {
                queryWrapper.isNull((Object)"CHANGE_PASSWORD_DATE");
                break;
            }
            case "2": {
                Date frontDay = DateUtil.getFrontDay((Date)DateUtil.getNowDate(), (int)30);
                ((QueryWrapper)((QueryWrapper)queryWrapper.isNull((Object)"(CHANGE_PASSWORD_DATE")).or()).lt((Object)"CHANGE_PASSWORD_DATE)", (Object)frontDay);
                break;
            }
            case "3": {
                Date frontDay1 = DateUtil.getFrontDay((Date)DateUtil.getNowDate(), (int)30);
                ((QueryWrapper)((QueryWrapper)queryWrapper.isNull((Object)"(LAST_LOGIN_TIME")).or()).lt((Object)"LAST_LOGIN_TIME)", (Object)frontDay1);
                break;
            }
            case "4": {
                queryWrapper.isNull((Object)"ORGANIZE_ID");
                break;
            }
            case "5": {
                queryWrapper.isNull((Object)"ROLE_ID");
                break;
            }
            case "6": {
                queryWrapper.notExists("SELECT 1 FROM BASE_USER_RELATION bur WHERE bur.object_type = 'Organize' and base_user.id = bur.user_id AND base_user.ORGANIZE_ID = bur.OBJECT_ID", new Object[0]);
                break;
            }
            case "7": {
                if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
                    queryWrapper.last(" and  id not in(SELECT  distinct bu.id FROM BASE_USER bu inner join BASE_USER_RELATION bur WHERE bur.object_type = 'Role' and bu.id = bur.user_id) ORDER BY SORT_CODE ASC,CREATOR_TIME DESC");
                    break;
                }
                queryWrapper.last(" where  id not in(SELECT  distinct bu.id FROM BASE_USER bu inner join BASE_USER_RELATION bur WHERE bur.object_type = 'Role' and bu.id = bur.user_id) ORDER BY SORT_CODE ASC,CREATOR_TIME DESC");
                break;
            }
            case "8": {
                queryWrapper.notExists("SELECT distinct 1 FROM base_sync_third_info bur WHERE base_user.id = bur.system_object_id AND bur.third_type = 1 AND bur.syn_state = 1", new Object[0]);
                break;
            }
            case "9": {
                if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
                    queryWrapper.last(" and mobile_phone in(select mobile_phone  from base_user where mobile_phone is not null and mobile_phone != '' group by mobile_phone having count(mobile_phone) > 1 ) ORDER BY SORT_CODE ASC,CREATOR_TIME DESC");
                    break;
                }
                queryWrapper.last(" where mobile_phone in(select mobile_phone  from base_user where mobile_phone is not null and mobile_phone != '' group by mobile_phone having count(mobile_phone) > 1 ) ORDER BY SORT_CODE ASC,CREATOR_TIME DESC");
                break;
            }
            case "10": {
                if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
                    queryWrapper.last(" and email in(select email  from base_user where email is not null and email != '' group by email having count(email) > 1 ) ORDER BY SORT_CODE ASC,CREATOR_TIME DESC");
                    break;
                }
                queryWrapper.last(" where email in(select email  from base_user where email is not null and email != '' group by email having count(email) > 1 ) ORDER BY SORT_CODE ASC,CREATOR_TIME DESC");
                break;
            }
        }
        if (!("7".equals(type) || "9".equals(type) || "10".equals(type))) {
            ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
        }
        if (!(iPage = this.page((IPage)(page = new Page(pagination.getCurrentPage(), pagination.getPageSize())), (Wrapper)queryWrapper)).getRecords().isEmpty()) {
            List ids = iPage.getRecords().stream().map(m -> m.getId()).collect(Collectors.toList());
            queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserEntity::getId, ids);
            ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserEntity::getSortCode)).orderByDesc(UserEntity::getCreatorTime);
            iPage.setRecords(this.list((Wrapper)queryWrapper));
        }
        return pagination.setData(iPage.getRecords(), iPage.getTotal());
    }

    @Override
    public String getUserCompanyShortName(String userId) {
        String userCompany = this.getUserCompany(userId);
        OrganizeEntity info = this.organizeService.getInfo(userCompany);
        OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)info.getPropertyJson(), OrganizeCrModel.class);
        if (!ObjectUtil.isNull((Object)jsonToBean)) {
            return jsonToBean.getShortName();
        }
        return null;
    }
}

