/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.model.link.WeChatDepartment;
import com.bringspring.system.message.util.SynQyWebChatUtil;
import com.bringspring.system.permission.entity.QyLinkUserEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.service.impl.UserServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.annotation.Autowired;

public class WeChatUserThread
implements Callable<List<UserEntity>> {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    private List<WeChatDepartment> jsonToList;
    private String access_token = "";
    private WeChatDepartment weChatDepartment = new WeChatDepartment();
    private String listByEnCode = "";

    public WeChatUserThread(List<WeChatDepartment> jsonToList, UserProvider userProvider, String access_token, String listByEnCode, UserServiceImpl userServiceImpl) {
        this.jsonToList = jsonToList;
        this.userProvider = userProvider;
        this.access_token = access_token;
        this.listByEnCode = listByEnCode;
        this.userService = userServiceImpl;
    }

    @Override
    public List<UserEntity> call() throws Exception {
        ArrayList<UserEntity> jsonToListMap = new ArrayList<UserEntity>();
        for (WeChatDepartment o : this.jsonToList) {
            JSONObject userList = SynQyWebChatUtil.getLinkedcorpUser(this.access_token, "wh87896fbeb5dcdd15/" + o.getDepartment_id());
            JSONObject jo = JSONObject.parseObject((String)String.valueOf(userList));
            String userlist = String.valueOf(jo.get((Object)"userlist"));
            List jsonToListMap1 = JsonUtil.getJsonToListMap((String)userlist);
            for (Map map : jsonToListMap1) {
                UserEntity userEntity = new UserEntity();
                QyLinkUserEntity jsonToBean = (QyLinkUserEntity)JsonUtil.getJsonToBean((Object)map, new QyLinkUserEntity().getClass());
                if (!StringUtils.isNull((Object)jsonToBean.getName())) {
                    userEntity.setRealName(jsonToBean.getName().replaceAll("[^\u4e00-\u9fa5]", ""));
                }
                if (!StringUtils.isNull((Object)jsonToBean.getUserid())) {
                    userEntity.setId(String.valueOf(jsonToBean.getUserid()));
                    userEntity.setAccount(String.valueOf(map.get("userid")));
                }
                if (!StringUtils.isNull((Object)jsonToBean.getDepartment())) {
                    List department = jsonToBean.getDepartment();
                    String departmentStr = "";
                    for (Object depart : department) {
                        String s1 = String.valueOf(depart);
                        String[] split1 = s1.split("/");
                        String s3 = split1[split1.length - 1];
                        String s2 = s1.replaceAll("\\[", "").replaceAll("]", "").replaceAll("\"", "");
                        departmentStr = departmentStr + s3 + ",";
                    }
                    departmentStr = departmentStr.substring(0, departmentStr.length() - 1);
                    userEntity.setOrganizeId(departmentStr);
                }
                if (!StringUtils.isNull((Object)jsonToBean.getMobile())) {
                    userEntity.setMobilePhone(jsonToBean.getMobile());
                }
                if (!StringUtils.isNull((Object)jsonToBean.getTelephone())) {
                    userEntity.setMobilePhone(jsonToBean.getTelephone());
                }
                if (!StringUtils.isNull((Object)jsonToBean.getEmail())) {
                    userEntity.setEmail(jsonToBean.getEmail());
                }
                if (!StringUtils.isNull((Object)jsonToBean.getPosition())) {
                    userEntity.setPositionId(jsonToBean.getPosition());
                }
                userEntity.setHeadIcon("/api/file/Image/userAvatar/001.png");
                userEntity.setGender(3);
                userEntity.setEnabledMark(1);
                userEntity.setSecretkey(RandomUtil.uuId());
                userEntity.setPassword(this.userService.getDefaultPassword(userEntity.getSecretkey()));
                userEntity.setPassword(Md5Util.getStringMd5((String)(userEntity.getPassword().toLowerCase() + userEntity.getSecretkey().toLowerCase())));
                userEntity.setIsAdministrator(0);
                userEntity.setCreatorUserId(this.userProvider.get().getUserId());
                userEntity.setRoleId(this.listByEnCode);
                this.userService.saveOrUpdateCommon(userEntity.getId(), userEntity);
                jsonToListMap.add(userEntity);
            }
        }
        return jsonToListMap;
    }
}

