/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.scheduletask.utils;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.util.jobutil.JobManager;
import com.bringspring.system.base.util.jobutil.TimeJob;
import com.bringspring.system.scheduletask.entity.TimeTaskEntity;
import com.bringspring.system.scheduletask.model.ContentModel;
import com.bringspring.system.scheduletask.service.TimetaskService;
import java.util.List;
import org.quartz.CronExpression;
import org.quartz.JobDataMap;

public class TaskUtil {
    public static void task() {
        ConfigValueUtil configValueUtil = (ConfigValueUtil)SpringContext.getBean(ConfigValueUtil.class);
        if (!Boolean.parseBoolean(configValueUtil.getMultiTenancy())) {
            TimetaskService timetaskService = (TimetaskService)SpringContext.getBean(TimetaskService.class);
            List<TimeTaskEntity> list = timetaskService.getList();
            for (TimeTaskEntity entity : list) {
                if (!TaskUtil.isjson(entity.getExecuteContent())) continue;
                ContentModel model = (ContentModel)JsonUtil.getJsonToBean((String)entity.getExecuteContent(), ContentModel.class);
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.put("content", (Object)model);
                jobDataMap.put("tenantId", "");
                jobDataMap.put("tenantDbConnectionString", "");
                jobDataMap.put("id", entity.getId());
                jobDataMap.put("type", entity.getExecuteType());
                String jobName = entity.getId();
                String jobGroupName = "jsbos";
                String cron = entity.getExecuteCronExpression();
                if (!TaskUtil.filterWithCronTime(cron).booleanValue()) continue;
                JobManager jobManager = new JobManager();
                jobManager.addJob(jobName, jobGroupName, cron, jobDataMap, null, null, TimeJob.class);
            }
        }
    }

    private static Boolean filterWithCronTime(String cron) {
        boolean validExpression = false;
        if (StringUtils.isNotEmpty((String)cron)) {
            validExpression = CronExpression.isValidExpression((String)cron);
        }
        return validExpression;
    }

    private static boolean isjson(String string) {
        try {
            JSONObject jsonStr = JSONObject.parseObject((String)string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

