-- 20241202 数据权限优化 - 修改表结构
-- 数据权限配置 base_module_data_authorize 表增加字段
alter table base_module_data_authorize modify module_id varchar(50) null comment '功能主键' after property_json;

alter table base_module_data_authorize modify field_rule int null comment '字段规则' after module_id;

alter table base_module_data_authorize
    add child_table_key varchar(50) null comment '子表规则key' after field_rule;

alter table base_module_data_authorize modify bind_table varchar(50) null comment '绑定表格Id' after child_table_key;

alter table base_module_data_authorize
    add date_format varchar(20) null comment '时间格式' after bind_table;

-- 数据权限方案 base_module_data_authorize_scheme 表增加字段
alter table base_module_data_authorize_scheme modify module_id varchar(50) null comment '功能主键' after condition_text;

alter table base_module_data_authorize_scheme
    add match_logic varchar(50) null comment '分组匹配逻辑' after module_id;

alter table base_module_data_authorize_scheme
    add all_data int null comment '全部数据标识' after match_logic;


-- 机构分级管理员 base_organize_administrator 表增加字段
alter table base_organize_administrator
    add this_layer_select int default 1 comment '本层查看' after this_layer_delete;

alter table base_organize_administrator
    add sub_layer_select int default 1 comment '子层查看' after sublayer_delete;

-- 区划表 base_province 表增加字段
ALTER TABLE `base_province`
    ADD COLUMN `city_level` int(11) NULL DEFAULT NULL COMMENT '城市级别 1 直辖市，2省会城市 3 地级市 4 县区' AFTER `type`,
    ADD COLUMN `prov_simple_name` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '省份简称' AFTER `city_level`

ALTER TABLE `base_province`
    ADD COLUMN `parent_id_tree` varchar(255) NULL COMMENT '区域祖宗ids' AFTER `prov_simple_name`