package com.bringspring.system.message.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 消息实例
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("BASE_MESSAGE")
public class MessageEntity {
    /**
     * 消息主键
     */
    @TableId("ID")
    private String id;

    /**
     * 类别
     */
    @TableField("TYPE")
    private Integer type;

    /**
     * 标题
     */
    @TableField("TITLE")
    private String title;

    /**
     * 正文
     */
    @TableField("BODY_TEXT")
    private String bodyText;

    /**
     * 优先
     */
    @TableField("PRIORITY_LEVEL")
    private Integer priorityLevel;

    /**
     * 收件用户
     */
    @TableField("TO_USER_IDS")
    private String toUserIds;

    /**
     * 附件
     */
    @TableField("FILES")
    private String files;

    /**
     * 是否阅读
     */
    @TableField("IS_READ")
    private Integer isRead;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;


    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

    /**
     * 发送消息类型   用户user   部门department    角色role   岗位position
     */
    @TableField("SEND_TYPE")
    private String sendType;

    /**
     * 存储用户，部门，角色id
     */
    @TableField("SEND_ID")
    private String sendId;
}
