package com.bringspring.system.msgCenter.enums;

/**
 * 消息类型枚举
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021/4/23 17:45
 */
public enum MesTypeEnum {
    /**
     * 通知消息
     */
    NOTIFICATION_MSG("1", "通知"),
    /**
     * 公告消息
     */
    NOTICE_MSG("2", "公告"),
    /**
     * 流程消息
     */
    FLOW_MSG("3", "流程");

    private String code;
    private String type;

    MesTypeEnum(String code, String type) {
        this.code = code;
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    /**
     * 根据状态code获取枚举值
     *
     * @return
     */
    public static MesTypeEnum getByCode(String code) {
        for (MesTypeEnum status : MesTypeEnum.values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }
}
