package com.bringspring.system.msgCenter.exception;

import com.bringspring.system.msgCenter.enums.ResultCode;
import lombok.Getter;

/**
 * 自定义异常
 */
@Getter
public class MsgCenterException extends RuntimeException {
    /**
     * http状态码
     */
    private int code;

    private Object object;

    public MsgCenterException(String message, int code, Object object) {
        super(message);
        this.code = code;
        this.object = object;
    }

    public MsgCenterException(ResultCode resultCode) {
        this.code = resultCode.getCode();
        this.object = resultCode.getMessage();
    }

    public MsgCenterException(ResultCode resultCode, String message) {
        this.code = resultCode.getCode();
        this.object = message;
    }

    public MsgCenterException(String message) {
        super(message);
    }
}
