package com.bringspring.system.msgCenter.model.mcTaskMsg;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.Date;

/**
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-06-14
 */
@Data
public class McTaskMsgListVO {

    /**
     * 主键
     */
    private String id;


    /**
     * 业务系统
     **/
    @JsonProperty("taskCode")
    private String taskCode;


    /**
     * 发送配置
     **/
    @JsonProperty("sendCode")
    private String sendCode;
    private String sendName;


    /**
     * 场景关键词
     **/
    @JsonProperty("businessKey")
    private String businessKey;

    /**
     * 接收者 类型
     **/
    @JsonProperty("toType")
    private String toType;

    /**
     * 接收者
     **/
    @JsonProperty("toUserIds")
    private String toUserIds;


    /**
     * 接收者的部门
     **/
    @JsonProperty("toDeptIds")
    private String toDeptIds;


    /**
     * 自定义参数
     **/
    @JsonProperty("customKey")
    private String customKey;

    /**
     * 渠道消息未发出，自动重发最大限制次数
     **/
    @JsonProperty("autoAgainMaxNum")
    private Integer autoAgainMaxNum;


    /**
     * 状态
     **/
    @JsonProperty("enabledMark")
    private String enabledMark;


    /**
     * 描述
     **/
    @JsonProperty("description")
    private String description;


    /**
     * 创建时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("creatorTime")
    private Date creatorTime;


    /**
     * 创建人
     **/
    @JsonProperty("creatorUserId")
    private String creatorUserId;


    /**
     * 修改时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("lastModifyTime")
    private Date lastModifyTime;


    /**
     * 修改人
     **/
    @JsonProperty("lastModifyUserId")
    private String lastModifyUserId;


}