package com.bringspring.system.msgCenter.model.mcTaskMsgReceive;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.Date;

/**
 * 站内信息列表
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-06-14
 */
@Data
public class McTaskMsgReceiveSysListVO {

    /**
     * 主键
     */
    private String id;

    /**
     * 消息渠道
     **/
    @JsonProperty("channelType")
    private String channelType;

    /**
     * 消息接收人
     **/
    @JsonProperty("sysUserId")
    private String sysUserId;

    /**
     * 消息接收人
     **/
    @JsonProperty("receiveUserId")
    private String receiveUserId;

    /**
     * 状态
     **/
    @JsonProperty("enabledMark")
    private String enabledMark;

    /**
     * 发送时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("sendTime")
    private Date sendTime;

    /**
     * 发送人
     **/
    @JsonProperty("sendUserId")
    private String sendUserId;

    /**
     * 重发时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("againTime")
    private Date againTime;

    /**
     * 重发人
     **/
    @JsonProperty("againUserId")
    private String againUserId;

    /**
     * 渠道消息未发出，自动重发次数
     **/
    @JsonProperty("autoAgainNum")
    private Integer autoAgainNum;
    /**
     * 渠道消息未发出，自动重发最大限制次数
     **/
    @JsonProperty("autoAgainMaxNum")
    private Integer autoAgainMaxNum;

    /**
     * 是否阅读
     **/
    @JsonProperty("isRead")
    private String isRead;

    /**
     * 阅读时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("readTime")
    private Date readTime;

    /**
     * 阅读次数
     **/
    @JsonProperty("readCount")
    private Integer readCount;

    /**
     * 描述
     **/
    @JsonProperty("description")
    private String description;

    /**
     * 消息id
     **/
    @JsonProperty("msgId")
    private String msgId;

    /**
     * 业务系统
     **/
    @JsonProperty("taskCode")
    private String taskCode;

    /**
     * 发送配置
     **/
    @JsonProperty("sendCode")
    private String sendCode;

    /**
     * 自定义参数
     **/
    @JsonProperty("customKey")
    private String customKey;

    /**
     * 消息内容id
     **/
    @JsonProperty("contentId")
    private String contentId;
    /**
     * 消息正文内容类型，支持 文本消息、链接消息、图文消息。
     **/
    @JsonProperty("contentType")
    private String contentType;

    /**
     * 标题
     **/
    @JsonProperty("title")
    private String title;

    /**
     * 正文
     **/
    @JsonProperty("content")
    private String content;

    /**
     * 链接地址
     **/
    @JsonProperty("linkUrl")
    private String linkUrl;

    /**
     * 图片链接。
     **/
    @JsonProperty("picUrl")
    private String picUrl;

}