package com.bringspring.system.msgCenter.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.msgCenter.entity.McMsgSendTemplateEntity;
import com.bringspring.system.msgCenter.model.mcMsgSendTemplate.McMsgSendTemplateModel;

import java.util.List;

/**
 *
 * mc_msg_send_template
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-12
 */
public interface McMsgSendTemplateService extends IService<McMsgSendTemplateEntity> {

    /**
     * 校验模板的唯一
     *
     * @return 结果
     */
    boolean checkTemplateUnique(List<McMsgSendTemplateModel> templateList);

    McMsgSendTemplateModel getModel(String id);

    /**
     * 根据消息模板ID 统计消息模板数量
     * @param templateId
     * @return
     */
    long getCountByTemplateId(String templateId);
    /**
     * 根据渠道账号ID 统计消息模板数量
     * @param accountConfigId
     * @return
     */
    long getCountByAccountConfigId(String accountConfigId);
}
