package com.bringspring.system.msgCenter.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgCenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgCenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgCenter.model.MySmsModel;
import com.bringspring.system.msgCenter.model.mcMsgSendTemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgCenter.util.BlacklistUtil;
import com.bringspring.system.msgCenter.util.SmsSentUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.bringspring.system.msgCenter.constant.CommonConsts.PART_COMMA;
import static com.bringspring.system.msgCenter.constant.CommonConsts.SMS_OK;

/**
 * 消息中心-短信下发工具类
 */
@Component
@Slf4j
public class MsgToSmsService {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;


    /**
     * 发送短信
     *
     * @param isAgain        是否重发
     * @param sendTemplate   发送配置模板
     * @param taskMsgContent 业务消息内容
     * @param receiveListS   接收人source
     */
    public void sendSms(boolean isAgain, McMsgSendTemplateModel sendTemplate,
                        McTaskMsgContentEntity taskMsgContent,
                        List<McTaskMsgReceiveEntity> receiveListS) {
        if (ObjectUtil.isEmpty(taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~·~·~·~调用了 短信消息下发，但taskMsgContent为空 或 receiveList为空~·~·~·~");
        }
        List<McTaskMsgReceiveEntity> receiveList = JsonUtil.getJsonToList(receiveListS, McTaskMsgReceiveEntity.class);

        // 消息模板
        McMsgTemplateEntity templateInfo = mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());

        // 账号
        McMsgAccountEntity msgAccount = mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());

        if (ObjectUtil.isNotNull(templateInfo) && ObjectUtil.isNotNull(msgAccount)) {
            // 黑名单成员
            List<McTaskMsgReceiveEntity> receiveBlacklist = BlacklistUtil.receiveListFilter(receiveList);

            if (CollectionUtil.isNotEmpty(receiveList)) {
                // 无手机号
                List<McTaskMsgReceiveEntity> phoneNullList =
                        receiveList.stream().filter(r -> StringUtils.isEmpty(r.getReceiveUserId())).collect(Collectors.toList());
                // 有手机号
                List<McTaskMsgReceiveEntity> phoneNotNullList =
                        receiveList.stream().filter(r -> StringUtils.isNotEmpty(r.getReceiveUserId())).collect(Collectors.toList());
                List<String> phoneList =
                        phoneNotNullList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(phoneList)) {
                    // 组装接受用户
                    String phoneNumbers = StringUtils.join(phoneList, PART_COMMA);

                    //账号配置——短信
                    Map<String, String> objModel = new HashMap<>(16);
                    objModel.put("aliAccessKey", msgAccount.getAppId());
                    objModel.put("aliSecret", msgAccount.getAppSecret());
                    objModel.put("tencentSecretId", msgAccount.getAppId());
                    objModel.put("tencentSecretKey", msgAccount.getAppSecret());
                    objModel.put("tencentAppId", msgAccount.getSdkAppId());
                    objModel.put("tencentAppKey", msgAccount.getAppKey());
                    MySmsModel smsConfig = JsonUtil.getJsonToBean(objModel, MySmsModel.class);
                    int company = Integer.valueOf(msgAccount.getChannel());

                    //获取消息模板参数
                    String content = taskMsgContent.getContent();
                    Map<String, Object> msgMap = JsonUtil.stringToMap(content);
                    // 短信模板
                    String templateCode = templateInfo.getTemplateCode();
                    String endPoint = "";
                    String channelStr = String.valueOf(msgAccount.getChannel());
                    if ("1".equals(channelStr)) {
                        endPoint = msgAccount.getEndPoint();
                    } else if ("2".equals(channelStr)) {
                        endPoint = msgAccount.getZoneName();
                    }

                    /**
                     * 调用API 发送消息
                     */
                    String res = SmsSentUtil.sentSms(company, smsConfig, endPoint, msgAccount.getZoneParam(),
                            phoneNumbers, msgAccount.getSmsSignature(), templateCode, msgMap);

                    /**
                     * 处理发送结果
                     */
                    if (SMS_OK.equals(res)) {
                        // 成功
                        String errMsg = (isAgain ? "重发成功：" : "下发成功：") + res;
                        mcTaskMsgReceiveService.updateByList(isAgain, phoneNotNullList, 1, errMsg);
                    } else {
                        // 失败
                        String errMsg = (isAgain ? "重发失败：" : "下发失败：") + res;
                        mcTaskMsgReceiveService.updateByList(isAgain, phoneNotNullList, 2, errMsg);
                    }
                }

                if (CollectionUtil.isNotEmpty(phoneNullList)) {
                    String errMsg = (isAgain ? "重发失败：" : "下发失败：") + "无有效手机号";
                    mcTaskMsgReceiveService.updateByList(isAgain, phoneNullList, 2, errMsg);
                }

            }
            if (CollectionUtil.isNotEmpty(receiveBlacklist)) {
                // 黑名单
                mcTaskMsgReceiveService.updateBlacklist(receiveBlacklist);
            }
        }
    }

}