package com.bringspring.system.msgCenter.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.system.msgCenter.entity.McBusinessKeywordEntity;
import com.bringspring.system.msgCenter.mapper.McBusinessKeywordMapper;
import com.bringspring.system.msgCenter.model.mcBusinessKeyword.McBusinessKeywordModel;
import com.bringspring.system.msgCenter.service.McBusinessKeywordService;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.bringspring.system.msgCenter.constant.CommonConsts.NOT_UNIQUE;
import static com.bringspring.system.msgCenter.constant.CommonConsts.UNIQUE;

/**
 * mc_business_keyword
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-06
 */
@Service
public class McBusinessKeywordServiceImpl extends ServiceImpl<McBusinessKeywordMapper, McBusinessKeywordEntity> implements McBusinessKeywordService {

    @Override
    public boolean checkEnCodeUnique(List<McBusinessKeywordModel> keywordList) {
        // 名称
        List<String> uniqueList =
                keywordList.stream().collect(Collectors.groupingBy(McBusinessKeywordModel::getFullName,
                        Collectors.counting())).entrySet().stream().filter(e -> e.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        uniqueList.forEach(p -> System.out.println(p));
        // 编码
        List<String> uniqueEnCodeList =
                keywordList.stream().collect(Collectors.groupingBy(McBusinessKeywordModel::getEnCode,
                        Collectors.counting())).entrySet().stream().filter(e -> e.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        uniqueEnCodeList.forEach(p -> System.out.println(p));
        //计算两个list中的重复值  3条数据
//        List<McBusinessKeywordModel> reduce1 =
//                keywordList.stream().filter(item -> uniqueList.contains(item.getFullName())).collect(Collectors
//                .toList());
//        System.out.println(reduce1.toString());

        if (CollectionUtil.isNotEmpty(uniqueList) || CollectionUtil.isNotEmpty(uniqueEnCodeList)) {
            // 存在重复编码,返回false
            return NOT_UNIQUE;
        }
        return UNIQUE;
    }

    @Override
    public List<String> getKeywordNames(String businessCode){
        QueryWrapper<McBusinessKeywordEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().select(McBusinessKeywordEntity::getFullName);
        queryWrapper.lambda().eq(McBusinessKeywordEntity::getBusinessCode, businessCode);
        return this.listObjs(queryWrapper, Object::toString);
    }
}