package com.bringspring.system.msgCenter.util;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.util.StringUtils;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class UrlUtils {

    /**
     *
     * @param url
     * @param parameter
     * @return
     */
    public static String addParameter(String url, Map<String, Object> parameter) {
        StringBuffer sb = new StringBuffer();
        final Map<String, Object> query = getQuery(url);
        if (CollectionUtil.isNotEmpty(query)) {
            for (Map.Entry<String, Object> entry : query.entrySet()) {
                sb.append(entry.getKey() + "=" + entry.getValue());
                sb.append("&");
            }
        }
        for (Map.Entry<String, Object> entry : parameter.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue());
            sb.append("&");
        }
        String s = sb.toString();
        if (s.endsWith("&")) {
            s = StringUtils.substringBeforeLast(s, "&");
        }
        final String path = getPath(url);

        return path + "?" + s;
    }

    public static String getPath(String url) {
        int index = url.indexOf('?');  // 查找井号的索引
        if (index != -1) {  // 如果找到了井号
            url = url.substring(0, index);  // 截取井号之前的内容
        }
        return url;
    }

    public static String getUri(String url) {
        int index = url.indexOf('#');  // 查找井号的索引
        if (index != -1) {  // 如果找到了井号
            url = url.substring(0, index);  // 截取井号之前的内容
        }
        return url;
    }

    public static Map<String, Object> getQuery(String url) {
        Map<String, Object> map = new HashMap<>();
        try {
            final String charset = "utf-8";
            url = URLDecoder.decode(url, charset);
            if (url.indexOf('?') != -1) {
                final String contents = url.substring(url.indexOf('?') + 1);
                String[] keyValues = contents.split("&");
                for (int i = 0; i < keyValues.length; i++) {
                    String key = keyValues[i].substring(0, keyValues[i].indexOf("="));
                    String value = keyValues[i].substring(keyValues[i].indexOf("=") + 1);
                    map.put(key, value);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }


/*    public static void main(String[] args) {
        try {
            String url = "https://gl.bringspring.com/jsbos-web/#/system/sysConfig?applicationId=all";
            System.out.println(getQuery(url));
//            {applicationId=all}
            System.out.println(getUri(url));
//            https://gl.bringspring.com/jsbos-web/
            System.out.println(getPath(url));
//            https://gl.bringspring.com/jsbos-web/#/system/sysConfig
            Map<String, Object> map = new HashMap<>();
            map.put("messageid", "123131321331");
            System.out.println(addParameter(url, map));
//            https://gl.bringspring.com/jsbos-web/#/system/sysConfig?applicationId=all&messageid=123131321331
        } catch (Exception e) {
            e.printStackTrace();
        }
    }*/
}
