package com.bringspring.system.permission.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 分组管理
 *
 * @author ：RKKJ开发平台组
 * @version: V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date ：2022/3/10 17:53
 */
@Data
@TableName("BASE_GROUP")
public class GroupEntity {
    /**
     * 自然主键
     */
    @TableId("ID")
    private String id;

    /**
     * 名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 类型
     */
    @TableField("TYPE")
    private String type;

    /**
     * 说明
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 组长
     */
    @TableField("GROUP_LEADER")
    private String groupLeader;

    /**
     * 排序
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME", fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID", fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

}
