package com.bringspring.system.permission.model.organize;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:17
 */
@Data
public class OrganizeDepartSelectorListVO implements Comparable<OrganizeDepartSelectorListVO>{
    @ApiModelProperty(value = "主键")
    private String id;
    @ApiModelProperty(value = "父主键")
    private String parentId;
    @ApiModelProperty(value = "父级组织")
    private String organizeIdTree;
    @ApiModelProperty(value = "名称")
    private String fullName;
    @ApiModelProperty(value = "图标")
    private String icon;
    @ApiModelProperty(value = "是否有下级菜单")
    private Boolean hasChildren = true;
    @ApiModelProperty(value = "状态")
    private Integer enabledMark;
    @ApiModelProperty(value = "下级菜单列表")
    private List<OrganizeDepartSelectorListVO> children;
    @JSONField(name="category")
    private String  type;
    @ApiModelProperty(value = "排序")
    private String  sortCode;


    @Override
    public int compareTo(OrganizeDepartSelectorListVO stu) {
        return Integer.valueOf(getSortCode()) - Integer.valueOf(stu.getSortCode());
    }

}
