package com.bringspring.system.permission.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.exception.DataException;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.permission.entity.AuthorizeEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.model.role.RolePagination;
import com.bringspring.system.permission.model.role.RoleUpForm;

import java.util.List;

/**
 * 系统角色
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
public interface RoleService extends IService<RoleEntity> {

    /*============================= get接口 ================================*/

    /**
     * 列表
     *
     * @return 角色对象集合
     */
    List<RoleEntity> getList();

    /**
     * 通过关键字查询
     *
     * @return 角色对象集合
     */
    List<RoleEntity> getList(String keyword);

    /**
     * 获取全局角色集合
     *
     * @return 角色对象集合
     */
    List<RoleEntity> getGlobalList();

    /**
     * 列表
     *
     * @param userId 用户ID
     * @return 角色对象集合
     */
    List<RoleEntity> getListByUserId(String userId);

    /**
     * 组织底下所有角色
     * @param userId
     * @return
     */
    List<RoleEntity> getListByUserIdAndOrgId(String userId, String orgId);

    /**
     * 当前用户拥有的所有角色集合
     */
    List<String> getRoleIdsByCurrentUser();

    /**
     * 当前用户当前默认组织下的所有角色集合
     */
    List<String> getRoleIdsByCurrentUser(String orgId);

    /**
     * 获取用户组织底下，及全局的
     * @param userId
     * @param orgId
     * @return
     */
    List<String> getAllRoleIdsByUserIdAndOrgId(String userId, String orgId);

    /**
     * 信息
     *
     * @param roleId 角色ID
     * @return 角色对象
     */
    RoleEntity getInfo(String roleId);

    /**
     * 根据id集合返回角色对象集合
     *
     * @param roleIds 角色ID集合
     * @return 角色对象集合
     */
    List<RoleEntity> getListByIds(List<String> roleIds);

    /**
     * 获取角色实体
     *
     * @param fullName 角色名称
     * @return 角色对象
     */
    RoleEntity getInfoByFullName(String fullName);

    /**
     * 获取当前用户的默认组织下的所有角色集合
     *
     * @param orgId 组织ID
     * @return 角色对象集合
     */
    List<RoleEntity> getCurRolesByOrgId(String orgId);

    /**
     * 获取组织下的所有角色
     *
     * @param orgId 组织ID
     * @return 角色对象集合
     */
    List<RoleEntity> getRolesByOrgId(String orgId);

    /**
     * 当角色绑定用户不让其更改角色所属组织
     * @param roleId
     * @param reduceOrgIds
     * @return
     */
    String getBindInfo(String roleId, List<String> reduceOrgIds);

    /**
     * 角色列表
     *
     * @param page 条件
     */
    List<RoleEntity> getList(RolePagination page);

    /**
     * 根据数据权限查询角色列表
     * @param pagination
     * @return
     */
    List<RoleEntity> getListByDataPermission(RolePagination pagination);

    /**
     * 根据数据权限获取相关岗位信息
     *
     * @param rolePagination
     */
    List<RoleEntity> getListPositionDataPermission(RolePagination rolePagination);

    /**
     * 根据EnCode查询角色
     *
     * @param enCode 编码
     */
    List<RoleEntity> getListByEnCode( String enCode );

    /*============================ exist存在判断接口 =================================*/

    /**
     * 验证角色名称
     *
     * @param fullName 名称
     * @param id       主键值
     */
    Boolean isExistByFullName(String fullName, String id);

    /**
     * 验证角色编码
     *
     * @param enCode 编码
     * @param id     主键值
     */
    Boolean isExistByEnCode(String enCode, String id);


    /*============================ 存在判断接口 =================================*/

    /**
     * 创建角色
     *
     * @param entity 实体对象
     */
    void create(RoleEntity entity);

    /**
     * 复制角色
     * @param roleUpForm
     * @param fromId 复制角色来源
     */
    void copyRole(RoleUpForm roleUpForm, String fromId) throws BaseException;

    /**
     * 创建角色和组织关联关系
     *
     * @param organizeIdsTree
     * @param roleId
     * @param globalMark
     * @return
     */
    Boolean createOrganizeRoleRelation(List<List<String>> organizeIdsTree, String roleId, Integer globalMark);
    /**
     * 更新
     *
     * @param id     主键值
     * @param roleUpForm 实体对象
     */
    Boolean update(String id, RoleUpForm roleUpForm) throws PermissionException, DataException, DataException;
    /**
     * 更新前验证角色
     *
     * @param id     主键值
     * @param roleUpForm 实体对象
     */
    int updateVerify(String id, RoleUpForm roleUpForm) throws PermissionException, DataException, PermissionException;
    /**
     * 删除
     *
     * @param entity 实体对象
     */
    void delete(RoleEntity entity);

    /**
     * 根据菜单id获取角色列表信息
     * @param menuId
     * @return
     */
    List<AuthorizeEntity> getListBymenuId(String menuId);

}
