package com.bringspring.system.permission.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.permission.entity.AuthorizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.model.user.form.UserInfoForm;
import com.bringspring.system.permission.model.user.form.UserUpBatchForm;
import com.bringspring.system.permission.model.user.mod.RangeElementModel;
import com.bringspring.system.permission.model.user.mod.UserUpBatchModel;
import com.bringspring.system.permission.model.user.page.PaginationUser;
import com.bringspring.system.permission.model.user.vo.*;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 用户信息
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
public interface UserService extends IService<UserEntity> {

    /*======================get接口========================*/

    List<UserEntity> getAdminList();

    /**
     * 列表
     *
     * @param pagination 条件
     * @return
     */
    List<UserEntity> getList(Pagination pagination, String organizeId, Boolean flag);

    /**
     * 查询区域授权用户列表
     *
     * @param pagination 条件  authorizeAddressGetList
     * @return
     */
    List<UserEntity> authorizeAddressGetList(PaginationUser pagination, String organizeId, Boolean flag);

    /**
     * 通过关键字查询
     *
     * @param keyword
     * @return
     */
    List<UserEntity> getList(String keyword);

    /**
     * 根据ID批量获取用户列表
     *
     * @param ids
     * @return
     */
    List<UserEntity> getUserByIds(List<String> ids);

    /**
     * 根据部门ID批量获取用户列表
     *
     * @param orgIds
     * @return
     */
    List<UserEntity> getUserByOrgIds(List<String> orgIds);

    /**
     * 通过组织id获取用户列表
     * 不包含子组织
     *
     * @param organizeId 组织id
     * @param keyword    关键字
     * @return
     */
    List<UserEntity> getListByOrganizeId(String organizeId, String keyword);

    /**
     * 用户列表列表
     * 默认用户排序码、创建时间排序
     *
     * @return
     */
    List<UserEntity> getList();


    /**
     * 用户名列表（在线开发）
     *
     * @param idList
     * @return
     */
    List<UserEntity> getUserNameList(Set<String> idList);

    /**
     * 通过名称查询id
     *
     * @return
     */
    UserEntity getByRealName(String realName);

    /**
     * 通过名称+指定公司获取人员信息
     * @param realName 名称
     * @param companyId 公司id
     * @return
     */
    List<UserEntity> getByRealName(String realName,String companyId);

    /**
     * 根据用户id获取下属列表
     * 包括两种：
     * 1、直属主管
     * 2、部门主管
     * 这里放直属主管和部门主管的合计
     *
     * @param managerId 主管Id
     * @param keyword   关键字
     * @return
     */
    List<UserIdListVo> getListByManagerId(String managerId, String keyword);

    /**
     * 根据用户id查询用户信息信息
     *
     * @param id 主键值
     * @return
     */
    UserEntity getInfo(String id);

    /**
     * 根据用户id查询用户详细信息
     *
     * @param id 主键值
     * @return
     */
    UserInfoVO getInfoDetail(String id) throws DataException;

    /**
     * 通过account返回user实体
     * 账户、邮箱、手机号任意方式登录
     *
     * @param account 账户
     *                邮箱
     *                手机号
     * @return
     */
    UserEntity getUserByAccount(String account) throws PermissionException;

    /**
     * 获取系统用户
     * 账户、邮箱、手机号任意存在
     *
     * @param account 账户
     * @param phone   手机
     * @param email   邮箱
     * @return
     */
    UserEntity getUserEntity(String account, String phone, String email);

    /*==============================================*/

    /**
     * 重新设置所有管理员
     *
     * @param adminIds
     * @return
     */
    Boolean setAdminListByIds(List<String> adminIds);

    /**
     * 验证账户
     *
     * @param account 账户
     * @return
     */
    boolean isExistByAccount(String account);

    /**
     * 验证账户是否和别人的账户重复
     *
     * @param account
     * @param id
     * @return
     */
    boolean isExistByAccount(String account, String id);

    /**
     * 创建用户
     *
     * @param entity 实体对象
     */
    Boolean create(UserEntity entity) throws PermissionException;


    /**
     * 创建用户
     *
     * @param entity 实体对象
     */
    Boolean createUser(UserEntity entity) throws PermissionException;

    /**
     * 更新
     *
     * @param id     主键值
     * @param entity 实体对象
     */
    Boolean update(String id, UserEntity entity) throws PermissionException;

    /**
     * 批量设置部门下的所有用户主管
     *
     * @param organnizeId 主键值
     * @param managerId   直属主管ID
     */
    Boolean updateMangerIdByOrganizeId(String organnizeId, String managerId);

    /**
     * 保存或者更新 公共方法
     *
     * @param userId
     * @param entity
     * @return
     */
    Boolean saveOrUpdateCommon(String userId, UserEntity entity);

    /**
     * 删除
     *
     * @param entity 实体对象
     */
    void delete(UserEntity entity) throws Exception;

    /**
     * 删除
     *
     * @param entity     实体对象
     * @param actionType
     * @throws Exception
     */
    void delete(UserEntity entity, String actionType) throws PermissionException;

    /**
     * 逻辑删除用户
     *
     * @param entity
     */
    void deleteByLogical(UserEntity entity) throws PermissionException;

    /**
     * 修改密码
     *
     * @param entity 实体对象
     */
    void updatePassword(UserEntity entity);

    /**
     * 查询用户名称
     *
     * @param id 主键值
     * @return
     */
    List<UserEntity> getUserName(List<String> id);

    /**
     * 查询出分页被禁用的账号
     *
     * @param id 主键值
     * @return
     */
    List<UserEntity> getUserList(List<String> id);


    /**
     * 获取所有用户id
     * 状态为正常，并且非逻辑删除的
     *
     * @return
     */
    List<String> getListId();

    /**
     * 添加岗位或角色成员
     *
     * @param entity
     */
    void update(UserEntity entity, String type);

    /**
     * 判断是否为自己的下属
     *
     * @param id
     * @param managerId
     * @return
     */
    boolean isSubordinate(String id, String managerId);

    /**
     * 导出Excel
     *
     * @param dataType
     * @param selectKey
     * @param pagination
     * @return
     */
    DownloadVO exportExcel(String dataType, String selectKey, PaginationUser pagination);

    /**
     * 导入预览
     *
     * @param personList
     * @return
     */
    Map<String, Object> importPreview(List<UserExportVO> personList);

    /**
     * 导入数据
     *
     * @param dataList 数据源
     */
    UserImportVO importData(List<UserExportVO> dataList) throws PermissionException;

    /**
     * 通过组织id获取上级id集合
     *
     * @param organizeId
     * @param organizeParentIdList
     */
    void getOrganizeIdTree(String organizeId, StringBuffer organizeParentIdList);

    /**
     * 导出错误报告
     *
     * @param dataList
     * @return
     */
    DownloadVO exportExceptionData(List<UserExportVO> dataList);

    /**
     * 候选人分页查询
     *
     * @param id
     * @param pagination
     * @return
     */
    List<UserEntity> getUserName(List<String> id, Pagination pagination);

    /**
     * 根据角色ID获取所在组织下的所有成员
     *
     * @param roleId 角色ID
     * @return
     */
    List<UserEntity> getListByRoleId(String roleId);

    /**
     * 根据用户code查询用户信息信息
     *
     * @param code 主键值
     * @return
     */
    List<UserEntity> getInfoByCode(String code);

    /**
     * 删除在线的角色用户
     */
    Boolean delCurRoleUser(List<String> objectIdAll);

    /**
     * 删除当前在线用户
     *
     * @param userIds
     * @return
     */
    Boolean delCurUser(List<String> userIds);

    /**
     * 获取用户信息
     *
     * @param orgIdList
     * @param keyword
     * @return
     */
    List<UserEntity> getList(List<String> orgIdList, String keyword);

    /**
     * 通过组织ID获取本组织及子组织所有用户信息
     *
     * @param oraganizetionId
     * @return
     */
    List<UserEntity> getListByOraganizetionId(String oraganizetionId);

    /**
     * 设置默认密码
     *
     * @param
     * @return
     */
    public String getDefaultPassword(String secretKey);

    /**
     * 根据角色id获取用户列表信息
     *
     * @param objectId
     * @return
     */
    List<UserEntity> getUserListByRoleId(String objectId);

    /**
     * 根据菜单id获取用户列表信息
     *
     * @param authorizeEntityList
     * @return
     */
    List<UserEntity> getUserListByMenuId(List<AuthorizeEntity> authorizeEntityList, PaginationUser paginationUser);

    /**
     * 员工管理根据权限获取用户列表
     *
     * @param
     * @return
     */
    List<UserEntity> getUserDataPermissionList(PaginationUser pagination);


    /**
     * 根据用户id获取其所在公司简称
     *
     * @param userId
     * @return
     */
    String getUserCompanyShortName(String userId);

    /**
     * 根据用户id获取其所在公司id
     *
     * @param userId
     * @return
     */
    String getUserCompany(String userId);

    /**
     * 获取账号密码安全审计用户列表带分页
     *
     * @param pagination
     * @return
     * @throws BaseException
     */
    List<UserListVO> getAuditList(PaginationUser pagination) throws BaseException;

    /**
     * 获取范围限定前端组件回显数据
     *
     * @param selected
     * @return
     */
    Map<String, Object> getRangeElementSelected(List<RangeElementModel> selected);

    /**
     * 获取范围限定的用户列表
     *
     * @param selected
     * @return
     */
    List<UserEntity> getRangeElementUserList(List<RangeElementModel> selected);

    /**
     * 获取范围限定的用户列表
     *
     * @param rangeStr
     * @return
     */
    List<UserEntity> getRangeUserList(String rangeStr);

    /**
     * 根据选中用户分析并获取回显信息
     *
     * @param ids
     * @return
     */
    UserUpBatchModel getUpBatchModelByIds(List<String> ids);

    /**
     * 批量调整
     *
     * @param upBatchForm
     * @return
     * @throws PermissionException
     */
    void updateBatch(UserUpBatchForm upBatchForm) throws PermissionException;

    /**
     * 个人信息-个人资料修改
     *
     * @param userInfoForm
     * @return
     */
    Boolean updateBySetting(UserInfoForm userInfoForm) throws PermissionException;
}
