package com.bringspring.system.permission.service.impl;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserCommonEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.mapper.UserCommonMapper;
import com.bringspring.system.permission.model.user.vo.UserIdListVo;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserCommonService;
import com.bringspring.system.permission.service.UserService;
import com.tencentcloudapi.tci.v20190318.models.Person;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 常用用户业务类
 */
@Service
public class UserCommonServiceImpl extends ServiceImpl<UserCommonMapper, UserCommonEntity> implements UserCommonService {

    @Autowired
    private UserProvider userProvider;

    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;

    @Override
    public List<UserIdListVo> getList() {
        QueryWrapper<UserCommonEntity> commonQueryWrapper = new QueryWrapper<>();
        commonQueryWrapper.lambda().eq(UserCommonEntity::getCreatorUserId, userProvider.get().getUserId());
        commonQueryWrapper.lambda().orderByDesc( UserCommonEntity::getLastModifyTime,UserCommonEntity::getCommonNum);
        commonQueryWrapper.last("LIMIT 20");
        List<UserCommonEntity> list = this.list(commonQueryWrapper);

        List<String> userIds = list.stream().map(UserCommonEntity::getUserId).collect(Collectors.toList());
        List<UserEntity> userByIds = userService.getUserByIds(userIds);
        List<String> organizeIds = userByIds.stream().map(UserEntity::getOrganizeId).collect(Collectors.toList());
        List<OrganizeEntity> organizeList = organizeService.getOrganizeName(organizeIds);
        List<String> companyIds = organizeList.stream().map(OrganizeEntity::getOrganizeId).collect(Collectors.toList());
        List<OrganizeEntity> companyList = organizeService.getOrganizeName(companyIds);
        organizeList.addAll(companyList);
        List<UserIdListVo> jsonToList = new ArrayList<>();
        for (UserEntity entity : userByIds) {
            // 如果被禁用不显示
            if ("0".equals(String.valueOf(entity.getEnabledMark()))) {
                continue;
            }
            OrganizeEntity organize = organizeList.stream().filter(t -> t.getId().equals(entity.getOrganizeId())).findFirst().orElse(null);
            UserCommonEntity userCommonEntity = list.stream().filter(userCommon-> userCommon.getUserId().equals(entity.getId())).findFirst().orElse(null);
            entity.setLastModifyTime(userCommonEntity.getLastModifyTime());
            UserIdListVo userListVo = JsonUtil.getJsonToBean(entity, UserIdListVo.class);
            userListVo.setOrganizeName(StringUtils.isNotEmpty(organize.getShortName())?organize.getShortName():organize.getFullName());
            if (ObjectUtil.isNotEmpty(organize.getOrganizeId())) {
                OrganizeEntity company = organizeList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null);
                if (null != company) {
                    userListVo.setCompanyName(StringUtils.isNotEmpty(company.getShortName())?company.getShortName():company.getFullName());
                }
            }
            if(StringUtils.isNotEmpty(entity.getPositionId())){
                List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                List<PositionEntity> positionList = positionService.getPositionList(positionIds);
                String positionNames = positionList.stream().map(PositionEntity::getFullName).collect(Collectors.joining(","));
                userListVo.setPositionName(positionNames);
            }
            jsonToList.add(userListVo);
        }
        List<UserIdListVo> userList = jsonToList.stream().sorted(Comparator.comparing(UserIdListVo::getLastModifyTime).reversed()).collect(Collectors.toList());
        return userList;
    }
    @Override
    public void update(List<String> userIdList) {
        for (String userId : userIdList) {
            QueryWrapper<UserCommonEntity> commonQueryWrapper = new QueryWrapper<>();
            commonQueryWrapper.lambda().eq(UserCommonEntity::getCreatorUserId, userProvider.get().getUserId())
                    .eq(UserCommonEntity::getUserId,userId);
            UserCommonEntity commonEntity = this.getOne(commonQueryWrapper);
            if (ObjectUtil.isEmpty(commonEntity)) {
                commonEntity = new UserCommonEntity();
                commonEntity.setUserId(userId);
                commonEntity.setId(RandomUtil.uuId());
                this.save(commonEntity);
            }else{
                commonEntity.setCommonNum(commonEntity.getCommonNum()+1);
                this.updateById(commonEntity);
            }
        }
    }

    @Override
    public void delete(String userId) {
        QueryWrapper<UserCommonEntity> commonQueryWrapper = new QueryWrapper<>();
        commonQueryWrapper.lambda().eq(UserCommonEntity::getCreatorUserId, userProvider.get().getUserId())
                .eq(UserCommonEntity::getUserId,userId);
        this.baseMapper.delete(commonQueryWrapper);
    }
}
