package com.bringspring.system.permission.service.strategy;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.system.permission.model.authorize.ConditionModel;
import org.apache.poi.ss.formula.functions.T;

/**
 * 策略接口(抽象策略类)：
 * 定义：定义所有支持的算法的公共接口。
 * 角色：作为所有具体策略类的父接口，确保它们具有一致的方法签名。
 * 职责：定义算法的接口，并由子类实现。
 *
 * 数据权限-条件策略接口
 */
public interface ConditionStrategy {

    /**
     * 策略方法：获取数据权限查询条件
     *
     * @param tw
     * @param fieldItem
     */
    void generateCondition(QueryWrapper<T> tw, String logic, ConditionModel.ConditionItemModel fieldItem);

    /**
     * 策略标识
     * @return
     */
    Integer key();
}
