package com.bringspring.system.permission.service.strategy;

import com.alibaba.fastjson.JSON;
import com.bringspring.common.util.enums.AuthorizeConditionEnum;
import com.bringspring.common.util.enums.SearchMethodEnum;
import org.springframework.stereotype.Component;

import static com.bringspring.common.util.enums.SearchMethodEnum.Included;
import static com.bringspring.common.util.enums.SearchMethodEnum.NotIncluded;

/**
 * This class is used to search for users who are subordinates of the current user.
 */
@Component
public class ContentStringSelect extends FieldContentStringStrategy {

    public ContentStringSelect() {
        super();
        this.conditionOptions = AuthorizeConditionEnum.getConditionOptionsSelect();
        this.symbolOptions = SearchMethodEnum.getSymbolOptionsSelect();
    }

    @Override
    public Object convertFieldContent(String fieldContent, String symbol) {
        if (Included.getSymbol().equals(symbol) || NotIncluded.getSymbol().equals(symbol)) {
            return JSON.parseArray(fieldContent, String.class);
        }
        return fieldContent;
    }
}
