package com.bringspring.system.permission.service.strategy;

import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.enums.AuthorizeConditionEnum;
import com.bringspring.common.util.enums.SearchMethodEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * This class is used to search for the current user's id in the database.
 */
@Component
public class ContentStringUserId extends FieldContentTextStrategy {

    @Autowired
    private UserProvider userProvider;

    public ContentStringUserId() {
        super();
        this.conditionOptions = new ArrayList<>();
        conditionOptions.add(new HashMap<String, Object>() {{
            put("value", AuthorizeConditionEnum.USER.getCondition());
            put("label", AuthorizeConditionEnum.USER.getMessage());
        }});
        this.symbolOptions = SearchMethodEnum.getSymbolOptionsBase();
    }

    @Override
    public Object convertFieldContent(String fieldContent, String symbol) {
        return userProvider.get().getUserId();
    }
}
