/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.FormAllModel;
import com.bringspring.common.model.FormColumnModel;
import com.bringspring.common.model.FormColumnTableModel;
import com.bringspring.common.model.FormEnum;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.common.util.enums.AuthorizeConditionEnum;
import com.bringspring.common.util.enums.SearchMethodEnum;
import com.bringspring.system.base.entity.ModuleDataAuthorizeEntity;
import com.bringspring.system.base.entity.ModuleDataAuthorizeSchemeEntity;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.model.module.PropertyJsonModel;
import com.bringspring.system.base.model.moduledataauthorize.DataAuthorizeCrForm;
import com.bringspring.system.base.model.moduledataauthorize.DataAuthorizeInfoVO;
import com.bringspring.system.base.model.moduledataauthorize.DataAuthorizeListVO;
import com.bringspring.system.base.model.moduledataauthorize.DataAuthorizeUpForm;
import com.bringspring.system.base.service.ModuleDataAuthorizeSchemeService;
import com.bringspring.system.base.service.ModuleDataAuthorizeService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.model.authorize.ConditionModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.validation.Valid;
import org.apache.commons.collections4.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u6743\u9650\u5b57\u6bb5\u7ba1\u7406"}, value="ModuleDataAuthorize")
@RestController
@RequestMapping(value={"/api/system/ModuleDataAuthorize"})
public class ModuleDataAuthorizeController {
    @Autowired
    private ModuleDataAuthorizeService dataAuthorizeService;
    @Autowired
    private ModuleDataAuthorizeSchemeService dataAuthorizeSchemeService;
    @Autowired
    private ModuleService moduleService;

    @ApiOperation(value="\u83b7\u53d6\u5b57\u6bb5\u5217\u8868")
    @GetMapping(value={"/{moduleId}/List"})
    public ActionResult<ListVO<DataAuthorizeListVO>> list(@PathVariable(value="moduleId") String moduleId) {
        List<ModuleDataAuthorizeEntity> data = this.dataAuthorizeService.getList(moduleId);
        List list = JsonUtil.getJsonToList(data, DataAuthorizeListVO.class);
        list.stream().forEach(t -> {
            String[] textSplit;
            String[] symbolSplit;
            String conditionSymbol = StringUtils.isNotEmpty((String)t.getConditionSymbol()) ? t.getConditionSymbol() : "";
            StringJoiner symbolJoiner = new StringJoiner(",");
            for (String id : symbolSplit = conditionSymbol.split(",")) {
                SearchMethodEnum itemMethod = SearchMethodEnum.getSearchMethod((String)id);
                if (itemMethod == null) continue;
                symbolJoiner.add(itemMethod.getMessage());
            }
            t.setConditionText(StringUtils.isNotEmpty((String)t.getConditionText()) ? t.getConditionText() : "");
            StringJoiner textJoiner = new StringJoiner(",");
            String conditionText = StringUtils.isNotEmpty((String)t.getConditionText()) ? t.getConditionText() : "";
            for (String id : textSplit = conditionText.split(",")) {
                AuthorizeConditionEnum itemMethod = AuthorizeConditionEnum.getByMessage((String)id);
                if (itemMethod == null) continue;
                textJoiner.add(itemMethod.getMessage());
            }
            t.setConditionSymbolName(symbolJoiner.toString());
            t.setConditionName(textJoiner.toString());
            if (StringUtils.isNotEmpty((String)t.getBindTable())) {
                t.setEnCode(StringUtils.isNotEmpty((String)t.getEnCode()) ? t.getEnCode().replace(t.getBindTable() + ".", "") : "");
            }
        });
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83dc\u5355\u6570\u636e\u6743\u9650")
    @GetMapping(value={"/{moduleId}/FieldList"})
    public ActionResult fieldList(@PathVariable(value="moduleId") String moduleId) {
        Object bean;
        Object method;
        Map map;
        ArrayList<HashedMap> list = new ArrayList<HashedMap>();
        ModuleEntity entity = this.moduleService.getInfo(moduleId);
        PropertyJsonModel model = (PropertyJsonModel)JsonUtil.getJsonToBean((String)entity.getPropertyJson(), PropertyJsonModel.class);
        if (model == null) {
            model = new PropertyJsonModel();
        }
        if ((map = JsonUtil.entityToMap((Object)(method = ReflectionUtil.invokeMethod((Object)(bean = SpringContext.getBean((String)"visualdevServiceImpl")), (String)"getInfo", (Class[])new Class[]{String.class}, (Object[])new Object[]{model.getModuleId()})))) != null && map.containsKey("formData")) {
            FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)String.valueOf(map.get("formData")), FormDataModel.class);
            List fieLdsModelList = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
            RecursionForm recursionForm = new RecursionForm();
            recursionForm.setList(fieLdsModelList);
            recursionForm.setTableModelList(JsonUtil.getJsonToList((String)String.valueOf(map.get("tables")), TableModel.class));
            ArrayList formAllModel = new ArrayList();
            FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
            for (FormAllModel allModel : formAllModel) {
                HashedMap map1;
                FieLdsModel fieLdsModel;
                FormColumnModel formColumnModel;
                if (FormEnum.table.getMessage().equals(allModel.getKeyName())) {
                    FormColumnTableModel childList = allModel.getChildList();
                    List childList1 = childList.getChildList();
                    for (FormColumnModel formColumnModel2 : childList1) {
                        FieLdsModel fieLdsModel2 = formColumnModel2.getFieLdsModel();
                        if (!StringUtils.isNotEmpty((String)fieLdsModel2.getVModel())) continue;
                        HashedMap map12 = new HashedMap();
                        map12.put("field", fieLdsModel2.getVModel());
                        map12.put("fieldName", fieLdsModel2.getConfig().getLabel());
                        list.add(map12);
                    }
                    continue;
                }
                if (FormEnum.mast.getMessage().equals(allModel.getKeyName())) {
                    formColumnModel = allModel.getFormColumnModel();
                    fieLdsModel = formColumnModel.getFieLdsModel();
                    if (!StringUtils.isNotEmpty((String)fieLdsModel.getVModel())) continue;
                    map1 = new HashedMap();
                    map1.put("field", fieLdsModel.getVModel());
                    map1.put("fieldName", fieLdsModel.getConfig().getLabel());
                    list.add(map1);
                    continue;
                }
                if (!FormEnum.mastTable.getMessage().equals(allModel.getKeyName()) || !StringUtils.isNotEmpty((String)(fieLdsModel = (formColumnModel = allModel.getFormMastTableModel()).getMastTable().getFieLdsModel()).getVModel())) continue;
                map1 = new HashedMap();
                map1.put("field", fieLdsModel.getVModel());
                map1.put("fieldName", fieLdsModel.getConfig().getLabel());
                list.add(map1);
            }
        }
        return ActionResult.success(list);
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6743\u9650\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<DataAuthorizeInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        ModuleDataAuthorizeEntity entity = this.dataAuthorizeService.getInfo(id);
        ModuleEntity moduleEntity = this.moduleService.getInfo(entity.getModuleId());
        if (moduleEntity != null && StringUtils.isNotEmpty((String)entity.getBindTable())) {
            entity.setEnCode(StringUtils.isNotEmpty((String)entity.getEnCode()) ? entity.getEnCode().replace(entity.getBindTable() + ".", "") : "");
        }
        DataAuthorizeInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, DataAuthorizeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u65b0\u5efa\u6570\u636e\u6743\u9650\u914d\u7f6e")
    @PostMapping
    public ActionResult create(@RequestBody @Valid DataAuthorizeCrForm dataAuthorizeCrForm) {
        ModuleEntity moduleEntity = this.moduleService.getInfo(dataAuthorizeCrForm.getModuleId());
        ModuleDataAuthorizeEntity entity = (ModuleDataAuthorizeEntity)JsonUtil.getJsonToBean((Object)dataAuthorizeCrForm, ModuleDataAuthorizeEntity.class);
        entity.setPropertyJson(dataAuthorizeCrForm.getChildTableKey());
        if (moduleEntity != null && moduleEntity.getType() == 3 && entity.getFieldRule() != 0 && StringUtils.isNotEmpty((String)entity.getBindTable())) {
            String enCode = entity.getBindTable() + "." + entity.getEnCode();
            entity.setEnCode(enCode);
        }
        this.dataAuthorizeService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u6570\u636e\u6743\u9650\u914d\u7f6e")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DataAuthorizeUpForm dataAuthorizeUpForm) {
        ModuleEntity moduleEntity = this.moduleService.getInfo(dataAuthorizeUpForm.getModuleId());
        ModuleDataAuthorizeEntity entity = (ModuleDataAuthorizeEntity)JsonUtil.getJsonToBean((Object)dataAuthorizeUpForm, ModuleDataAuthorizeEntity.class);
        if (moduleEntity != null && moduleEntity.getType() == 3 && entity.getFieldRule() != 0 && StringUtils.isNotEmpty((String)entity.getBindTable())) {
            String enCode = entity.getBindTable() + "." + entity.getEnCode();
            entity.setEnCode(enCode);
        }
        entity.setPropertyJson(dataAuthorizeUpForm.getChildTableKey());
        boolean flag = this.dataAuthorizeService.update(id, entity);
        if (!flag) {
            return ActionResult.success((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u6743\u9650\u914d\u7f6e")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        ModuleDataAuthorizeEntity entity = this.dataAuthorizeService.getInfo(id);
        String moduleId = entity.getModuleId();
        List<ModuleDataAuthorizeSchemeEntity> list = this.dataAuthorizeSchemeService.getList(moduleId);
        String schemeName = null;
        for (ModuleDataAuthorizeSchemeEntity schemeEntity : list) {
            List conditionModels = JsonUtil.getJsonToList((String)schemeEntity.getConditionJson(), ConditionModel.class);
            if (conditionModels == null) continue;
            block1: for (ConditionModel conditionModel : conditionModels) {
                List<ConditionModel.ConditionItemModel> groups = conditionModel.getGroups();
                for (ConditionModel.ConditionItemModel conditionItemModel : groups) {
                    if (!conditionItemModel.getField().equalsIgnoreCase(entity.getEnCode()) || !conditionItemModel.getValue().equalsIgnoreCase(entity.getConditionText())) continue;
                    schemeName = schemeEntity.getFullName();
                    continue block1;
                }
            }
        }
        if (StringUtils.isNotEmpty(schemeName)) {
            return ActionResult.fail((String)("\u8be5\u5b57\u6bb5\u5728\u65b9\u6848 " + schemeName + " \u4e2d\u5df2\u88ab\u4f7f\u7528"));
        }
        if (entity != null) {
            this.dataAuthorizeService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }
}

