/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.UserLogForm;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.IpUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.LogEntity;
import com.bringspring.system.base.enums.LogSortEnum;
import com.bringspring.system.base.mapper.LogMapper;
import com.bringspring.system.base.model.logs.PaginationLogModel;
import com.bringspring.system.base.service.LogService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogServiceImpl
extends ServiceImpl<LogMapper, LogEntity>
implements LogService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private LogMapper logMapper;
    private List<DateTime> dateTimes;

    @Override
    public List<LogEntity> getList(int category, PaginationLogModel paginationTime) {
        String userAccount;
        String keyWord;
        String endTime;
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getCategory, (Object)category);
        String startTime = paginationTime.getStartTime() != null ? paginationTime.getStartTime() : null;
        String string = endTime = paginationTime.getEndTime() != null ? paginationTime.getEndTime() : null;
        if (!StringUtils.isEmpty((String)startTime) && !StringUtils.isEmpty((String)endTime)) {
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(LogEntity::getCreatorTime, (Object)startTimes)).le(LogEntity::getCreatorTime, (Object)endTimes);
        }
        String string2 = keyWord = paginationTime.getKeyword() != null ? paginationTime.getKeyword() : null;
        if (!StringUtils.isEmpty((String)keyWord)) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(LogEntity::getUserName, (Object)keyWord)).or()).like(LogEntity::getIpAddress, (Object)keyWord)).or()).like(LogEntity::getModuleName, (Object)keyWord)).or()).like(LogEntity::getRequestUrl, (Object)keyWord);
            });
        }
        String userId = userInfo.getUserId() != null ? userInfo.getUserId() : null;
        String string3 = userAccount = userInfo.getUserAccount() != null ? userInfo.getUserAccount() : null;
        if (!(StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)userAccount) || userInfo.getIsAdministrator().booleanValue())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.eq(LogEntity::getUserId, (Object)userId)).or()).eq(LogEntity::getUserId, (Object)userAccount);
            });
        }
        if (StringUtils.isNotEmpty((String)paginationTime.getIpaddress())) {
            queryWrapper.lambda().like(LogEntity::getIpAddress, (Object)paginationTime.getIpaddress());
        }
        if (StringUtils.isNotEmpty((String)paginationTime.getModuleName())) {
            queryWrapper.lambda().like(LogEntity::getModuleName, (Object)paginationTime.getModuleName());
        }
        if (StringUtils.isNotEmpty((String)paginationTime.getRequestMethod())) {
            queryWrapper.lambda().eq(LogEntity::getRequestMethod, (Object)paginationTime.getRequestMethod());
        }
        if (StringUtils.isEmpty((String)paginationTime.getSidx())) {
            queryWrapper.lambda().orderByDesc(LogEntity::getCreatorTime);
        } else {
            try {
                String sidx = paginationTime.getSidx();
                LogEntity logEntity = new LogEntity();
                Field declaredField = logEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(paginationTime.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        Page page = new Page(paginationTime.getCurrentPage(), paginationTime.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return paginationTime.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<LogEntity> getList(UserLogForm userLogForm) {
        String userAccount;
        String keyWord;
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getCategory, (Object)userLogForm.getCategory());
        if (!StringUtils.isEmpty((String)userLogForm.getStartTime()) && !StringUtils.isEmpty((String)userLogForm.getEndTime())) {
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(userLogForm.getStartTime())) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(userLogForm.getEndTime())) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(LogEntity::getCreatorTime, (Object)startTimes)).le(LogEntity::getCreatorTime, (Object)endTimes);
        }
        if (!StringUtils.isEmpty((String)(keyWord = userLogForm.getKeyword()))) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(LogEntity::getUserName, (Object)keyWord)).or()).like(LogEntity::getIpAddress, (Object)keyWord)).or()).like(LogEntity::getModuleName, (Object)keyWord);
            });
        }
        String userId = userInfo.getUserId() != null ? userInfo.getUserId() : null;
        String string = userAccount = userInfo.getUserAccount() != null ? userInfo.getUserAccount() : null;
        if (!StringUtils.isEmpty((String)userId) && !StringUtils.isEmpty((String)userAccount)) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.eq(LogEntity::getUserId, (Object)userId)).or()).eq(LogEntity::getUserId, (Object)userAccount);
            });
        }
        if (StringUtils.isEmpty((String)userLogForm.getSidx())) {
            queryWrapper.lambda().orderByDesc(LogEntity::getCreatorTime);
        } else {
            queryWrapper = "asc".equals(userLogForm.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)userLogForm.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)userLogForm.getSidx());
        }
        Page page = new Page(userLogForm.getCurrentPage(), userLogForm.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return userLogForm.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public LogEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getId, (Object)id);
        return (LogEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public boolean delete(String[] ids) {
        if (ids.length > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(LogEntity::getId, (Object[])ids);
            return this.remove((Wrapper)queryWrapper);
        }
        return false;
    }

    @Override
    public void writeLogAsync(String userId, String userName, String abstracts) {
        LogEntity entity = new LogEntity();
        entity.setId(RandomUtil.uuId());
        entity.setUserId(userId);
        entity.setUserName(userName);
        entity.setAbstracts(abstracts);
        entity.setRequestUrl(ServletUtils.getServletPath());
        entity.setRequestMethod(ServletUtils.getRequest().getMethod());
        entity.setIpAddress(IpUtil.getIpAddr());
        entity.setPlatForm(ServletUtils.getUserAgent());
        entity.setCategory(LogSortEnum.Login.getCode());
        this.save(entity);
    }

    @Override
    public void writeLogAsync(LogEntity entity) {
        entity.setId(RandomUtil.uuId());
        this.save(entity);
    }

    @Override
    public void deleteHandleLog(String type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getCategory, (Object)type);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void autoDeleteLog() {
        Object[] integers = new Integer[]{LogSortEnum.Login.getCode(), LogSortEnum.Request.getCode()};
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(LogEntity::getCategory, integers);
        queryWrapper.lambda().lt(LogEntity::getCreatorTime, (Object)DateUtil.offsetMonth((Date)new Date(), (int)-1));
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public Set<String> queryList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getCategory, (Object)3);
        return this.list((Wrapper)queryWrapper).size() > 0 ? this.list((Wrapper)queryWrapper).stream().map(t -> t.getModuleName()).collect(Collectors.toSet()) : new HashSet<String>(16);
    }

    private QueryWrapper<LogEntity> getQueryWrapper(String category, PaginationLogModel logModel) {
        String endTime;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getCategory, (Object)category);
        String startTime = logModel.getStartTime() != null ? logModel.getStartTime() : null;
        String string = endTime = logModel.getEndTime() != null ? logModel.getEndTime() : null;
        if (!StringUtils.isEmpty((String)startTime) && !StringUtils.isEmpty((String)endTime)) {
            Date startTimes = DateUtil.stringToDate((String)(startTime + ":00"));
            Date endTimes = DateUtil.stringToDate((String)(endTime + ":00"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(LogEntity::getCreatorTime, (Object)startTimes)).le(LogEntity::getCreatorTime, (Object)endTimes);
            this.dateTimes = DateUtil.rangeToList((Date)startTimes, (Date)endTimes, (DateField)DateField.MINUTE);
        } else {
            DateTime end = DateUtil.parse((CharSequence)DateUtil.getmmNow());
            Date start = DateUtil.dateAddMinutes((Date)end, (int)-29);
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(LogEntity::getCreatorTime, (Object)start)).le(LogEntity::getCreatorTime, (Object)end);
            this.dateTimes = DateUtil.rangeToList((Date)start, (Date)end, (DateField)DateField.MINUTE);
        }
        return queryWrapper;
    }

    @Override
    public List<Map<String, Object>> selectUserGroupByCreatorTime(String category, PaginationLogModel logModel) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        QueryWrapper<LogEntity> queryWrapper = this.getQueryWrapper(category, logModel);
        List<Map<String, Object>> maps = this.logMapper.selectUserGroupByCreatorTime((Wrapper)queryWrapper);
        for (DateTime dateTime : this.dateTimes) {
            String dateStr = DateUtil.getDateString((Date)dateTime, (String)"HH:mm");
            HashMap<String, Object> sendTime = maps.stream().filter(t -> t.get("creator_time").equals(dateStr)).findFirst().orElse(null);
            if (CollectionUtil.isEmpty((Map)sendTime)) {
                sendTime = new HashMap<String, Object>();
                sendTime.put("creator_time", dateStr);
                sendTime.put("scount", 0);
            }
            resultMap.add((Map<String, Object>)sendTime);
        }
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> selectModuleGroupByCreatorTime(String category, PaginationLogModel logModel) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        QueryWrapper<LogEntity> queryWrapper = this.getQueryWrapper(category, logModel);
        List<Map<String, Object>> maps = this.logMapper.selectModuleGroupByCreatorTime((Wrapper)queryWrapper);
        for (DateTime dateTime : this.dateTimes) {
            String dateStr = DateUtil.getDateString((Date)dateTime, (String)"HH:mm");
            HashMap<String, Object> sendTime = maps.stream().filter(t -> t.get("creator_time").equals(dateStr)).findFirst().orElse(null);
            if (CollectionUtil.isEmpty((Map)sendTime)) {
                sendTime = new HashMap<String, Object>();
                sendTime.put("creator_time", dateStr);
                sendTime.put("scount", 0);
            }
            resultMap.add((Map<String, Object>)sendTime);
        }
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> selectGroupByCreatorTime(String category, PaginationLogModel logModel) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        QueryWrapper<LogEntity> queryWrapper = this.getQueryWrapper(category, logModel);
        List<Map<String, Object>> maps = this.logMapper.selectGroupByCreatorTime((Wrapper)queryWrapper);
        for (DateTime dateTime : this.dateTimes) {
            String dateStr = DateUtil.getDateString((Date)dateTime, (String)"HH:mm");
            HashMap<String, Object> sendTime = maps.stream().filter(t -> t.get("creator_time").equals(dateStr)).findFirst().orElse(null);
            if (CollectionUtil.isEmpty((Map)sendTime)) {
                sendTime = new HashMap<String, Object>();
                sendTime.put("creator_time", dateStr);
                sendTime.put("scount", 0);
            }
            resultMap.add((Map<String, Object>)sendTime);
        }
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> selectMixedGroupByCreatorTime(String category, PaginationLogModel logModel) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        QueryWrapper<LogEntity> queryWrapper = this.getQueryWrapper(category, logModel);
        List<Map<String, Object>> userMaps = this.logMapper.selectUserGroupByCreatorTime((Wrapper)queryWrapper);
        List<Map<String, Object>> moduleMaps = this.logMapper.selectModuleGroupByCreatorTime((Wrapper)queryWrapper);
        List<Map<String, Object>> reqMaps = this.logMapper.selectGroupByCreatorTime((Wrapper)queryWrapper);
        for (DateTime dateTime : this.dateTimes) {
            String dateStr = DateUtil.getDateString((Date)dateTime, (String)"HH:mm");
            HashMap<String, Object> createTimes = new HashMap<String, Object>();
            createTimes.put("creator_time", dateStr);
            Map userMap = userMaps.stream().filter(t -> t.get("creator_time").equals(dateStr)).findFirst().orElse(null);
            createTimes.put("usercount", CollectionUtil.isEmpty((Map)userMap) ? Integer.valueOf(0) : userMap.get("scount"));
            Map moduleMap = moduleMaps.stream().filter(t -> t.get("creator_time").equals(dateStr)).findFirst().orElse(null);
            createTimes.put("modulecount", CollectionUtil.isEmpty((Map)moduleMap) ? Integer.valueOf(0) : moduleMap.get("scount"));
            Map reqMap = reqMaps.stream().filter(t -> t.get("creator_time").equals(dateStr)).findFirst().orElse(null);
            createTimes.put("reqcount", CollectionUtil.isEmpty((Map)reqMap) ? Integer.valueOf(0) : reqMap.get("scount"));
            resultMap.add(createTimes);
        }
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> selectGroupByModule(String category, PaginationLogModel logModel) {
        QueryWrapper<LogEntity> queryWrapper = this.getQueryWrapper(category, logModel);
        List<Map<String, Object>> resultMap = this.logMapper.selectGroupByModule((Wrapper)queryWrapper);
        return resultMap;
    }
}

