/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.task;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.model.monitor.MonitorListVO;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.base.util.MonitorUtil;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.message.util.SentMessageUtil;
import com.bringspring.system.msgCenter.model.BusinessKeys;
import com.bringspring.system.msgCenter.model.TaskMsg;
import com.bringspring.system.msgCenter.util.SendTaskMsgUtils;
import java.io.File;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import oshi.SystemInfo;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;

@Component
public class ServiceResourcesTask {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceResourcesTask.class);
    private static final String CUP_SYSTEM = "90.00";
    private static final String MEMORY_SYSTEM = "90.00";
    private static final String DISK_SYSTEM = "10";
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private SentMessageUtil sentMessageUtil;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;

    @JsbosTask(fullName="\u7cfb\u7edf\u8d44\u6e90\u76d1\u63a7", description="\u7cfb\u7edf\u8d44\u6e90\u76d1\u63a7")
    public void serviceResourcesAlert() throws Exception {
        MonitorUtil monitorUtil = new MonitorUtil();
        MonitorListVO vo = (MonitorListVO)JsonUtil.getJsonToBean((Object)monitorUtil, MonitorListVO.class);
        String cupIdle = vo.getCpu().getUsed();
        String memoryUsageRate = vo.getMemory().getUsageRate();
        String directoryPath = "";
        ClassLoader classLoader = ServiceResourcesTask.class.getClassLoader();
        URL resource = classLoader.getResource("");
        try {
            File directory = new File(resource.toURI());
            directoryPath = directory.getAbsolutePath();
        }
        catch (URISyntaxException e) {
            LOG.error(e.getMessage());
        }
        String filePath = this.configValueUtil.getDocumentFilePath();
        String osName = System.getProperty("os.name").toUpperCase();
        if (osName.contains("WINDOWS")) {
            directoryPath = directoryPath.substring(0, 1).toUpperCase();
            filePath = filePath.substring(0, 1).toUpperCase();
        } else {
            int firstCommaIndex = directoryPath.indexOf("/");
            int secondCommaIndex = directoryPath.indexOf("/", firstCommaIndex + 1);
            directoryPath = directoryPath.substring(firstCommaIndex + 1, secondCommaIndex);
            int firstCommaIndex1 = filePath.indexOf("/");
            int secondCommaIndex1 = filePath.indexOf("/", firstCommaIndex1 + 1);
            filePath = filePath.substring(firstCommaIndex1 + 1, secondCommaIndex1);
        }
        List<SysConfigEntity> sysConfigList = this.sysConfigService.getConfigListByCategory("ServiceAlertSysConfig");
        String cupSystem = "";
        String memorySystem = "";
        String diskSystem = "";
        if (sysConfigList.size() < 1) {
            cupSystem = "90.00";
            memorySystem = "90.00";
            diskSystem = DISK_SYSTEM;
        }
        for (SysConfigEntity sysConfigEntity : sysConfigList) {
            if ("serviceCPU".equals(sysConfigEntity.getKeyName())) {
                cupSystem = sysConfigEntity.getKeyValue();
                continue;
            }
            if ("serviceMemory".equals(sysConfigEntity.getKeyName())) {
                memorySystem = sysConfigEntity.getKeyValue();
                continue;
            }
            if (!"serviceDisk".equals(sysConfigEntity.getKeyName())) continue;
            diskSystem = sysConfigEntity.getKeyValue();
        }
        StringBuilder stringBuilder = new StringBuilder();
        SystemInfo si = new SystemInfo();
        OperatingSystem os = si.getOperatingSystem();
        FileSystem fileSystem = os.getFileSystem();
        List fsArray = fileSystem.getFileStores();
        if (new BigDecimal(cupIdle).compareTo(new BigDecimal(cupSystem)) >= 0) {
            stringBuilder.append("CPU\u4f7f\u7528\u7387\u8fbe\u5230\uff1a" + cupIdle + "%\uff1b\r\n");
        }
        if (new BigDecimal(memoryUsageRate).compareTo(new BigDecimal(memorySystem)) >= 0) {
            stringBuilder.append("\u5185\u5b58\u4f7f\u7528\u7387\u8fbe\u5230\uff1a" + memoryUsageRate + "%\uff1b\r\n");
        }
        for (OSFileStore file : fsArray) {
            if (file.getMount().contains(directoryPath) && new BigDecimal(file.getUsableSpace() / 1024L / 1024L / 1024L).compareTo(new BigDecimal(diskSystem)) < 0) {
                stringBuilder.append("\u7a0b\u5e8f\u76d8(" + directoryPath + ")\u53ef\u4f7f\u7528\u7a7a\u95f4\u4e3a\uff1a" + new BigDecimal(file.getUsableSpace() / 1024L / 1024L / 1024L) + "G\uff1b\r\n");
            }
            if (!file.getMount().contains(filePath) || new BigDecimal(file.getUsableSpace() / 1024L / 1024L / 1024L).compareTo(new BigDecimal(diskSystem)) >= 0) continue;
            stringBuilder.append("\u9644\u4ef6\u76d8(" + filePath + ")\u53ef\u4f7f\u7528\u7a7a\u95f4\u4e3a\uff1a" + new BigDecimal(file.getUsableSpace() / 1024L / 1024L / 1024L) + "G\uff1b\r\n");
        }
        SysConfigEntity sysConfigEntity = this.sysConfigService.getConfigByKeyName("ServiceAlertUsers");
        List ids = JSONObject.parseArray((String)sysConfigEntity.getKeyValue(), String.class);
        if (StringUtils.isNotEmpty((String)stringBuilder.toString()) && ids.size() > 0) {
            SysConfigEntity configEntity = this.sysConfigService.getConfigByKeyName("sysName");
            this.newSendMessage(ids, configEntity.getKeyValue() + "\u670d\u52a1\u5668\u8d44\u6e90\u9884\u8b66", stringBuilder.toString(), "");
        }
    }

    private void newSendMessage(List<String> userId, String title, String content, String url) throws Exception {
        if (userId.size() > 0) {
            try {
                TaskMsg taskMsg = new TaskMsg();
                taskMsg.setTaskCode("\u670d\u52a1\u5668\u8d44\u6e90\u9884\u8b66");
                taskMsg.setSendCode("ServiceAlertMessageTemplate");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("title", title);
                map.put("content", content);
                BusinessKeys businessKeys = new BusinessKeys();
                businessKeys.setKeys(map);
                taskMsg.setBusinessKey(businessKeys);
                taskMsg.setToUserIds(StringUtils.join(userId, (String)","));
                this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
            }
            catch (Exception e) {
                LOG.error("\u53d1\u6d88\u606f\u5f02\u5e38,{}", (Object)e.getMessage());
            }
        }
    }

    private void sendMessage(List<String> userId, String title, String content, String url) throws Exception {
        List<String> collect = userId.stream().distinct().collect(Collectors.toList());
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(40);
        sentMessageForm.setToUserIds(collect);
        sentMessageForm.setTemplateId(this.sysConfigService.getConfigByKeyName("ServiceAlertMessage").getKeyValue());
        sentMessageForm.setTitle(title);
        sentMessageForm.setContent(content);
        sentMessageForm.setBodyText(new HashMap<String, String>());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", title);
        map.put("content", content);
        map.put("AppUrl", this.sysConfigService.getSystemAddress("app") + url);
        sentMessageForm.setParameterMap(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
        for (SentMessageForm messageForm : messageListAll) {
            if (messageForm.getToUserIds().size() <= 0) continue;
            try {
                this.sentMessageUtil.sendMessage(messageForm);
            }
            catch (Exception e) {
                LOG.error("\u53d1\u6d88\u606f\u5f02\u5e38,{}", (Object)e.getMessage());
            }
        }
    }
}

