/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.message.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.net.URLEncodeUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.entity.SmsTemplateEntity;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.model.systemconfig.SmsModel;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.base.service.SmsTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.base.util.SmsUtil;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.message.entity.MessageEntity;
import com.bringspring.system.message.entity.MessageReceiveEntity;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.enums.MessageTypeEnum;
import com.bringspring.system.message.model.message.DingTalkModel;
import com.bringspring.system.message.model.message.EmailModel;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.message.service.MessageService;
import com.bringspring.system.message.service.MessagereceiveService;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.DingTalkUtil;
import com.bringspring.system.message.util.EmailUtil;
import com.bringspring.system.message.util.JsbosMessageUtil;
import com.bringspring.system.message.util.QyWebChatUtil;
import com.bringspring.system.msgCenter.enums.TermTypeEnum;
import com.bringspring.system.msgCenter.model.CustomKeysLink;
import com.bringspring.system.msgCenter.model.LinkMsgKeys;
import com.bringspring.system.msgCenter.model.TaskMsg;
import com.bringspring.system.msgCenter.util.SendTaskMsgUtils;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SentMessageUtil {
    private static final Logger log = LoggerFactory.getLogger(SentMessageUtil.class);
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    WxCpConfiguration wxCpConfiguration;
    @Autowired
    private MessageService messageService;
    @Autowired
    private MessagereceiveService messagereceiveService;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;

    public void sendMessage(SentMessageForm sentMessageForm) {
        List<String> toUserIdsList = sentMessageForm.getToUserIds();
        String templateId = sentMessageForm.getTemplateId();
        Map<String, String> parameterMap = sentMessageForm.getParameterMap();
        int type = sentMessageForm.getType();
        UserInfo userInfo = this.userProvider.get();
        boolean flag = true;
        if (toUserIdsList == null || toUserIdsList.size() <= 0) {
            log.error("\u63a5\u6536\u4eba\u5458\u4e3a\u7a7a");
            flag = false;
        }
        if (StringUtils.isEmpty((String)templateId)) {
            log.error("\u6a21\u677fId\u4e3a\u7a7a");
            flag = false;
        }
        if (flag) {
            MessageTemplateEntity entity = this.messageTemplateService.getInfo(templateId);
            if (ObjectUtil.isNull((Object)entity)) {
                entity = new MessageTemplateEntity();
                entity.setTitle(sentMessageForm.getTitle());
                entity.setContent(sentMessageForm.getContent());
                entity.setIsStationLetter(1);
                entity.setIsDingTalk(0);
                entity.setIsEmail(0);
                entity.setIsSms(0);
                entity.setIsWecom(0);
            }
            HashSet<String> list = new HashSet<String>(5);
            list.add(MessageTypeEnum.SysMessage.getCode());
            if (entity != null) {
                if (entity.getIsEmail() == 1) {
                    list.add(MessageTypeEnum.MailMessage.getCode());
                }
                if (entity.getIsSms() == 1) {
                    list.add(MessageTypeEnum.SmsMessage.getCode());
                }
                if (entity.getIsDingTalk() == 1) {
                    list.add(MessageTypeEnum.DingMessage.getCode());
                }
                if (entity.getIsWecom() == 1) {
                    list.add(MessageTypeEnum.QyMessage.getCode());
                }
            }
            for (String sendType : list) {
                MessageTypeEnum typeEnum = MessageTypeEnum.getByCode(sendType);
                switch (typeEnum) {
                    case SysMessage: {
                        this.messageService.sentTemplateMessage(toUserIdsList, type, entity, parameterMap, sentMessageForm.getBodyText());
                        break;
                    }
                    case SmsMessage: {
                        this.sendSms(toUserIdsList, entity, parameterMap);
                        break;
                    }
                    case MailMessage: {
                        this.SendMail(toUserIdsList, userInfo, sendType, entity, parameterMap);
                        break;
                    }
                    case QyMessage: {
                        JSONObject jsonObject = this.SendQyWebChat(toUserIdsList, userInfo, sendType, entity, parameterMap);
                        if (((Boolean)jsonObject.get((Object)"code")).booleanValue()) break;
                        log.error("\u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u5931\u8d25\uff0c\u9519\u8bef\uff1a" + jsonObject.get((Object)"error"));
                        break;
                    }
                    case DingMessage: {
                        JSONObject jsonObject1 = this.SendDingTalk(toUserIdsList, userInfo, sendType, entity, parameterMap);
                        if (((Boolean)jsonObject1.get((Object)"code")).booleanValue()) break;
                        log.error("\u53d1\u9001\u9489\u9489\u5fae\u4fe1\u6d88\u606f\u5931\u8d25\uff0c\u9519\u8bef\uff1a" + jsonObject1.get((Object)"error"));
                        break;
                    }
                }
            }
        }
    }

    public void newSendMessage(SentMessageForm sentMessageForm) {
        try {
            List<String> toUserIds = sentMessageForm.getToUserIds();
            if (CollectionUtil.isNotEmpty(toUserIds)) {
                String sysMobileUrl = this.sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue();
                ArrayList<String> userIds = new ArrayList<String>();
                for (String userId : toUserIds) {
                    userIds.clear();
                    userIds.add(userId);
                    TaskMsg taskMsg = new TaskMsg();
                    taskMsg.setTaskCode("OA\u6d41\u7a0b\u901a\u77e5");
                    taskMsg.setSendCode("FlowMessageTemplate");
                    HashMap<String, String> parameterMap = new HashMap<String, String>();
                    parameterMap.put("title", sentMessageForm.getTitle());
                    parameterMap.put("content", sentMessageForm.getTitle());
                    parameterMap.put("MessageTime", sentMessageForm.getMessageTime());
                    parameterMap.put("CreatorUser", sentMessageForm.getCreatorUser());
                    LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
                    linkMsgKeys.setLinkUrl(sysMobileUrl);
                    linkMsgKeys.setKeys(parameterMap);
                    taskMsg.setBusinessKey(linkMsgKeys);
                    CustomKeysLink customKeysLink = new CustomKeysLink();
                    customKeysLink.setPcUrl(sentMessageForm.getPcUrl());
                    customKeysLink.setAppUrl(sentMessageForm.getAppUrl());
                    customKeysLink.setTermType(TermTypeEnum.TERM_APP_PC.getCode());
                    Map<String, String> bodyText = sentMessageForm.getBodyText();
                    String msg = bodyText.get(userId) != null ? bodyText.get(userId) : "{}";
                    customKeysLink.setOtherKey((Map)JSONObject.parseObject((String)msg, Map.class));
                    taskMsg.setCustomKey(customKeysLink);
                    taskMsg.setToUserIds(String.join((CharSequence)",", userIds));
                    this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
                }
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public JSONObject SendQyWebChat(List<String> toUserIdsList, UserInfo userInfo, String sendType, MessageTemplateEntity entity, Map<String, String> parameterMap) {
        WeComModel weComModel;
        String defaultAppUrl;
        String title;
        String content = entity.getContent();
        if (StringUtils.isNotEmpty((String)content) && null != parameterMap) {
            StringSubstitutor strSubstitutor = new StringSubstitutor(parameterMap, "{", "}");
            content = strSubstitutor.replace(content);
        }
        if (StringUtils.isNotEmpty((String)(title = entity.getTitle())) && null != parameterMap) {
            StringSubstitutor strSubstitutor = new StringSubstitutor(parameterMap, "{", "}");
            title = strSubstitutor.replace(title);
        }
        JSONObject retJson = new JSONObject();
        try {
            List listModel;
            SysConfigEntity weComInfo = this.sysConfigService.getConfigByKeyName("weCom");
            defaultAppUrl = this.sysConfigService.getSystemAddress("app");
            if (ObjectUtil.isNotEmpty((Object)weComInfo) && StringUtils.isNotEmpty((String)weComInfo.getKeyValue())) {
                String keyValue = weComInfo.getKeyValue();
                listModel = JsonUtil.getJsonToList((String)keyValue, WeComModel.class);
                if (!CollectionUtil.isNotEmpty((Collection)listModel)) {
                    retJson.put("code", (Object)false);
                    retJson.put("error", (Object)"\u53d1\u9001\u5931\u8d25\uff1aweCom\u914d\u7f6e\u4f01\u4e1a\u4e3a\u7a7a");
                    return retJson;
                }
            } else {
                retJson.put("code", (Object)false);
                retJson.put("error", (Object)"\u53d1\u9001\u5931\u8d25\uff1aweCom\u914d\u7f6e\u4e0d\u5b58\u5728");
                return retJson;
            }
            weComModel = (WeComModel)listModel.get(0);
        }
        catch (BaseException e) {
            e.printStackTrace();
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)("\u53d1\u9001\u5931\u8d25" + e.getMessage()));
            return retJson;
        }
        String corpId = weComModel.getQyhCorpId();
        String agentId = weComModel.getQyhAgentId();
        Boolean isLinkedCorp = weComModel.getIsLinkedCorp();
        String corpSecret = weComModel.getQyhAgentSecret();
        String wxUserId = "";
        StringBuilder toWxUserId = new StringBuilder();
        String toUserIdAll = "";
        StringBuilder nullUserInfo = new StringBuilder();
        ArrayList<MessageReceiveEntity> messageReceiveList = new ArrayList<MessageReceiveEntity>();
        if (StringUtils.isEmpty((String)corpId)) {
            log.error("\u4f01\u4e1aID\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)corpSecret)) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"Secret\u4e3a\u7a7a");
            return retJson;
        }
        if (StringUtils.isEmpty((String)agentId)) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"AgentId\u4e3a\u7a7a");
            return retJson;
        }
        if (StringUtils.isEmpty((String)content)) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"\u5185\u5bb9\u4e3a\u7a7a");
            return retJson;
        }
        if (toUserIdsList == null || toUserIdsList.size() < 1) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"\u63a5\u6536\u4eba\u4e3a\u7a7a");
            return retJson;
        }
        MessageEntity messageEntity = JsbosMessageUtil.setMessageEntity(userInfo.getUserId(), title, content, Integer.parseInt(sendType));
        for (String userId : toUserIdsList) {
            wxUserId = "";
            List<SynThirdInfoEntity> infoBySysObjIds = this.synThirdInfoService.getInfoBySysObjIds("1", "2", userId, isLinkedCorp);
            if (!CollectionUtil.isNotEmpty(infoBySysObjIds)) continue;
            for (int i = 0; i < infoBySysObjIds.size(); ++i) {
                SynThirdInfoEntity synThirdInfoEntity = infoBySysObjIds.get(i);
                if (synThirdInfoEntity != null) {
                    wxUserId = synThirdInfoEntity.getThirdObjectId();
                }
                if (StringUtils.isEmpty((String)wxUserId)) {
                    nullUserInfo = nullUserInfo.append(",").append(userId);
                }
                toWxUserId = isLinkedCorp != false ? toWxUserId.append(",").append(wxUserId) : toWxUserId.append("|").append(wxUserId);
            }
            messageReceiveList.add(JsbosMessageUtil.setMessageReceiveEntity(messageEntity.getId(), userId));
        }
        toUserIdAll = toWxUserId.toString();
        if (StringUtils.isNotEmpty((String)toUserIdAll)) {
            toUserIdAll = toUserIdAll.substring(1);
        }
        if (StringUtils.isEmpty((String)toUserIdAll)) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"\u63a5\u6536\u4eba\u5bf9\u5e94\u7684\u4f01\u4e1a\u5fae\u4fe1\u53f7\u5168\u90e8\u4e3a\u7a7a");
            return retJson;
        }
        String appUrl = parameterMap.get("AppUrl");
        if (StringUtils.isEmpty((String)appUrl)) {
            appUrl = defaultAppUrl;
        }
        if (!StrUtil.contains((CharSequence)appUrl, (CharSequence)"redirect")) {
            log.info("appUrl:{} \u9700\u8981\u62fc\u63a5redirect\u5730\u5740", (Object)appUrl);
            String[] split = appUrl.split("#");
            String redirect = "";
            if (split.length > 1) {
                redirect = split[1];
            }
            appUrl = defaultAppUrl + "#/pages/login/index?isweixin=1&qyhCorpId=wwc0366cea7d993696&&qyhAgentId=1000034";
            redirect = URLEncodeUtil.encodeAll((String)redirect);
            appUrl = appUrl + "&redirect=" + redirect;
        }
        log.info("appUrl:{}", (Object)appUrl);
        if (isLinkedCorp.booleanValue()) {
            String[] toUserIdArr = toUserIdAll.split(",");
            retJson = QyWebChatUtil.sendLinkWxMessage(corpId, corpSecret, agentId, toUserIdArr, title, content, appUrl);
        } else {
            retJson = QyWebChatUtil.sendWxMessage(corpId, corpSecret, agentId, toUserIdAll, title, content, appUrl);
        }
        if (!retJson.getBoolean("code").booleanValue()) {
            return retJson;
        }
        if (StringUtils.isNotEmpty((String)nullUserInfo.toString())) {
            messageEntity.setDescription(nullUserInfo.substring(1) + "\u5bf9\u5e94\u7684\u4f01\u4e1a\u5fae\u4fe1\u53f7\u4e3a\u7a7a");
        }
        retJson.put("code", (Object)true);
        retJson.put("error", (Object)MsgCode.SU012.get());
        return retJson;
    }

    private JSONObject SendDingTalk(List<String> toUserIdsList, UserInfo userInfo, String sendType, MessageTemplateEntity entity, Map<String, String> parameterMap) {
        String content = entity.getContent();
        if (StringUtils.isNotEmpty((String)content)) {
            StringSubstitutor strSubstitutor = new StringSubstitutor(parameterMap, "{", "}");
            content = strSubstitutor.replace(content);
        }
        Map<String, String> objModel = this.getSystemConfig();
        DingTalkModel dingTalkModel = (DingTalkModel)JsonUtil.getJsonToBean(objModel, DingTalkModel.class);
        String appKey = "dingqgbtl0pzm45qbonu";
        String appSecret = "299RRMGBuD-Hsw9LE76DzJi-ApKmq3MABXm-tS8-plFFt189RrSJi_qB0U7tAot1";
        String agentId = "2798100981";
        String dingUserId = "";
        StringBuilder toDingUserId = new StringBuilder();
        String toUserIdAll = "";
        StringBuilder nullUserInfo = new StringBuilder();
        ArrayList<MessageReceiveEntity> messageReceiveList = new ArrayList<MessageReceiveEntity>();
        JSONObject retJson = new JSONObject();
        if (StringUtils.isEmpty((String)appKey)) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"AppKey\u4e3a\u7a7a");
            return retJson;
        }
        if (StringUtils.isEmpty((String)appSecret)) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"AppSecret\u4e3a\u7a7a");
            return retJson;
        }
        if (StringUtils.isEmpty((String)agentId)) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"AgentId\u4e3a\u7a7a");
            return retJson;
        }
        if (StringUtils.isEmpty((String)content)) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"\u5185\u5bb9\u4e3a\u7a7a");
            return retJson;
        }
        if (toUserIdsList == null || toUserIdsList.size() < 1) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"\u63a5\u6536\u4eba\u4e3a\u7a7a");
            return retJson;
        }
        MessageEntity messageEntity = JsbosMessageUtil.setMessageEntity(userInfo.getUserId(), content, null, Integer.parseInt(sendType));
        for (String userId : toUserIdsList) {
            dingUserId = "";
            SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("2", "2", userId);
            if (synThirdInfoEntity != null) {
                dingUserId = synThirdInfoEntity.getThirdObjectId();
            }
            if (StringUtils.isEmpty((String)dingUserId)) {
                nullUserInfo = nullUserInfo.append(",").append(userId);
            } else {
                toDingUserId = toDingUserId.append(",").append(dingUserId);
            }
            messageReceiveList.add(JsbosMessageUtil.setMessageReceiveEntity(messageEntity.getId(), userId));
        }
        toUserIdAll = toDingUserId.toString();
        if (StringUtils.isNotEmpty((String)toUserIdAll)) {
            toUserIdAll = toUserIdAll.substring(1);
        }
        if (StringUtils.isEmpty((String)toUserIdAll)) {
            retJson.put("code", (Object)false);
            retJson.put("error", (Object)"\u63a5\u6536\u4eba\u5bf9\u5e94\u7684\u9489\u9489\u53f7\u5168\u90e8\u4e3a\u7a7a");
            return retJson;
        }
        retJson = DingTalkUtil.sendDingMessage(appKey, appSecret, agentId, toUserIdAll, content, parameterMap.get("title"));
        if (!retJson.getBoolean("code").booleanValue()) {
            return retJson;
        }
        if (StringUtils.isNotEmpty((String)nullUserInfo.toString())) {
            messageEntity.setDescription(nullUserInfo.toString().substring(1) + "\u5bf9\u5e94\u7684\u9489\u9489\u53f7\u4e3a\u7a7a");
        }
        retJson.put("code", (Object)true);
        retJson.put("error", (Object)MsgCode.SU012.get());
        return retJson;
    }

    private void SendMail(List<String> toUserIdsList, UserInfo userInfo, String sendType, MessageTemplateEntity entity, Map<String, String> parameterMap) {
        Map<String, String> objModel = this.getSystemConfig();
        EmailModel emailModel = (EmailModel)JsonUtil.getJsonToBean(objModel, EmailModel.class);
        StringBuilder nullUserInfo = new StringBuilder();
        ArrayList<MessageReceiveEntity> messageReceiveList = new ArrayList<MessageReceiveEntity>();
        StringBuilder toUserMail = new StringBuilder();
        String userEmailAll = "";
        String userEmail = "";
        String userName = "";
        if (StringUtils.isEmpty((String)emailModel.getEmailSmtpHost())) {
            log.error("SMTP\u670d\u52a1\u4e3a\u7a7a");
        } else if (StringUtils.isEmpty((String)emailModel.getEmailSmtpPort())) {
            log.error("SMTP\u7aef\u53e3\u4e3a\u7a7a");
        } else if (StringUtils.isEmpty((String)emailModel.getEmailAccount())) {
            log.error("\u53d1\u4ef6\u4eba\u90ae\u7bb1\u4e3a\u7a7a");
        } else if (StringUtils.isEmpty((String)emailModel.getEmailPassword())) {
            log.error("\u53d1\u4ef6\u4eba\u5bc6\u7801\u4e3a\u7a7a");
        } else if (toUserIdsList == null || toUserIdsList.size() < 1) {
            log.error("\u63a5\u6536\u4eba\u4e3a\u7a7a");
        } else {
            emailModel.setEmailTitle(entity.getTitle());
            String content = entity.getContent();
            if (StringUtils.isNotEmpty((String)content)) {
                StringSubstitutor strSubstitutor = new StringSubstitutor(parameterMap, "{", "}");
                content = strSubstitutor.replace(content);
            }
            emailModel.setEmailContent(content);
            MessageEntity messageEntity = JsbosMessageUtil.setMessageEntity(userInfo.getUserId(), emailModel.getEmailTitle(), emailModel.getEmailContent(), Integer.parseInt(sendType));
            for (String userId : toUserIdsList) {
                UserEntity userEntity = this.userService.getInfo(userId);
                if (userEntity != null) {
                    userEmail = StringUtils.isEmpty((String)userEntity.getEmail()) ? "" : userEntity.getEmail();
                    userName = userEntity.getRealName();
                }
                if (userEmail != null && !"".equals(userEmail)) {
                    toUserMail = toUserMail.append(",").append(userName).append("<").append(userEmail).append(">");
                } else {
                    nullUserInfo = nullUserInfo.append(",").append(userId);
                }
                messageReceiveList.add(JsbosMessageUtil.setMessageReceiveEntity(messageEntity.getId(), userId));
            }
            userEmailAll = toUserMail.toString();
            if (StringUtils.isNotEmpty((String)userEmailAll)) {
                userEmailAll = userEmailAll.substring(1);
            }
            if (StringUtils.isEmpty((String)userEmailAll)) {
                log.error("\u63a5\u6536\u4eba\u5bf9\u5e94\u7684\u90ae\u7bb1\u5168\u90e8\u4e3a\u7a7a");
            } else {
                emailModel.setEmailToUsers(userEmailAll);
                JSONObject retJson = EmailUtil.sendMail(emailModel);
                if (!retJson.getBoolean("code").booleanValue()) {
                    log.error("\u53d1\u9001\u5931\u8d25");
                } else if (StringUtils.isNotEmpty((String)nullUserInfo.toString())) {
                    messageEntity.setDescription(nullUserInfo.substring(1) + "\u5bf9\u5e94\u7684\u90ae\u7bb1\u4e3a\u7a7a");
                }
            }
        }
    }

    private void sendSms(List<String> toUserIdsList, MessageTemplateEntity entity, Map<String, String> parameterMap) {
        StringBuffer toUserIdList = new StringBuffer();
        for (String toUserId : toUserIdsList) {
            UserEntity userEntity = this.userService.getInfo(toUserId);
            toUserIdList.append(userEntity.getMobilePhone() + ",");
        }
        if (entity != null && entity.getIsSms() == 1) {
            SmsModel smsConfig = this.smsTemplateService.getSmsConfig();
            String smsId = entity.getSmsId();
            SmsTemplateEntity smsTemplateEntity = this.smsTemplateService.getInfo(smsId);
            if (smsTemplateEntity != null) {
                SmsUtil.sentSms(smsTemplateEntity.getCompany(), smsConfig, smsTemplateEntity.getEndpoint(), smsTemplateEntity.getRegion(), toUserIdList.toString(), smsTemplateEntity.getSignContent(), smsTemplateEntity.getTemplateId(), parameterMap);
            }
        }
    }

    private Map<String, String> getSystemConfig() {
        List<SysConfigEntity> configList = this.sysConfigService.getList();
        HashMap<String, String> objModel = new HashMap<String, String>(16);
        for (SysConfigEntity entity : configList) {
            objModel.put(entity.getKeyName(), entity.getKeyValue());
        }
        return objModel;
    }
}

