/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.msgCenter.entity.McBusinessEntity;
import com.bringspring.system.msgCenter.entity.McBusinessKeywordEntity;
import com.bringspring.system.msgCenter.model.mcBusiness.McBusinessCrForm;
import com.bringspring.system.msgCenter.model.mcBusiness.McBusinessInfoVO;
import com.bringspring.system.msgCenter.model.mcBusiness.McBusinessListVO;
import com.bringspring.system.msgCenter.model.mcBusiness.McBusinessPagination;
import com.bringspring.system.msgCenter.model.mcBusiness.McBusinessPaginationExportModel;
import com.bringspring.system.msgCenter.model.mcBusiness.McBusinessSelector;
import com.bringspring.system.msgCenter.model.mcBusiness.McBusinessUpForm;
import com.bringspring.system.msgCenter.model.mcBusinessKeyword.McBusinessKeywordModel;
import com.bringspring.system.msgCenter.service.McBusinessKeywordService;
import com.bringspring.system.msgCenter.service.McBusinessService;
import com.bringspring.system.msgCenter.service.McMsgSendService;
import com.bringspring.system.msgCenter.service.McMsgTemplateService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d88\u606f\u4e1a\u52a1\u573a\u666f\u4fe1\u606f"}, value="mcBusiness")
@RequestMapping(value={"/api/msgCenter/mcBusiness"})
public class McBusinessController {
    private static final Logger log = LoggerFactory.getLogger(McBusinessController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private McBusinessService mcBusinessService;
    @Autowired
    private McBusinessKeywordService mcBusinessKeywordService;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgSendService mcMsgSendService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody McBusinessPagination mcBusinessPagination) throws IOException {
        List<McBusinessEntity> list = this.mcBusinessService.getList(mcBusinessPagination);
        List listVO = JsonUtil.getJsonToList(list, McBusinessListVO.class);
        for (McBusinessListVO vo : listVO) {
            vo.setCategory(this.baseDataUtil.getDictName(vo.getCategory(), "msgType"));
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
            vo.setDeleteUserId(this.baseDataUtil.userSelectValue(vo.getDeleteUserId()));
            vo.setCompanyId(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
            List<String> keywordNames = this.mcBusinessKeywordService.getKeywordNames(vo.getEnCode());
            vo.setKeywordNames(StringUtils.join(keywordNames, (char)','));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mcBusinessPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid McBusinessCrForm mcBusinessCrForm) throws DataException {
        if (!this.mcBusinessService.checkEnCodeUnique(mcBusinessCrForm.getEnCode(), null)) {
            return ActionResult.fail((String)"\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (!this.mcBusinessService.checkFullNameUnique(mcBusinessCrForm.getFullName(), null)) {
            return ActionResult.fail((String)"\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!this.mcBusinessKeywordService.checkEnCodeUnique(mcBusinessCrForm.getKeywordList())) {
            return ActionResult.fail((String)"\u5173\u952e\u8bcd\u91cd\u590d");
        }
        this.mcBusinessService.create(mcBusinessCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<McBusinessInfoVO> info(@PathVariable(value="id") String id) {
        McBusinessEntity entity = this.mcBusinessService.getInfo(id);
        McBusinessInfoVO vo = (McBusinessInfoVO)JsonUtil.getJsonToBean((Object)entity, McBusinessInfoVO.class);
        List<McBusinessKeywordEntity> keywordList = this.mcBusinessService.getMcBusinessKeywordList(entity.getEnCode());
        List keywordModelList = JsonUtil.getJsonToList(keywordList, McBusinessKeywordModel.class);
        if (CollectionUtil.isNotEmpty((Collection)keywordModelList)) {
            for (McBusinessKeywordModel mcBusinessKeywordModel : keywordModelList) {
            }
        }
        vo.setKeywordList(keywordModelList);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<McBusinessInfoVO> detailInfo(@PathVariable(value="id") String id) {
        McBusinessEntity entity = this.mcBusinessService.getInfo(id);
        McBusinessInfoVO vo = (McBusinessInfoVO)JsonUtil.getJsonToBean((Object)entity, McBusinessInfoVO.class);
        vo.setCategory(this.baseDataUtil.getDictName(vo.getCategory(), "msgType"));
        vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "\u542f\u7528", "\u7981\u7528"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        vo.setDeleteUserId(this.baseDataUtil.userSelectValue(vo.getDeleteUserId()));
        vo.setCompanyId(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
        List<McBusinessKeywordEntity> keywordList = this.mcBusinessService.getMcBusinessKeywordList(entity.getEnCode());
        List keywordModelList = JsonUtil.getJsonToList(keywordList, McBusinessKeywordModel.class);
        if (CollectionUtil.isNotEmpty((Collection)keywordModelList)) {
            for (McBusinessKeywordModel mcBusinessKeywordModel : keywordModelList) {
            }
        }
        vo.setKeywordList(keywordModelList);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid McBusinessUpForm mcBusinessUpForm) throws DataException {
        if (!this.mcBusinessService.checkEnCodeUnique(mcBusinessUpForm.getEnCode(), id)) {
            return ActionResult.fail((String)"\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (!this.mcBusinessService.checkFullNameUnique(mcBusinessUpForm.getFullName(), id)) {
            return ActionResult.fail((String)"\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!this.mcBusinessKeywordService.checkEnCodeUnique(mcBusinessUpForm.getKeywordList())) {
            return ActionResult.fail((String)"\u5173\u952e\u8bcd\u91cd\u590d");
        }
        McBusinessEntity entity = this.mcBusinessService.getInfo(id);
        if (ObjectUtil.isNotNull((Object)entity)) {
            this.mcBusinessService.update(id, mcBusinessUpForm);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        McBusinessEntity entity = this.mcBusinessService.getInfo(id);
        if (ObjectUtil.isNotNull((Object)entity)) {
            if (this.mcMsgTemplateService.getCountByMessageSource(entity.getEnCode()) > 0L) {
                return ActionResult.fail((String)"\u6d88\u606f\u6a21\u677f\u5df2\u5173\u8054\u573a\u666f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
            }
            if (this.mcMsgSendService.getCountByMessageSource(entity.getEnCode()) > 0L) {
                return ActionResult.fail((String)"\u53d1\u9001\u914d\u7f6e\u5df2\u5173\u8054\u573a\u666f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
            }
            this.mcBusinessService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u6d88\u606f\u573a\u666f\u4e0b\u62c9\u6846")
    @GetMapping(value={"/Selector"})
    public ActionResult<PageListVO<McBusinessSelector>> selector(McBusinessPagination pagination) {
        List<McBusinessEntity> list = this.mcBusinessService.getList(pagination);
        List listSelector = JsonUtil.getJsonToList(list, McBusinessSelector.class);
        if (CollectionUtil.isNotEmpty((Collection)listSelector)) {
            for (McBusinessSelector selector : listSelector) {
                List<McBusinessKeywordEntity> keywordList = this.mcBusinessService.getMcBusinessKeywordList(selector.getEnCode());
                List keywordModelList = JsonUtil.getJsonToList(keywordList, McBusinessKeywordModel.class);
                selector.setKeywordList(keywordModelList);
            }
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page((List)listSelector, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u6d88\u606f\u573a\u666f\u5173\u952e\u8bcd")
    @GetMapping(value={"/keyword/Selector/{enCode}"})
    public ActionResult selector(@PathVariable(value="enCode") String enCode) {
        List<McBusinessKeywordEntity> keywordList = this.mcBusinessService.getMcBusinessKeywordList(enCode);
        List keywordModelList = JsonUtil.getJsonToList(keywordList, McBusinessKeywordModel.class);
        return ActionResult.success((Object)keywordModelList);
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(McBusinessPaginationExportModel mcBusinessPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)mcBusinessPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        McBusinessPagination mcBusinessPagination = (McBusinessPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)mcBusinessPaginationExportModel), McBusinessPagination.class));
        List<McBusinessEntity> list = this.mcBusinessService.getTypeList(mcBusinessPagination, mcBusinessPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, McBusinessListVO.class);
        for (McBusinessListVO vo : listVO) {
            vo.setCategory(this.baseDataUtil.getDictName(vo.getCategory(), "msgType"));
            vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "\u542f\u7528", "\u7981\u7528"));
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
            vo.setDeleteUserId(this.baseDataUtil.userSelectValue(vo.getDeleteUserId()));
            vo.setCompanyId(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)mcBusinessPaginationExportModel.getSelectKey()) ? mcBusinessPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block38: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "category": {
                        entitys.add(new ExcelExportEntity("\u5206\u7c7b", (Object)"category"));
                        continue block38;
                    }
                    case "fullName": {
                        entitys.add(new ExcelExportEntity("\u540d\u79f0", (Object)"fullName"));
                        continue block38;
                    }
                    case "enCode": {
                        entitys.add(new ExcelExportEntity("\u7f16\u7801", (Object)"enCode"));
                        continue block38;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                        continue block38;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block38;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block38;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block38;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserId"));
                        continue block38;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block38;
                    }
                    case "deleteUserId": {
                        entitys.add(new ExcelExportEntity("\u5220\u9664\u7528\u6237", (Object)"deleteUserId"));
                        continue block38;
                    }
                    case "deleteTime": {
                        entitys.add(new ExcelExportEntity("\u5220\u9664\u65f6\u95f4", (Object)"deleteTime"));
                        continue block38;
                    }
                    case "deleteMark": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u6807\u5fd7", (Object)"deleteMark"));
                        continue block38;
                    }
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyId"));
                        continue block38;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

