/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgCenter.entity.McBusinessEntity;
import com.bringspring.system.msgCenter.entity.McBusinessKeywordEntity;
import com.bringspring.system.msgCenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgCenter.entity.McMsgSendEntity;
import com.bringspring.system.msgCenter.entity.McMsgSendTemplateEntity;
import com.bringspring.system.msgCenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgCenter.entity.McMsgTemplateFieldEntity;
import com.bringspring.system.msgCenter.model.mcBusiness.McBusinessCrForm;
import com.bringspring.system.msgCenter.model.mcBusiness.McBusinessInfoVO;
import com.bringspring.system.msgCenter.model.mcBusiness.McBusinessUpForm;
import com.bringspring.system.msgCenter.model.mcBusinessKeyword.McBusinessKeywordModel;
import com.bringspring.system.msgCenter.model.mcMsgSend.McMsgSendPagination;
import com.bringspring.system.msgCenter.model.mcMsgSendAggregation.McMsgSendAggregationCrForm;
import com.bringspring.system.msgCenter.model.mcMsgSendAggregation.McMsgSendAggregationInfoVO;
import com.bringspring.system.msgCenter.model.mcMsgSendAggregation.McMsgSendAggregationListVO;
import com.bringspring.system.msgCenter.model.mcMsgSendAggregation.McMsgSendAggregationUpForm;
import com.bringspring.system.msgCenter.model.mcMsgSendAggregation.TemplateCrForm;
import com.bringspring.system.msgCenter.model.mcMsgSendAggregation.TemplateInfoVO;
import com.bringspring.system.msgCenter.model.mcMsgSendAggregation.TemplateUpForm;
import com.bringspring.system.msgCenter.model.mcMsgSendTemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgCenter.model.mcMsgTemplateField.McMsgTemplateFieldModel;
import com.bringspring.system.msgCenter.service.McBusinessKeywordService;
import com.bringspring.system.msgCenter.service.McBusinessService;
import com.bringspring.system.msgCenter.service.McMsgAccountService;
import com.bringspring.system.msgCenter.service.McMsgSendService;
import com.bringspring.system.msgCenter.service.McMsgSendTemplateService;
import com.bringspring.system.msgCenter.service.McMsgTemplateFieldService;
import com.bringspring.system.msgCenter.service.McMsgTemplateService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d88\u606f\u53d1\u9001\u914d\u7f6e\u53ca\u6a21\u677f\u914d\u7f6e"}, value="McMsgSendAggregation")
@RequestMapping(value={"/api/msgCenter/mcMsgSendAggregation"})
public class McMsgSendAggregationController {
    private static final Logger log = LoggerFactory.getLogger(McMsgSendAggregationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private McMsgSendService mcMsgSendService;
    @Autowired
    private McMsgSendTemplateService mcMsgSendTemplateService;
    @Autowired
    private McBusinessService mcBusinessService;
    @Autowired
    private McBusinessKeywordService mcBusinessKeywordService;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgTemplateFieldService mcMsgTemplateFieldService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    private String tempalteName = "\u3010%s\u3011\u6a21\u677f";
    private String tempalteCode = "%s_";

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody McMsgSendPagination mcMsgSendPagination) throws IOException {
        List<McMsgSendEntity> list = this.mcMsgSendService.getList(mcMsgSendPagination);
        List listVO = JsonUtil.getJsonToList(list, McMsgSendAggregationListVO.class);
        for (McMsgSendAggregationListVO vo : listVO) {
            List<McMsgSendTemplateEntity> sendTempList = this.mcMsgSendService.getMcMsgSendTemplateList(vo.getId(), 1);
            List modelList = JsonUtil.getJsonToList(sendTempList, McMsgSendTemplateModel.class);
            vo.setSendTemplateList(modelList);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mcMsgSendPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getListAll"})
    public ActionResult getListAll(@RequestBody McMsgSendPagination mcMsgSendPagination) throws IOException {
        List<McMsgSendEntity> list = this.mcMsgSendService.getListAll(mcMsgSendPagination);
        List listVO = JsonUtil.getJsonToList(list, McMsgSendAggregationListVO.class);
        for (McMsgSendAggregationListVO vo : listVO) {
            List<McMsgSendTemplateEntity> sendTempList = this.mcMsgSendService.getMcMsgSendTemplateList(vo.getId(), 1);
            List modelList = JsonUtil.getJsonToList(sendTempList, McMsgSendTemplateModel.class);
            vo.setSendTemplateList(modelList);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mcMsgSendPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid McMsgSendAggregationCrForm crForm) throws DataException {
        if (!this.mcMsgSendService.checkEnCodeUnique(crForm.getEnCode(), null)) {
            return ActionResult.fail((String)"\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (!this.mcMsgSendService.checkFullNameUnique(crForm.getFullName(), null)) {
            return ActionResult.fail((String)"\u540d\u79f0\u5df2\u5b58\u5728");
        }
        String enCode = crForm.getEnCode();
        String fullName = crForm.getFullName();
        String businessCode = enCode;
        String businessName = fullName;
        String tempalteCode = String.format(this.tempalteCode, enCode);
        String tempalteName = String.format(this.tempalteName, fullName);
        McBusinessCrForm mcBusinessCrForm = crForm.getBusiness();
        McBusinessEntity businessEntity = (McBusinessEntity)JsonUtil.getJsonToBean((Object)mcBusinessCrForm, McBusinessEntity.class);
        String businessId = RandomUtil.uuId();
        businessEntity.setId(businessId);
        businessEntity.setEnCode(businessCode);
        businessEntity.setFullName(businessName);
        businessEntity.setEnabledMark(EnabledMarkEnum.ENABLE.getCode());
        businessEntity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        this.mcBusinessService.save(businessEntity);
        List keywordList = JsonUtil.getJsonToList(mcBusinessCrForm.getKeywordList(), McBusinessKeywordEntity.class);
        for (McBusinessKeywordEntity entitys : keywordList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setBusinessCode(businessEntity.getEnCode());
            this.mcBusinessKeywordService.save(entitys);
        }
        ArrayList sendTemplateEntityList = new ArrayList();
        List<TemplateCrForm> templateList = crForm.getTemplateList();
        for (int i = 0; i < templateList.size(); ++i) {
            List<McMsgSendTemplateModel> sendTemplateList;
            TemplateCrForm item = templateList.get(i);
            McMsgTemplateEntity entity = (McMsgTemplateEntity)JsonUtil.getJsonToBean((Object)item, McMsgTemplateEntity.class);
            String templateId = RandomUtil.uuId();
            entity.setId(templateId);
            entity.setEnCode(tempalteCode + i);
            entity.setFullName(tempalteName + i);
            entity.setTemplateType("0");
            entity.setMessageSource(businessCode);
            entity.setEnabledMark(EnabledMarkEnum.ENABLE.getCode());
            this.mcMsgTemplateService.save(entity);
            List fieldList = JsonUtil.getJsonToList(item.getFieldList(), McMsgTemplateFieldEntity.class);
            for (McMsgTemplateFieldEntity entitys : fieldList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setTemplateId(entity.getId());
                this.mcMsgTemplateFieldService.save(entitys);
            }
            if (!StringUtils.isNotEmpty((String)item.getSendEnabledMark()) || !"1".equals(item.getSendEnabledMark()) || !CollectionUtil.isNotEmpty(sendTemplateList = item.getSendTemplateList())) continue;
            sendTemplateList.stream().forEach(t -> {
                McMsgSendTemplateEntity sendTemplateEntity = new McMsgSendTemplateEntity();
                sendTemplateEntity.setMessageType(entity.getMessageType());
                sendTemplateEntity.setTemplateId(templateId);
                sendTemplateEntity.setAccountConfigId(t.getAccountConfigId());
                sendTemplateEntity.setEnabledMark(EnabledMarkEnum.ENABLE.getCode());
                sendTemplateEntityList.add(sendTemplateEntity);
            });
        }
        McMsgSendEntity sendEntity = (McMsgSendEntity)JsonUtil.getJsonToBean((Object)crForm, McMsgSendEntity.class);
        String sendId = RandomUtil.uuId();
        sendEntity.setId(sendId);
        sendEntity.setTemplateType("0");
        sendEntity.setMessageSource(businessCode);
        sendEntity.setEnabledMark(EnabledMarkEnum.ENABLE.getCode());
        sendEntity.setSortCode(0L);
        this.mcMsgSendService.save(sendEntity);
        if (CollectionUtil.isNotEmpty(sendTemplateEntityList)) {
            for (McMsgSendTemplateEntity entitys : sendTemplateEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setSendConfigId(sendId);
                this.mcMsgSendTemplateService.save(entitys);
            }
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<McMsgSendAggregationInfoVO> info(@PathVariable(value="id") String id) {
        McMsgSendEntity entity = this.mcMsgSendService.getInfo(id);
        McMsgSendAggregationInfoVO vo = (McMsgSendAggregationInfoVO)JsonUtil.getJsonToBean((Object)entity, McMsgSendAggregationInfoVO.class);
        String businessCode = vo.getMessageSource();
        McBusinessInfoVO business = this.mcBusinessService.getInfoByEnCode(businessCode);
        List<McBusinessKeywordEntity> keywords = this.mcBusinessService.getMcBusinessKeywordList(business.getEnCode());
        List keywordList = JsonUtil.getJsonToList(keywords, McBusinessKeywordModel.class);
        business.setKeywordList(keywordList);
        vo.setBusiness(business);
        List<McMsgTemplateEntity> templateEntities = this.mcMsgTemplateService.getInfoByCode(businessCode);
        List templateVOList = JsonUtil.getJsonToList(templateEntities, TemplateInfoVO.class);
        templateVOList.stream().forEach(item -> {
            item.setMessageTypeName(this.baseDataUtil.getDictName(item.getMessageType(), "msgSendType"));
            String templateId = item.getId();
            List<McMsgTemplateFieldEntity> fieldList = this.mcMsgTemplateService.getMcMsgTemplateFieldList(templateId);
            item.setFieldList(JsonUtil.getJsonToList(fieldList, McMsgTemplateFieldModel.class));
            List<McMsgSendTemplateEntity> sendTempList = this.mcMsgSendService.getMcMsgSendTemplateList(id, templateId, 1);
            if (CollectionUtil.isNotEmpty(sendTempList)) {
                item.setSendEnabledMark("1");
                List modelList = JsonUtil.getJsonToList(sendTempList, McMsgSendTemplateModel.class);
                modelList.stream().forEach(m -> {
                    if (StringUtils.isNotEmpty((String)m.getAccountConfigId())) {
                        McMsgAccountEntity accountInfo = this.mcMsgAccountService.getInfo(m.getAccountConfigId());
                        m.setAccountName(accountInfo != null ? accountInfo.getFullName() : null);
                        m.setAccountEnCode(accountInfo != null ? accountInfo.getEnCode() : null);
                    }
                });
                item.setSendTemplateList(modelList);
            } else {
                item.setSendEnabledMark("0");
                item.setSendTemplateList(new ArrayList<McMsgSendTemplateModel>());
            }
        });
        vo.setTemplateList(templateVOList);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid McMsgSendAggregationUpForm upForm) throws DataException {
        if (!this.mcMsgSendService.checkEnCodeUnique(upForm.getEnCode(), id)) {
            return ActionResult.fail((String)"\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (!this.mcMsgSendService.checkFullNameUnique(upForm.getFullName(), id)) {
            return ActionResult.fail((String)"\u540d\u79f0\u5df2\u5b58\u5728");
        }
        McMsgSendEntity sendentity = this.mcMsgSendService.getInfo(id);
        if (sendentity != null) {
            String enCode = upForm.getEnCode();
            String fullName = upForm.getFullName();
            String businessCode = enCode;
            String tempalteCode = String.format(this.tempalteCode, enCode);
            String tempalteName = String.format(this.tempalteName, fullName);
            McBusinessUpForm mcBusinessUpForm = upForm.getBusiness();
            McBusinessEntity businessEntity = (McBusinessEntity)JsonUtil.getJsonToBean((Object)mcBusinessUpForm, McBusinessEntity.class);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(McBusinessKeywordEntity::getBusinessCode, (Object)businessEntity.getEnCode());
            this.mcBusinessKeywordService.remove((Wrapper)queryWrapper);
            List keywordList = JsonUtil.getJsonToList(mcBusinessUpForm.getKeywordList(), McBusinessKeywordEntity.class);
            for (McBusinessKeywordEntity entitys : keywordList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setBusinessCode(businessEntity.getEnCode());
                this.mcBusinessKeywordService.save(entitys);
            }
            this.mcBusinessService.updateById(businessEntity);
            ArrayList<McMsgSendTemplateEntity> sendTemplateEntityList = new ArrayList<McMsgSendTemplateEntity>();
            List<TemplateUpForm> templateList = upForm.getTemplateList();
            for (int i = 0; i < templateList.size(); ++i) {
                List<McMsgSendTemplateModel> sendTemplateList;
                McMsgTemplateEntity entity;
                TemplateUpForm item = templateList.get(i);
                String messageType = item.getMessageType();
                String templateId = item.getId();
                if (StringUtils.isNotEmpty((String)templateId)) {
                    entity = (McMsgTemplateEntity)JsonUtil.getJsonToBean((Object)item, McMsgTemplateEntity.class);
                    entity.setEnCode(tempalteCode + i);
                    entity.setFullName(tempalteName + i);
                    this.mcMsgTemplateService.updateById(entity);
                    QueryWrapper fieldQueryWrapper = new QueryWrapper();
                    fieldQueryWrapper.lambda().eq(McMsgTemplateFieldEntity::getTemplateId, (Object)templateId);
                    this.mcMsgTemplateFieldService.remove((Wrapper)fieldQueryWrapper);
                    List fieldList = JsonUtil.getJsonToList(item.getFieldList(), McMsgTemplateFieldEntity.class);
                    Iterator iterator = fieldList.iterator();
                    while (iterator.hasNext()) {
                        McMsgTemplateFieldEntity entitys = (McMsgTemplateFieldEntity)iterator.next();
                        entitys.setId(RandomUtil.uuId());
                        entitys.setTemplateId(templateId);
                        this.mcMsgTemplateFieldService.save(entitys);
                    }
                } else {
                    entity = (McMsgTemplateEntity)JsonUtil.getJsonToBean((Object)item, McMsgTemplateEntity.class);
                    templateId = RandomUtil.uuId();
                    entity.setId(templateId);
                    entity.setEnCode(tempalteCode + i);
                    entity.setFullName(tempalteName + i);
                    entity.setTemplateType("0");
                    entity.setMessageSource(businessCode);
                    entity.setEnabledMark(EnabledMarkEnum.ENABLE.getCode());
                    this.mcMsgTemplateService.save(entity);
                    List fieldList = JsonUtil.getJsonToList(item.getFieldList(), McMsgTemplateFieldEntity.class);
                    for (McMsgTemplateFieldEntity entitys : fieldList) {
                        entitys.setId(RandomUtil.uuId());
                        entitys.setTemplateId(templateId);
                        this.mcMsgTemplateFieldService.save(entitys);
                    }
                }
                if (!StringUtils.isNotEmpty((String)item.getSendEnabledMark()) || !"1".equals(item.getSendEnabledMark()) || !CollectionUtil.isNotEmpty(sendTemplateList = item.getSendTemplateList())) continue;
                for (McMsgSendTemplateModel template : sendTemplateList) {
                    McMsgSendTemplateEntity sendTemplateEntity = new McMsgSendTemplateEntity();
                    sendTemplateEntity.setMessageType(messageType);
                    sendTemplateEntity.setTemplateId(templateId);
                    sendTemplateEntity.setAccountConfigId(template.getAccountConfigId());
                    sendTemplateEntity.setEnabledMark(EnabledMarkEnum.ENABLE.getCode());
                    sendTemplateEntityList.add(sendTemplateEntity);
                }
            }
            McMsgSendEntity sendEntity = (McMsgSendEntity)JsonUtil.getJsonToBean((Object)upForm, McMsgSendEntity.class);
            sendEntity.setId(id);
            this.mcMsgSendService.updateById(sendEntity);
            QueryWrapper sendTemplatequeryWrapper = new QueryWrapper();
            sendTemplatequeryWrapper.lambda().eq(McMsgSendTemplateEntity::getSendConfigId, (Object)sendEntity.getId());
            this.mcMsgSendTemplateService.remove((Wrapper)sendTemplatequeryWrapper);
            for (McMsgSendTemplateEntity entitys : sendTemplateEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setSendConfigId(sendEntity.getId());
                this.mcMsgSendTemplateService.save(entitys);
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        McMsgSendEntity entity = this.mcMsgSendService.getInfo(id);
        if (entity != null) {
            String messageSource = entity.getMessageSource();
            QueryWrapper businessQueryWrapper = new QueryWrapper();
            businessQueryWrapper.lambda().eq(McBusinessEntity::getEnCode, (Object)messageSource);
            this.mcBusinessService.remove((Wrapper)businessQueryWrapper);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(McBusinessKeywordEntity::getBusinessCode, (Object)messageSource);
            this.mcBusinessKeywordService.remove((Wrapper)queryWrapper);
            QueryWrapper templateQueryWrapper = new QueryWrapper();
            templateQueryWrapper.lambda().eq(McMsgTemplateEntity::getMessageSource, (Object)messageSource);
            List list = this.mcMsgTemplateService.list((Wrapper)templateQueryWrapper);
            list.stream().forEach(item -> {
                this.mcMsgTemplateService.removeById((Serializable)((Object)item.getId()));
                QueryWrapper fieldQueryWrapper = new QueryWrapper();
                fieldQueryWrapper.lambda().eq(McMsgTemplateFieldEntity::getTemplateId, (Object)item.getId());
                this.mcMsgTemplateFieldService.remove((Wrapper)fieldQueryWrapper);
            });
            this.mcMsgSendService.removeById((Serializable)((Object)entity.getId()));
            QueryWrapper queryWrapperMcMsgSendTemplate = new QueryWrapper();
            queryWrapperMcMsgSendTemplate.lambda().eq(McMsgSendTemplateEntity::getSendConfigId, (Object)entity.getId());
            this.mcMsgSendTemplateService.remove((Wrapper)queryWrapperMcMsgSendTemplate);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

