/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgCenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgCenter.model.mcTaskMsgContent.McTaskMsgContentCrForm;
import com.bringspring.system.msgCenter.model.mcTaskMsgContent.McTaskMsgContentInfoVO;
import com.bringspring.system.msgCenter.model.mcTaskMsgContent.McTaskMsgContentListVO;
import com.bringspring.system.msgCenter.model.mcTaskMsgContent.McTaskMsgContentPagination;
import com.bringspring.system.msgCenter.model.mcTaskMsgContent.McTaskMsgContentUpForm;
import com.bringspring.system.msgCenter.service.McTaskMsgContentService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e1a\u52a1\u573a\u666f\u6d88\u606f\u5185\u5bb9\u8868"}, value="mcTaskMsgContent")
@RequestMapping(value={"/api/msgCenter/mcTaskMsgContent"})
public class McTaskMsgContentController {
    private static final Logger log = LoggerFactory.getLogger(McTaskMsgContentController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private McTaskMsgContentService mcTaskMsgContentService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody McTaskMsgContentPagination mcTaskMsgContentPagination) throws IOException {
        List<McTaskMsgContentEntity> list = this.mcTaskMsgContentService.getList(mcTaskMsgContentPagination);
        List listVO = JsonUtil.getJsonToList(list, McTaskMsgContentListVO.class);
        for (McTaskMsgContentListVO vo : listVO) {
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mcTaskMsgContentPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid McTaskMsgContentCrForm mcTaskMsgContentCrForm) throws DataException {
        this.mcTaskMsgContentService.create(mcTaskMsgContentCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<McTaskMsgContentInfoVO> info(@PathVariable(value="id") String id) {
        McTaskMsgContentEntity entity = this.mcTaskMsgContentService.getInfo(id);
        McTaskMsgContentInfoVO vo = (McTaskMsgContentInfoVO)JsonUtil.getJsonToBean((Object)entity, McTaskMsgContentInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<McTaskMsgContentInfoVO> detailInfo(@PathVariable(value="id") String id) {
        McTaskMsgContentEntity entity = this.mcTaskMsgContentService.getInfo(id);
        McTaskMsgContentInfoVO vo = (McTaskMsgContentInfoVO)JsonUtil.getJsonToBean((Object)entity, McTaskMsgContentInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid McTaskMsgContentUpForm mcTaskMsgContentUpForm) throws DataException {
        McTaskMsgContentEntity entity = this.mcTaskMsgContentService.getInfo(id);
        if (entity != null) {
            this.mcTaskMsgContentService.update(id, mcTaskMsgContentUpForm);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        McTaskMsgContentEntity entity = this.mcTaskMsgContentService.getInfo(id);
        if (entity != null) {
            this.mcTaskMsgContentService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

