/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgCenter.entity.McMsgSendEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgCenter.model.mcTaskMsg.McTaskMsgCrForm;
import com.bringspring.system.msgCenter.model.mcTaskMsg.McTaskMsgInfoVO;
import com.bringspring.system.msgCenter.model.mcTaskMsg.McTaskMsgListVO;
import com.bringspring.system.msgCenter.model.mcTaskMsg.McTaskMsgPagination;
import com.bringspring.system.msgCenter.model.mcTaskMsg.McTaskMsgUpForm;
import com.bringspring.system.msgCenter.service.McMsgSendService;
import com.bringspring.system.msgCenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgCenter.service.McTaskMsgService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e1a\u52a1\u573a\u666f\u6d88\u606f\u8868"}, value="mcTaskMsg")
@RequestMapping(value={"/api/msgCenter/mcTaskMsg"})
public class McTaskMsgController {
    private static final Logger log = LoggerFactory.getLogger(McTaskMsgController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private McTaskMsgService mcTaskMsgService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private McMsgSendService mcMsgSendService;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody McTaskMsgPagination mcTaskMsgPagination) throws IOException {
        List<McTaskMsgEntity> list = this.mcTaskMsgService.getList(mcTaskMsgPagination);
        List listVO = JsonUtil.getJsonToList(list, McTaskMsgListVO.class);
        for (McTaskMsgListVO vo : listVO) {
            String taskCode;
            List<String> toDeptArr;
            List<OrganizeEntity> deptList;
            String toDeptIds;
            List<String> toUserArr;
            List<UserEntity> userList;
            String toUserIds = vo.getToUserIds();
            if (StringUtils.isNotEmpty((String)toUserIds) && !"@ALL".equals(toUserIds) && CollectionUtil.isNotEmpty(userList = this.userService.getUserByIds(toUserArr = Arrays.asList(toUserIds.split(","))))) {
                vo.setToUserIds(userList.stream().map(UserEntity::getRealName).collect(Collectors.joining(",")));
            }
            if (StringUtils.isNotEmpty((String)(toDeptIds = vo.getToDeptIds())) && CollectionUtil.isNotEmpty(deptList = this.organizeService.getListAll(toDeptArr = Arrays.asList(toDeptIds.split(",")), null))) {
                vo.setToDeptIds(deptList.stream().map(OrganizeEntity::getFullName).collect(Collectors.joining(",")));
            }
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
            McMsgSendEntity msgSendEntity = this.mcMsgSendService.getEntityByEnCode(vo.getSendCode());
            if (ObjectUtil.isNotNull((Object)msgSendEntity)) {
                vo.setSendName(msgSendEntity.getFullName());
            }
            if (!StringUtils.isNotEmpty((String)(taskCode = this.baseDataUtil.getDictName(vo.getTaskCode(), "taskCode")))) continue;
            vo.setTaskCode(taskCode);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mcTaskMsgPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid McTaskMsgCrForm mcTaskMsgCrForm) throws DataException {
        try {
            this.mcTaskMsgService.addTaskMsg(mcTaskMsgCrForm);
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
        catch (Exception e) {
            return ActionResult.fail((String)("\u521b\u5efa\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<McTaskMsgInfoVO> info(@PathVariable(value="id") String id) {
        McTaskMsgEntity entity = this.mcTaskMsgService.getInfo(id);
        McTaskMsgInfoVO vo = (McTaskMsgInfoVO)JsonUtil.getJsonToBean((Object)entity, McTaskMsgInfoVO.class);
        McMsgSendEntity msgSendEntity = this.mcMsgSendService.getEntityByEnCode(vo.getSendCode());
        if (ObjectUtil.isNotNull((Object)msgSendEntity)) {
            vo.setSendName(msgSendEntity.getFullName());
        }
        this.mcTaskMsgReceiveService.updateIsReadByMsgIdAndUserId(id, this.userProvider.get().getUserId());
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<McTaskMsgInfoVO> detailInfo(@PathVariable(value="id") String id) {
        List<String> toDeptArr;
        List<OrganizeEntity> deptList;
        String toDeptIds;
        List<String> toUserArr;
        List<UserEntity> userList;
        McTaskMsgEntity entity = this.mcTaskMsgService.getInfo(id);
        McTaskMsgInfoVO vo = (McTaskMsgInfoVO)JsonUtil.getJsonToBean((Object)entity, McTaskMsgInfoVO.class);
        String toUserIds = vo.getToUserIds();
        if (StringUtils.isNotEmpty((String)toUserIds) && !"@ALL".equals(toUserIds) && CollectionUtil.isNotEmpty(userList = this.userService.getUserByIds(toUserArr = Arrays.asList(toUserIds.split(","))))) {
            vo.setToUserIds(userList.stream().map(UserEntity::getRealName).collect(Collectors.joining(",")));
        }
        if (StringUtils.isNotEmpty((String)(toDeptIds = vo.getToDeptIds())) && CollectionUtil.isNotEmpty(deptList = this.organizeService.getListAll(toDeptArr = Arrays.asList(toDeptIds.split(",")), null))) {
            vo.setToDeptIds(deptList.stream().map(OrganizeEntity::getFullName).collect(Collectors.joining(",")));
        }
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid McTaskMsgUpForm mcTaskMsgUpForm) throws DataException {
        McTaskMsgEntity entity = this.mcTaskMsgService.getInfo(id);
        if (entity != null) {
            this.mcTaskMsgService.update(id, mcTaskMsgUpForm);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        McTaskMsgEntity entity = this.mcTaskMsgService.getInfo(id);
        if (entity != null) {
            this.mcTaskMsgService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/send/{id}"})
    public ActionResult send(@PathVariable(value="id") String id) throws DataException {
        McTaskMsgEntity entity = this.mcTaskMsgService.getInfo(id);
        if (entity != null) {
            try {
                this.mcTaskMsgService.sendTaskMsgReceive(entity);
                return ActionResult.success((String)"\u53d1\u9001\u6210\u529f");
            }
            catch (Exception e) {
                e.printStackTrace();
                String message = "\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage();
                log.error(message);
                return ActionResult.fail((String)message);
            }
        }
        return ActionResult.fail((String)"\u53d1\u9001\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }
}

