/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgCenter.entity.McMsgSendEntity;
import com.bringspring.system.msgCenter.model.BusinessKeys;
import com.bringspring.system.msgCenter.model.TaskMsg;
import com.bringspring.system.msgCenter.service.McMsgSendService;
import com.bringspring.system.msgCenter.util.SendTaskMsgUtils;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.util.concurrent.Executor;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e1a\u52a1\u6d88\u606f\u53d1\u9001\u63a5\u53e3\u670d\u52a1"}, value="messageService")
@RequestMapping(value={"/api/outer/messageService"})
public class MsgCenterService {
    private static final Logger log = LoggerFactory.getLogger(MsgCenterService.class);
    @Autowired
    private Executor threadPoolExecutor;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;
    @Autowired
    private McMsgSendService mcMsgSendService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @PostMapping(value={"/taskMsg/send"})
    public ActionResult create(@RequestBody @Valid TaskMsg taskMsg) throws DataException {
        String errMsg = "\u4e1a\u52a1\u6d88\u606f\u53d1\u9001";
        if (ObjectUtil.isNotEmpty((Object)taskMsg)) {
            String taskCode = taskMsg.getTaskCode();
            if (StringUtils.isEmpty((String)taskCode)) {
                errMsg = errMsg + "\uff0c\u5931\u8d25\uff1ataskCode\u4e0d\u80fd\u4e3a\u7a7a";
                log.error(errMsg);
                return ActionResult.fail((String)errMsg);
            }
            if (StringUtils.isEmpty((String)this.baseDataUtil.getDictName(taskCode, "taskCode"))) {
                errMsg = errMsg + "\uff0c\u5931\u8d25\uff1ataskCode\u672a\u6388\u6743";
                log.error(errMsg);
                return ActionResult.fail((String)errMsg);
            }
            String sendCode = taskMsg.getSendCode();
            if (StringUtils.isEmpty((String)sendCode)) {
                errMsg = errMsg + "\uff0c\u5931\u8d25\uff1asendCode\u4e0d\u80fd\u4e3a\u7a7a";
                log.error(errMsg);
                return ActionResult.fail((String)errMsg);
            }
            McMsgSendEntity msgSendEntity = this.mcMsgSendService.getValidInfo(sendCode);
            if (ObjectUtil.isEmpty((Object)msgSendEntity)) {
                errMsg = errMsg + "\uff0c\u5931\u8d25\uff1asendCode\u4e0d\u5b58\u5728\u6216\u7981\u7528\uff0c\u8bf7\u786e\u5b9a\u53d1\u9001\u914d\u7f6e\u7f16\u7801";
                log.error(errMsg);
                return ActionResult.fail((String)errMsg);
            }
            BusinessKeys businessKey = taskMsg.getBusinessKey();
            if (ObjectUtil.isEmpty((Object)businessKey)) {
                errMsg = errMsg + "\uff0c\u5931\u8d25\uff1abusinessKey\u4e0d\u80fd\u4e3a\u7a7a";
                log.error(errMsg);
                return ActionResult.fail((String)errMsg);
            }
            String toUserIds = taskMsg.getToUserIds();
            String toDeptIds = taskMsg.getToDeptIds();
            if (StringUtils.isEmpty((String)toUserIds) && StringUtils.isEmpty((String)toDeptIds)) {
                errMsg = errMsg + "\uff0c\u5931\u8d25\uff1a\u65e0\u6548\u7684\u63a5\u6536\u4eba";
                log.error(errMsg);
                return ActionResult.fail((String)errMsg);
            }
            this.threadPoolExecutor.execute(() -> {
                try {
                    this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u5931\u8d25: " + e.getMessage());
                }
            });
            return ActionResult.success((String)"\u53d1\u9001\u6210\u529f");
        }
        errMsg = errMsg + "\uff0c\u5931\u8d25\uff1a\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
        log.error(errMsg);
        return ActionResult.fail((String)errMsg);
    }
}

