/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.external.config.mutil.DingTalkConfiguration;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgCenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgCenter.model.message.DingSentResult;
import com.bringspring.system.msgCenter.model.message.MyDingTalkModel;
import com.bringspring.system.msgCenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgCenter.util.BlacklistUtil;
import com.bringspring.system.msgCenter.util.DingTalkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MsgToDingService {
    private static final Logger log = LoggerFactory.getLogger(MsgToDingService.class);
    @Autowired
    private DingTalkConfiguration dingTalkConfiguration;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;

    public void sendMessage(boolean isAgain, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS) {
        if (CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u9489\u9489\u6d88\u606f\u4e0b\u53d1\uff0c\u63a5\u6536\u4eba\u5217\u8868\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        List receiveList = JsonUtil.getJsonToList(receiveListS, McTaskMsgReceiveEntity.class);
        Boolean toUserIdAll = false;
        List<McTaskMsgReceiveEntity> receiveBlacklist = BlacklistUtil.receiveListFilter(receiveList);
        if (CollectionUtil.isNotEmpty((Collection)receiveList)) {
            List<McTaskMsgReceiveEntity> thirdNullList = receiveList.stream().filter(r -> StringUtils.isEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
            List thirdNotNullList = receiveList.stream().filter(r -> StringUtils.isNotEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
            List thirdInfoIds = thirdNotNullList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(thirdInfoIds)) {
                List thirdInfoList = this.synThirdInfoService.listByIds(thirdInfoIds);
                List thirdUseridNullList = thirdInfoList.stream().filter(r -> StringUtils.isEmpty((String)r.getThirdObjectId())).collect(Collectors.toList());
                List<McTaskMsgReceiveEntity> useridNullList = thirdNotNullList.stream().filter(r -> thirdUseridNullList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
                List<SynThirdInfoEntity> thirdUseridNotNullList = thirdInfoList.stream().filter(r -> StringUtils.isNotEmpty((String)r.getThirdObjectId())).collect(Collectors.toList());
                List<McTaskMsgReceiveEntity> useridNotNullList = thirdNotNullList.stream().filter(r -> thirdUseridNotNullList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
                HashMap<String, DingSentResult> resultMap = new HashMap<String, DingSentResult>();
                if (!toUserIdAll.booleanValue()) {
                    HashMap corpUserMap = new HashMap();
                    if (CollectionUtil.isNotEmpty(thirdUseridNotNullList)) {
                        for (SynThirdInfoEntity synThirdInfoEntity : thirdUseridNotNullList) {
                            if (!StringUtils.isNotEmpty((String)synThirdInfoEntity.getThirdObjectId())) continue;
                            String corpid = synThirdInfoEntity.getCropId();
                            String userid = synThirdInfoEntity.getThirdObjectId();
                            if (corpUserMap.containsKey(corpid)) {
                                ((List)corpUserMap.get(corpid)).add(userid);
                                continue;
                            }
                            ArrayList<String> useridList = new ArrayList<String>();
                            useridList.add(userid);
                            corpUserMap.put(corpid, useridList);
                        }
                    }
                    if (CollectionUtil.isNotEmpty(corpUserMap)) {
                        for (Map.Entry entry : corpUserMap.entrySet()) {
                            MyDingTalkModel dingTalkModel = this.dingTalkConfiguration.getDingTalkModel((String)entry.getKey());
                            String appKey = dingTalkModel.getClientId();
                            String appSecret = dingTalkModel.getClientSecrent();
                            String agentId = dingTalkModel.getAgentId();
                            String corpId = dingTalkModel.getCorpId();
                            String touser = StringUtils.join((Iterable)((Iterable)entry.getValue()), (String)",");
                            DingSentResult result = DingTalkUtil.sendDingMessage(appKey, appSecret, agentId, touser, taskMsgContent);
                            System.out.println("~\u00b7~\u53d1\u9001\u6d88\u606f\uff1a" + corpId + result);
                            resultMap.put(corpId, result);
                        }
                    }
                } else {
                    Map<String, MyDingTalkModel> dingTalkModels = this.dingTalkConfiguration.getDingTalkModels();
                    for (MyDingTalkModel myDingTalkModel : dingTalkModels.values()) {
                        String appKey = myDingTalkModel.getClientId();
                        String appSecret = myDingTalkModel.getClientSecrent();
                        String agentId = myDingTalkModel.getAgentId();
                        String corpId = myDingTalkModel.getCorpId();
                        DingSentResult result = DingTalkUtil.sendDingMessage(appKey, appSecret, agentId, "@to_all_user", taskMsgContent);
                        System.out.println("~\u00b7~\u53d1\u9001\u6d88\u606f@all\uff1a" + corpId + result);
                        resultMap.put(corpId, result);
                    }
                }
                if (CollectionUtil.isNotEmpty(resultMap)) {
                    this.dingSendMessageResult(isAgain, taskMsgContent, useridNotNullList, thirdUseridNotNullList, resultMap);
                }
                if (CollectionUtil.isNotEmpty(useridNullList)) {
                    String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "third\u65e0userid";
                    this.mcTaskMsgReceiveService.updateByList(isAgain, useridNullList, 2, errMsg);
                }
            }
            if (CollectionUtil.isNotEmpty(thirdNullList)) {
                String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "\u65e0third\u7ed1\u5b9a\u6570\u636e";
                this.mcTaskMsgReceiveService.updateByList(isAgain, thirdNullList, 2, errMsg);
            }
        }
        if (CollectionUtil.isNotEmpty(receiveBlacklist)) {
            this.mcTaskMsgReceiveService.updateBlacklist(receiveBlacklist);
        }
    }

    public void dingSendMessageResult(boolean isAgain, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveList, List<SynThirdInfoEntity> thirdInfoList, Map<String, DingSentResult> resultMap) {
        if (CollectionUtil.isNotEmpty(receiveList)) {
            String errMsg = isAgain ? "\u91cd\u53d1\u6210\u529f\uff1a" : "\u4e0b\u53d1\u6210\u529f\uff1a";
            this.mcTaskMsgReceiveService.updateByList(isAgain, receiveList, 1, errMsg);
        }
        if (CollectionUtil.isNotEmpty(resultMap)) {
            for (Map.Entry<String, DingSentResult> entry : resultMap.entrySet()) {
                DingSentResult result = entry.getValue();
                if (!ObjectUtil.isNotEmpty((Object)result) || !StringUtils.isNotEmpty((String)result.getFailUser())) continue;
                List<String> failUserList = Arrays.asList(result.getFailUser().split(","));
                List failThirdList = thirdInfoList.stream().filter(r -> failUserList.contains(r.getThirdObjectId())).collect(Collectors.toList());
                List<McTaskMsgReceiveEntity> list = receiveList.stream().filter(r -> failThirdList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
                if (!CollectionUtil.isNotEmpty(list)) continue;
                String errMsg = isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a" + result.getErrMsg();
                this.mcTaskMsgReceiveService.updateByList(isAgain, list, 2, errMsg);
            }
        }
    }
}

