/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgCenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgCenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgCenter.model.mcMsgSendTemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgCenter.model.message.MyEmailModel;
import com.bringspring.system.msgCenter.service.McMsgAccountService;
import com.bringspring.system.msgCenter.service.McMsgTemplateService;
import com.bringspring.system.msgCenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgCenter.util.BlacklistUtil;
import com.bringspring.system.msgCenter.util.EmailUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MsgToEmailService {
    private static final Logger log = LoggerFactory.getLogger(MsgToEmailService.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;

    public void sendEmail(boolean isAgain, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u7535\u5b50\u90ae\u4ef6\u6d88\u606f\u4e0b\u53d1\uff0c\u4f46taskMsgContent\u4e3a\u7a7a \u6216 receiveList\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        List receiveList = JsonUtil.getJsonToList(receiveListS, McTaskMsgReceiveEntity.class);
        McMsgTemplateEntity templateInfo = this.mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        McMsgAccountEntity msgAccount = this.mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        if (ObjectUtil.isNotNull((Object)templateInfo) && ObjectUtil.isNotNull((Object)msgAccount)) {
            List<McTaskMsgReceiveEntity> receiveBlacklist = BlacklistUtil.receiveListFilter(receiveList);
            if (CollectionUtil.isNotEmpty((Collection)receiveList)) {
                List<McTaskMsgReceiveEntity> emailNullList = receiveList.stream().filter(r -> StringUtils.isEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
                List<McTaskMsgReceiveEntity> emailNotNullList = receiveList.stream().filter(r -> StringUtils.isNotEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
                List emailList = emailNotNullList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(emailList)) {
                    HashMap<String, String> objModel = new HashMap<String, String>();
                    objModel.put("emailSmtpHost", msgAccount.getSmtpServer());
                    objModel.put("emailSmtpPort", msgAccount.getSmtpPort().toString());
                    objModel.put("emailSenderName", msgAccount.getAddressorName());
                    objModel.put("emailAccount", msgAccount.getSmtpUser());
                    objModel.put("emailPassword", msgAccount.getSmtpPassword());
                    objModel.put("emailSsl", msgAccount.getSslLink().equals("1") ? "true" : "false");
                    MyEmailModel emailModel = (MyEmailModel)JsonUtil.getJsonToBean(objModel, MyEmailModel.class);
                    emailModel.setEmailTitle(taskMsgContent.getTitle());
                    emailModel.setEmailContent(taskMsgContent.getContent());
                    String toUserMail = StringUtils.join(emailList, (String)",");
                    emailModel.setEmailToUsers(toUserMail);
                    JSONObject retJson = EmailUtil.sendMail(emailModel);
                    if (!retJson.getBoolean("code").booleanValue()) {
                        log.error("\u53d1\u9001\u5931\u8d25");
                    }
                    if (!retJson.getBoolean("code").booleanValue()) {
                        String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + retJson.getString("error");
                        this.mcTaskMsgReceiveService.updateByList(isAgain, emailNotNullList, 2, errMsg);
                    } else {
                        String errMsg = (isAgain ? "\u91cd\u53d1\u6210\u529f\uff1a" : "\u4e0b\u53d1\u6210\u529f\uff1a") + retJson.getString("error");
                        this.mcTaskMsgReceiveService.updateByList(isAgain, emailNotNullList, 1, errMsg);
                    }
                }
                if (CollectionUtil.isNotEmpty(emailNullList)) {
                    String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "\u65e0\u6709\u6548\u7535\u5b50\u90ae\u7bb1";
                    this.mcTaskMsgReceiveService.updateByList(isAgain, emailNullList, 2, errMsg);
                }
            }
            if (CollectionUtil.isNotEmpty(receiveBlacklist)) {
                this.mcTaskMsgReceiveService.updateBlacklist(receiveBlacklist);
            }
        }
    }
}

