/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgCenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgCenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgCenter.model.MySmsModel;
import com.bringspring.system.msgCenter.model.mcMsgSendTemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgCenter.service.McMsgAccountService;
import com.bringspring.system.msgCenter.service.McMsgTemplateService;
import com.bringspring.system.msgCenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgCenter.util.BlacklistUtil;
import com.bringspring.system.msgCenter.util.SmsSentUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MsgToSmsService {
    private static final Logger log = LoggerFactory.getLogger(MsgToSmsService.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;

    public void sendSms(boolean isAgain, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u77ed\u4fe1\u6d88\u606f\u4e0b\u53d1\uff0c\u4f46taskMsgContent\u4e3a\u7a7a \u6216 receiveList\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        List receiveList = JsonUtil.getJsonToList(receiveListS, McTaskMsgReceiveEntity.class);
        McMsgTemplateEntity templateInfo = this.mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        McMsgAccountEntity msgAccount = this.mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        if (ObjectUtil.isNotNull((Object)templateInfo) && ObjectUtil.isNotNull((Object)msgAccount)) {
            List<McTaskMsgReceiveEntity> receiveBlacklist = BlacklistUtil.receiveListFilter(receiveList);
            if (CollectionUtil.isNotEmpty((Collection)receiveList)) {
                List<McTaskMsgReceiveEntity> phoneNullList = receiveList.stream().filter(r -> StringUtils.isEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
                List<McTaskMsgReceiveEntity> phoneNotNullList = receiveList.stream().filter(r -> StringUtils.isNotEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
                List phoneList = phoneNotNullList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(phoneList)) {
                    String phoneNumbers = StringUtils.join(phoneList, (String)",");
                    HashMap<String, String> objModel = new HashMap<String, String>(16);
                    objModel.put("aliAccessKey", msgAccount.getAppId());
                    objModel.put("aliSecret", msgAccount.getAppSecret());
                    objModel.put("tencentSecretId", msgAccount.getAppId());
                    objModel.put("tencentSecretKey", msgAccount.getAppSecret());
                    objModel.put("tencentAppId", msgAccount.getSdkAppId());
                    objModel.put("tencentAppKey", msgAccount.getAppKey());
                    MySmsModel smsConfig = (MySmsModel)JsonUtil.getJsonToBean(objModel, MySmsModel.class);
                    int company = msgAccount.getChannel();
                    String content = taskMsgContent.getContent();
                    Map msgMap = JsonUtil.stringToMap((String)content);
                    String templateCode = templateInfo.getTemplateCode();
                    String endPoint = "";
                    String channelStr = String.valueOf(msgAccount.getChannel());
                    if ("1".equals(channelStr)) {
                        endPoint = msgAccount.getEndPoint();
                    } else if ("2".equals(channelStr)) {
                        endPoint = msgAccount.getZoneName();
                    }
                    String res = SmsSentUtil.sentSms(company, smsConfig, endPoint, msgAccount.getZoneParam(), phoneNumbers, msgAccount.getSmsSignature(), templateCode, msgMap);
                    if ("Ok".equals(res)) {
                        String errMsg = (isAgain ? "\u91cd\u53d1\u6210\u529f\uff1a" : "\u4e0b\u53d1\u6210\u529f\uff1a") + res;
                        this.mcTaskMsgReceiveService.updateByList(isAgain, phoneNotNullList, 1, errMsg);
                    } else {
                        String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + res;
                        this.mcTaskMsgReceiveService.updateByList(isAgain, phoneNotNullList, 2, errMsg);
                    }
                }
                if (CollectionUtil.isNotEmpty(phoneNullList)) {
                    String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "\u65e0\u6709\u6548\u624b\u673a\u53f7";
                    this.mcTaskMsgReceiveService.updateByList(isAgain, phoneNullList, 2, errMsg);
                }
            }
            if (CollectionUtil.isNotEmpty(receiveBlacklist)) {
                this.mcTaskMsgReceiveService.updateBlacklist(receiveBlacklist);
            }
        }
    }
}

