/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgCenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgCenter.service.McMsgAccountService;
import com.bringspring.system.msgCenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgCenter.util.WebHookUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MsgToWebhookService {
    private static final Logger log = LoggerFactory.getLogger(MsgToWebhookService.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;

    public void sendWebhook(boolean isAgain, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveList) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || CollectionUtil.isEmpty(receiveList)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 webhook\u6d88\u606f\u4e0b\u53d1\uff0c\u4f46taskMsgContent\u4e3a\u7a7a \u6216 receiveList\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        for (McTaskMsgReceiveEntity receive : receiveList) {
            if (StringUtils.isNotEmpty((String)receive.getReceiveUserId())) {
                McMsgAccountEntity msgAccount = this.mcMsgAccountService.getInfo(receive.getReceiveUserId());
                if (ObjectUtil.isNotNull((Object)msgAccount)) {
                    String errMsg;
                    String approveType = String.valueOf(msgAccount.getApproveType());
                    String webhookType = String.valueOf(msgAccount.getWebhookType());
                    String webhookAddress = msgAccount.getWebhookAddress();
                    String content = taskMsgContent.getContent();
                    JSONObject retJson = new JSONObject();
                    switch (webhookType) {
                        case "1": {
                            if ("1".equals(approveType)) {
                                retJson = WebHookUtil.sendDDMessage(webhookAddress, content);
                                break;
                            }
                            if (!"2".equals(approveType)) break;
                            retJson = WebHookUtil.sendDingDing(webhookAddress, msgAccount.getBearer(), content);
                            break;
                        }
                        case "2": {
                            if (!"1".equals(approveType)) break;
                            retJson = WebHookUtil.callWeChatBot(webhookAddress, content);
                            break;
                        }
                    }
                    if ("ok".equals(retJson.getString("errmsg"))) {
                        errMsg = (isAgain ? "\u91cd\u53d1\u6210\u529f\uff1a" : "\u4e0b\u53d1\u6210\u529f\uff1a") + JSONObject.toJSONString((Object)retJson);
                        this.settingResult(isAgain, receive, 1, errMsg);
                        continue;
                    }
                    errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + JSONObject.toJSONString((Object)retJson);
                    this.settingResult(isAgain, receive, 2, errMsg);
                    continue;
                }
                String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "\u65e0\u6548\u7684\u63a5\u6536\u4eba\uff0c\u672a\u6307\u5b9a\u6709\u6548\u7684webhook\u914d\u7f6e";
                this.settingResult(isAgain, receive, 2, errMsg);
                continue;
            }
            String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "\u7a7a\u7684\u63a5\u6536\u4eba\uff0c\u672a\u6307\u5b9awebhook\u914d\u7f6e";
            this.settingResult(isAgain, receive, 2, errMsg);
        }
        this.mcTaskMsgReceiveService.updateBatchById(receiveList);
    }

    private void settingResult(boolean isAgain, McTaskMsgReceiveEntity receive, Integer enabledMark, String remark) {
        if (!isAgain) {
            receive.setEnabledMark(enabledMark);
            receive.setSendTime(new Date());
            receive.setSendUserId(this.userProvider.get().getUserId());
            receive.setDescription(remark);
            receive.setAutoAgainNum(0);
        } else {
            receive.setEnabledMark(enabledMark);
            receive.setAgainTime(new Date());
            receive.setAgainUserId(this.userProvider.get().getUserId());
            receive.setDescription(remark);
            if (ObjectUtil.isEmpty((Object)receive.getAutoAgainNum())) {
                receive.setAutoAgainNum(0);
            } else {
                receive.setAutoAgainNum(receive.getAutoAgainNum() + 1);
            }
        }
    }
}

