/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgCenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgCenter.enums.ContentTypeEnum;
import com.bringspring.system.msgCenter.enums.ErrCodeEnum;
import com.bringspring.system.msgCenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgCenter.util.BlacklistUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.article.NewArticle;
import me.chanjar.weixin.cp.bean.message.WxCpLinkedCorpMessage;
import me.chanjar.weixin.cp.bean.message.WxCpLinkedCorpMessageSendResult;
import me.chanjar.weixin.cp.bean.message.WxCpMessage;
import me.chanjar.weixin.cp.bean.message.WxCpMessageSendResult;
import me.chanjar.weixin.cp.bean.messagebuilder.NewsBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TextBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TextCardBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MsgToWxCpService {
    private static final Logger log = LoggerFactory.getLogger(MsgToWxCpService.class);
    @Autowired
    WxCpConfiguration wxCpConfiguration;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;

    public void sendMessage(boolean isAgain, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS) {
        if (CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u4e0b\u53d1\uff0c\u63a5\u6536\u4eba\u5217\u8868\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        List receiveList = JsonUtil.getJsonToList(receiveListS, McTaskMsgReceiveEntity.class);
        Boolean toUserIdAll = false;
        List<McTaskMsgReceiveEntity> receiveBlacklist = BlacklistUtil.receiveListFilter(receiveList);
        if (CollectionUtil.isNotEmpty((Collection)receiveList)) {
            List<McTaskMsgReceiveEntity> thirdNullList = receiveList.stream().filter(r -> StringUtils.isEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
            List thirdNotNullList = receiveList.stream().filter(r -> StringUtils.isNotEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
            List thirdInfoIds = thirdNotNullList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(thirdInfoIds)) {
                List thirdInfoList = this.synThirdInfoService.listByIds(thirdInfoIds);
                List thirdUseridNullList = thirdInfoList.stream().filter(r -> StringUtils.isEmpty((String)r.getThirdObjectId())).collect(Collectors.toList());
                List<McTaskMsgReceiveEntity> useridNullList = thirdNotNullList.stream().filter(r -> thirdUseridNullList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
                List<SynThirdInfoEntity> thirdUseridNotNullList = thirdInfoList.stream().filter(r -> StringUtils.isNotEmpty((String)r.getThirdObjectId())).collect(Collectors.toList());
                List<McTaskMsgReceiveEntity> useridNotNullList = thirdNotNullList.stream().filter(r -> thirdUseridNotNullList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
                HashMap<String, WxCpMessageSendResult> resultMap = new HashMap<String, WxCpMessageSendResult>();
                if (!toUserIdAll.booleanValue()) {
                    HashMap corpUserMap = new HashMap();
                    if (CollectionUtil.isNotEmpty(thirdUseridNotNullList)) {
                        for (SynThirdInfoEntity synThirdInfoEntity : thirdUseridNotNullList) {
                            if (!StringUtils.isNotEmpty((String)synThirdInfoEntity.getThirdObjectId())) continue;
                            String corpid = synThirdInfoEntity.getCropId();
                            String userid = synThirdInfoEntity.getThirdObjectId();
                            if (corpUserMap.containsKey(corpid)) {
                                ((List)corpUserMap.get(corpid)).add(userid);
                                continue;
                            }
                            ArrayList<String> useridList = new ArrayList<String>();
                            useridList.add(userid);
                            corpUserMap.put(corpid, useridList);
                        }
                    }
                    if (CollectionUtil.isNotEmpty(corpUserMap)) {
                        for (Map.Entry entry : corpUserMap.entrySet()) {
                            WxCpMessageSendResult result;
                            WeComModel weComModel = this.wxCpConfiguration.getWeComModel((String)entry.getKey());
                            String corpId = weComModel.getQyhCorpId();
                            Integer agentId = Integer.valueOf(weComModel.getQyhAgentId());
                            String touser = StringUtils.join((Iterable)((Iterable)entry.getValue()), (String)"|");
                            try {
                                result = this.postMessageSend(taskMsgContent, corpId, agentId, touser);
                            }
                            catch (WxErrorException e) {
                                e.printStackTrace();
                                result = new WxCpMessageSendResult();
                                result.setErrCode(Integer.valueOf(ErrCodeEnum.SEND_EXCEPTION.getCode()));
                                result.setInvalidUser(touser);
                                result.setErrMsg(e.getMessage());
                            }
                            System.out.println("~\u00b7~\u53d1\u9001\u6d88\u606f\uff1a" + corpId + result);
                            resultMap.put(corpId, result);
                        }
                    }
                } else {
                    Map<String, WeComModel> weComModels = this.wxCpConfiguration.getWeComModels();
                    for (WeComModel weComModel : weComModels.values()) {
                        String corpId = weComModel.getQyhCorpId();
                        Integer agentId = Integer.valueOf(weComModel.getQyhAgentId());
                        WxCpMessageSendResult result = null;
                        try {
                            result = this.postMessageSend(taskMsgContent, corpId, agentId, "@all");
                        }
                        catch (WxErrorException e) {
                            e.printStackTrace();
                            result = new WxCpMessageSendResult();
                            result.setErrCode(Integer.valueOf(ErrCodeEnum.SEND_EXCEPTION.getCode()));
                            List userIds = receiveList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
                            String touser = StringUtils.join(userIds, (String)"|");
                            result.setInvalidUser(touser);
                            result.setErrMsg(e.getMessage());
                        }
                        System.out.println("~\u00b7~\u53d1\u9001\u6d88\u606f@all\uff1a" + corpId + result);
                        resultMap.put(corpId, result);
                    }
                }
                if (CollectionUtil.isNotEmpty(resultMap)) {
                    this.wxCpSendMessageResult(isAgain, taskMsgContent, useridNotNullList, thirdUseridNotNullList, resultMap);
                }
                if (CollectionUtil.isNotEmpty(useridNullList)) {
                    String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "third\u65e0userid";
                    this.mcTaskMsgReceiveService.updateByList(isAgain, useridNullList, 2, errMsg);
                }
            }
            if (CollectionUtil.isNotEmpty(thirdNullList)) {
                String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "\u65e0third\u7ed1\u5b9a\u6570\u636e";
                this.mcTaskMsgReceiveService.updateByList(isAgain, thirdNullList, 2, errMsg);
            }
        }
        if (CollectionUtil.isNotEmpty(receiveBlacklist)) {
            this.mcTaskMsgReceiveService.updateBlacklist(receiveBlacklist);
        }
    }

    public WxCpMessageSendResult postMessageSend(McTaskMsgContentEntity taskMsgContent, String corpId, Integer agentId, String touser) throws WxErrorException {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || StringUtils.isEmpty((String)corpId) || StringUtils.isEmpty((String)touser)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u6267\u884c \u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u6d88\u606fpost\u4e0b\u53d1\uff0ccontent \u6216 corpId\u4f01\u4e1aid \u6216 touser\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        WxCpService corpService = this.wxCpConfiguration.getCpService(corpId, agentId);
        String contentType = StringUtils.isNotEmpty((String)taskMsgContent.getContentType()) ? taskMsgContent.getContentType() : ContentTypeEnum.TEXT_MSG.getCode();
        String title = taskMsgContent.getTitle();
        String content = taskMsgContent.getContent();
        String linkUrl = taskMsgContent.getLinkUrl();
        if (ContentTypeEnum.TEXT_MSG.getCode().equals(contentType)) {
            WxCpMessage message = ((TextBuilder)WxCpMessage.TEXT().toUser(touser)).content(content).build();
            return corpService.getMessageService().send(message);
        }
        if (ContentTypeEnum.LINK_MSG.getCode().equals(contentType)) {
            WxCpMessage message = ((TextCardBuilder)WxCpMessage.TEXTCARD().toUser(touser)).description(content).url(linkUrl).title(title).build();
            return corpService.getMessageService().send(message);
        }
        if (ContentTypeEnum.IMG_TEXT_MSG.getCode().equals(contentType)) {
            NewArticle article1 = new NewArticle();
            article1.setUrl(linkUrl);
            article1.setPicUrl(taskMsgContent.getPicUrl());
            article1.setDescription(content);
            article1.setTitle(title);
            WxCpMessage message = ((NewsBuilder)WxCpMessage.NEWS().toUser(touser)).addArticle(new NewArticle[]{article1}).build();
            return corpService.getMessageService().send(message);
        }
        return null;
    }

    public void wxCpSendMessageResult(boolean isAgain, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveList, List<SynThirdInfoEntity> thirdInfoList, Map<String, WxCpMessageSendResult> resultMap) {
        if (CollectionUtil.isNotEmpty(receiveList)) {
            String errMsg = isAgain ? "\u91cd\u53d1\u6210\u529f\uff1a" : "\u4e0b\u53d1\u6210\u529f\uff1a";
            this.mcTaskMsgReceiveService.updateByList(isAgain, receiveList, 1, errMsg);
        }
        if (CollectionUtil.isNotEmpty(resultMap)) {
            for (Map.Entry<String, WxCpMessageSendResult> entry : resultMap.entrySet()) {
                WxCpMessageSendResult result = entry.getValue();
                if (!ObjectUtil.isNotEmpty((Object)result) || !CollectionUtil.isNotEmpty((Collection)result.getInvalidUserList())) continue;
                List invalidUserList = result.getInvalidUserList();
                List invalidThirdList = thirdInfoList.stream().filter(r -> invalidUserList.contains(r.getThirdObjectId())).collect(Collectors.toList());
                List<McTaskMsgReceiveEntity> list = receiveList.stream().filter(r -> invalidThirdList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
                if (!CollectionUtil.isNotEmpty(list)) continue;
                String errMsg = isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a";
                errMsg = ErrCodeEnum.SEND_EXCEPTION.getCode() == result.getErrCode().intValue() ? errMsg + errMsg + result.getErrMsg() : errMsg + errMsg + "\u4e0d\u5408\u6cd5\u7684userid";
                this.mcTaskMsgReceiveService.updateByList(isAgain, list, 2, errMsg);
            }
        }
    }

    public void sendLinkedCorpMessage(boolean isAgain, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u4e92\u8054\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u4e0b\u53d1\uff0c\u4f46message content\u4e3a\u7a7a \u6216 \u63a5\u6536\u4eba\u5217\u8868\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        List receiveList = JsonUtil.getJsonToList(receiveListS, McTaskMsgReceiveEntity.class);
        Boolean toUserIdAll = false;
        List<McTaskMsgReceiveEntity> receiveBlacklist = BlacklistUtil.receiveListFilter(receiveList);
        if (CollectionUtil.isNotEmpty((Collection)receiveList)) {
            List<McTaskMsgReceiveEntity> thirdNullList = receiveList.stream().filter(r -> StringUtils.isEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
            List thirdNotNullList = receiveList.stream().filter(r -> StringUtils.isNotEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
            List thirdInfoIds = thirdNotNullList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(thirdInfoIds)) {
                List thirdInfoList = this.synThirdInfoService.listByIds(thirdInfoIds);
                List thirdUseridNullList = thirdInfoList.stream().filter(r -> StringUtils.isEmpty((String)r.getThirdObjectId())).collect(Collectors.toList());
                List<McTaskMsgReceiveEntity> useridNullList = thirdNotNullList.stream().filter(r -> thirdUseridNullList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
                List<SynThirdInfoEntity> thirdUseridNotNullList = thirdInfoList.stream().filter(r -> StringUtils.isNotEmpty((String)r.getThirdObjectId())).collect(Collectors.toList());
                List<McTaskMsgReceiveEntity> useridNotNullList = thirdNotNullList.stream().filter(r -> thirdUseridNotNullList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
                Map<String, WeComModel> weComModels = this.wxCpConfiguration.getWeComModels();
                Optional<WeComModel> firstValue = weComModels.values().stream().findFirst();
                if (firstValue.isPresent() && firstValue.get().getIsLinkedCorp().booleanValue()) {
                    WxCpLinkedCorpMessageSendResult result;
                    String qyhCorpId = firstValue.get().getQyhCorpId();
                    Integer qyhAgentId = Integer.valueOf(firstValue.get().getQyhAgentId());
                    if (!toUserIdAll.booleanValue()) {
                        String[] toUsers = thirdUseridNotNullList.stream().map(t -> t.getThirdObjectId()).collect(Collectors.toList()).toArray(new String[0]);
                        try {
                            result = this.postLinkedCorpMessageSend(taskMsgContent, qyhCorpId, qyhAgentId, toUserIdAll, toUsers);
                        }
                        catch (WxErrorException e) {
                            e.printStackTrace();
                            result = new WxCpLinkedCorpMessageSendResult();
                            result.setErrcode(Long.valueOf(ErrCodeEnum.SEND_EXCEPTION.getCode()));
                            result.setInvalidUser(toUsers);
                            result.setErrmsg(e.getMessage());
                        }
                    } else {
                        try {
                            result = this.postLinkedCorpMessageSend(taskMsgContent, qyhCorpId, qyhAgentId, toUserIdAll, null);
                        }
                        catch (WxErrorException e) {
                            e.printStackTrace();
                            result = new WxCpLinkedCorpMessageSendResult();
                            result.setErrcode(Long.valueOf(ErrCodeEnum.SEND_EXCEPTION.getCode()));
                            String[] toUsers = receiveList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList()).toArray(new String[0]);
                            result.setInvalidUser(toUsers);
                            result.setErrmsg(e.getMessage());
                        }
                    }
                    if (ObjectUtil.isNotEmpty((Object)result)) {
                        this.wxCpLinkedCorpSendMessageResult(isAgain, taskMsgContent, useridNotNullList, thirdUseridNotNullList, result);
                    }
                }
                if (CollectionUtil.isNotEmpty(useridNullList)) {
                    String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "third\u65e0userid";
                    this.mcTaskMsgReceiveService.updateByList(isAgain, useridNullList, 2, errMsg);
                }
            }
            if (CollectionUtil.isNotEmpty(thirdNullList)) {
                String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "\u65e0third\u7ed1\u5b9a\u6570\u636e";
                this.mcTaskMsgReceiveService.updateByList(isAgain, thirdNullList, 2, errMsg);
            }
        }
        if (CollectionUtil.isNotEmpty(receiveBlacklist)) {
            this.mcTaskMsgReceiveService.updateBlacklist(receiveBlacklist);
        }
    }

    public WxCpLinkedCorpMessageSendResult postLinkedCorpMessageSend(McTaskMsgContentEntity taskMsgContent, String corpId, Integer agentId, Boolean isToAll, String[] toUsers) throws WxErrorException {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || StringUtils.isEmpty((String)corpId)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u6267\u884c \u4e92\u8054\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u6d88\u606fpost\u4e0b\u53d1\uff0c\u4f46message info \u6216 corpId\u4f01\u4e1aid \u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        WxCpService corpService = this.wxCpConfiguration.getCpService(corpId, agentId);
        String contentType = taskMsgContent.getContentType();
        String title = taskMsgContent.getTitle();
        String content = taskMsgContent.getContent();
        String linkUrl = taskMsgContent.getLinkUrl();
        if (ContentTypeEnum.TEXT_MSG.getCode().equals(contentType)) {
            WxCpLinkedCorpMessage message = WxCpLinkedCorpMessage.builder().msgType("text").toUsers(toUsers).isToAll(isToAll).isSafe(Boolean.valueOf(false)).content(content).build();
            return corpService.getMessageService().sendLinkedCorpMessage(message);
        }
        if (ContentTypeEnum.LINK_MSG.getCode().equals(contentType)) {
            WxCpLinkedCorpMessage message = WxCpLinkedCorpMessage.builder().msgType("textcard").toUsers(toUsers).isToAll(isToAll).title(title).description(content).url(linkUrl).build();
            return corpService.getMessageService().sendLinkedCorpMessage(message);
        }
        if (ContentTypeEnum.IMG_TEXT_MSG.getCode().equals(contentType)) {
            WxCpLinkedCorpMessage message = WxCpLinkedCorpMessage.builder().msgType("news").toUsers(toUsers).isToAll(isToAll).articles((List)Lists.newArrayList((Object[])new NewArticle[]{NewArticle.builder().title(title).description(content).url(linkUrl).picUrl(taskMsgContent.getPicUrl()).build()})).build();
            return corpService.getMessageService().sendLinkedCorpMessage(message);
        }
        return null;
    }

    public void wxCpLinkedCorpSendMessageResult(boolean isAgain, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveList, List<SynThirdInfoEntity> thirdInfoList, WxCpLinkedCorpMessageSendResult result) {
        String[] invalidUser;
        if (CollectionUtil.isNotEmpty(receiveList)) {
            String errMsg = isAgain ? "\u91cd\u53d1\u6210\u529f\uff1a" : "\u4e0b\u53d1\u6210\u529f\uff1a";
            this.mcTaskMsgReceiveService.updateByList(isAgain, receiveList, 1, errMsg);
        }
        if (ObjectUtil.isNotEmpty((Object)result) && ObjectUtil.isNotEmpty((Object)(invalidUser = result.getInvalidUser())) && invalidUser.length != 0) {
            List<String> invalidUserList = Arrays.asList(invalidUser);
            List invalidThirdList = thirdInfoList.stream().filter(r -> invalidUserList.contains(r.getThirdObjectId())).collect(Collectors.toList());
            List<McTaskMsgReceiveEntity> list = receiveList.stream().filter(r -> invalidThirdList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(list)) {
                String errMsg = isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a";
                errMsg = ErrCodeEnum.SEND_EXCEPTION.getCode() == result.getErrcode().intValue() ? errMsg + errMsg + result.getErrmsg() : errMsg + errMsg + "\u4e0d\u5408\u6cd5\u7684userid";
                this.mcTaskMsgReceiveService.updateByList(isAgain, list, 2, errMsg);
            }
        }
    }
}

