/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.service;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.OnlineUserModel;
import com.bringspring.common.model.OnlineUserProvider;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.msgCenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgCenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgCenter.model.mcMsgSendTemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgCenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgCenter.service.MsgToDingService;
import com.bringspring.system.msgCenter.service.MsgToEmailService;
import com.bringspring.system.msgCenter.service.MsgToSmsService;
import com.bringspring.system.msgCenter.service.MsgToWebhookService;
import com.bringspring.system.msgCenter.service.MsgToWxCpService;
import com.bringspring.system.msgCenter.service.MsgToWxMiniappService;
import com.bringspring.system.msgCenter.service.MsgToWxMpService;
import com.bringspring.system.msgCenter.util.BlacklistUtil;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SendMessageService {
    private static final Logger log = LoggerFactory.getLogger(SendMessageService.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private WxCpConfiguration wxCpConfiguration;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;
    @Autowired
    private MsgToWxCpService msgToWxCpService;
    @Autowired
    private MsgToWxMiniappService msgToWxMiniappService;
    @Autowired
    private MsgToEmailService msgToEmailService;
    @Autowired
    private MsgToSmsService msgToSmsService;
    @Autowired
    private MsgToDingService msgToDingService;
    @Autowired
    private MsgToWebhookService msgToWebhookService;
    @Autowired
    private MsgToWxMpService msgToWxMpService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageByChannel(boolean isAgain, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveList) {
        String channelType = sendTemplate.getMessageType();
        if (CollectionUtil.isNotEmpty(receiveList)) {
            List subReceives = ListUtils.partition(receiveList, (int)1000);
            ChannelTypeEnum typeEnum = ChannelTypeEnum.getByCode(channelType);
            switch (typeEnum) {
                case SYS_MSG: {
                    List<McTaskMsgReceiveEntity> receiveBlacklist = BlacklistUtil.receiveListFilter(receiveList);
                    if (CollectionUtil.isNotEmpty(receiveBlacklist)) {
                        this.mcTaskMsgReceiveService.updateBlacklist(receiveBlacklist);
                    }
                    if (!CollectionUtil.isNotEmpty(receiveList)) break;
                    UserInfo userInfo = this.userProvider.get();
                    receiveList.stream().forEach(s -> {
                        s.setEnabledMark(1);
                        s.setSendTime(new Date());
                        s.setSendUserId(userInfo.getUserId());
                        s.setDescription("");
                    });
                    this.mcTaskMsgReceiveService.updateBatchById(receiveList);
                    List toUserIds = receiveList.stream().map(i -> i.getSysUserId()).collect(Collectors.toList());
                    for (int i2 = 0; i2 < toUserIds.size(); ++i2) {
                        CopyOnWriteArraySet onlineUserList = OnlineUserProvider.getOnlineUserList();
                        for (OnlineUserModel item : onlineUserList) {
                            if (!((String)toUserIds.get(i2)).equals(item.getUserId()) || !userInfo.getTenantId().equals(item.getTenantId())) continue;
                            JSONObject map = new JSONObject();
                            map.put("method", (Object)"messagePush");
                            map.put("unreadNoticeCount", (Object)1);
                            map.put("messageType", (Object)2);
                            map.put("userId", (Object)userInfo.getTenantId());
                            map.put("toUserId", toUserIds);
                            map.put("title", (Object)taskMsgContent.getTitle());
                            JSONObject jSONObject = map;
                            synchronized (jSONObject) {
                                item.getWebSocket().getAsyncRemote().sendText(map.toJSONString());
                            }
                        }
                    }
                    break;
                }
                case MAIL_MSG: {
                    this.msgToEmailService.sendEmail(isAgain, sendTemplate, taskMsgContent, receiveList);
                    break;
                }
                case SMS_MSG: {
                    for (List subReceive : subReceives) {
                        this.msgToSmsService.sendSms(isAgain, sendTemplate, taskMsgContent, subReceive);
                    }
                    break;
                }
                case DING_MSG: {
                    for (List subReceive : subReceives) {
                        List dingReceives = ListUtils.partition((List)subReceive, (int)100);
                        for (List dingReceive : dingReceives) {
                            this.msgToDingService.sendMessage(isAgain, taskMsgContent, dingReceive);
                        }
                    }
                    break;
                }
                case QY_MSG: {
                    Boolean isLinkedCorp = this.wxCpConfiguration.getIsLinkedCorp();
                    for (List subReceive : subReceives) {
                        if (isLinkedCorp.booleanValue()) {
                            this.msgToWxCpService.sendLinkedCorpMessage(isAgain, taskMsgContent, subReceive);
                            continue;
                        }
                        this.msgToWxCpService.sendMessage(isAgain, taskMsgContent, subReceive);
                    }
                    break;
                }
                case WX_MINIAPP: {
                    this.msgToWxMiniappService.sendMessage(isAgain, sendTemplate, taskMsgContent, receiveList);
                    break;
                }
                case WX_MP: {
                    this.msgToWxMpService.sendMessage(isAgain, sendTemplate, taskMsgContent, receiveList);
                    break;
                }
                case WEBHOOK: {
                    this.msgToWebhookService.sendWebhook(isAgain, taskMsgContent, receiveList);
                    break;
                }
            }
        }
    }
}

