/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.msgCenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgCenter.entity.McMsgSendTemplateEntity;
import com.bringspring.system.msgCenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgCenter.mapper.McMsgSendTemplateMapper;
import com.bringspring.system.msgCenter.model.mcMsgSendTemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgCenter.service.McMsgAccountService;
import com.bringspring.system.msgCenter.service.McMsgSendTemplateService;
import com.bringspring.system.msgCenter.service.McMsgTemplateService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class McMsgSendTemplateServiceImpl
extends ServiceImpl<McMsgSendTemplateMapper, McMsgSendTemplateEntity>
implements McMsgSendTemplateService {
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;

    @Override
    public boolean checkTemplateUnique(List<McMsgSendTemplateModel> templateList) {
        List<String> uniqueList = templateList.stream().collect(Collectors.groupingBy(t -> t.getTemplateId() + t.getAccountConfigId(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        uniqueList.forEach(p -> System.out.println((String)p));
        return !CollectionUtil.isNotEmpty(uniqueList);
    }

    @Override
    public McMsgSendTemplateModel getModel(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMsgSendTemplateEntity::getId, (Object)id);
        queryWrapper.last("limit 1");
        McMsgSendTemplateEntity one = (McMsgSendTemplateEntity)this.getOne((Wrapper)queryWrapper);
        McMsgSendTemplateModel model = (McMsgSendTemplateModel)JsonUtil.getJsonToBean((Object)one, McMsgSendTemplateModel.class);
        if (ObjectUtil.isNotNull((Object)model)) {
            McMsgTemplateEntity templateInfo = this.mcMsgTemplateService.getInfo(model.getTemplateId());
            model.setTemplateName(templateInfo != null ? templateInfo.getFullName() : null);
            model.setTemplateEnCode(templateInfo != null ? templateInfo.getEnCode() : null);
            McMsgAccountEntity accountInfo = this.mcMsgAccountService.getInfo(model.getAccountConfigId());
            model.setAccountName(accountInfo != null ? accountInfo.getFullName() : null);
            model.setAccountEnCode(accountInfo != null ? accountInfo.getEnCode() : null);
        }
        return model;
    }

    @Override
    public long getCountByTemplateId(String templateId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(McMsgSendTemplateEntity::getTemplateId, (Object)templateId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public long getCountByAccountConfigId(String accountConfigId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(McMsgSendTemplateEntity::getAccountConfigId, (Object)accountConfigId);
        return this.count((Wrapper)queryWrapper);
    }
}

