/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgCenter.constant.CommonConsts;
import com.bringspring.system.msgCenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgCenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgCenter.mapper.McTaskMsgReceiveMapper;
import com.bringspring.system.msgCenter.model.mcMsgSend.McMsgSendInfoVO;
import com.bringspring.system.msgCenter.model.mcMsgSendTemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgCenter.model.mcTaskMsg.McTaskMsgPagination;
import com.bringspring.system.msgCenter.model.mcTaskMsgContent.McTaskMsgContentListQuery;
import com.bringspring.system.msgCenter.model.mcTaskMsgReceive.McTaskMsgReceiveCrForm;
import com.bringspring.system.msgCenter.model.mcTaskMsgReceive.McTaskMsgReceiveListQuery;
import com.bringspring.system.msgCenter.model.mcTaskMsgReceive.McTaskMsgReceivePagination;
import com.bringspring.system.msgCenter.model.mcTaskMsgReceive.McTaskMsgReceiveUpForm;
import com.bringspring.system.msgCenter.service.McMsgSendService;
import com.bringspring.system.msgCenter.service.McTaskMsgContentService;
import com.bringspring.system.msgCenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgCenter.service.McTaskMsgService;
import com.bringspring.system.msgCenter.service.SendMessageService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class McTaskMsgReceiveServiceImpl
extends ServiceImpl<McTaskMsgReceiveMapper, McTaskMsgReceiveEntity>
implements McTaskMsgReceiveService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SendMessageService sendMessageService;
    @Autowired
    private McMsgSendService mcMsgSendService;
    @Autowired
    private McTaskMsgContentService mcTaskMsgContentService;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;
    @Autowired
    private McTaskMsgService mcTaskMsgService;
    @Autowired
    private McTaskMsgReceiveMapper mcTaskMsgReceiveMapper;
    @Autowired
    private Executor threadPoolExecutor;

    @Override
    public List<McTaskMsgReceiveEntity> getList(McTaskMsgReceivePagination pagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int mcTaskMsgReceiveNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getMsgId())) {
            ++mcTaskMsgReceiveNum;
            queryWrapper.lambda().like(McTaskMsgReceiveEntity::getMsgId, (Object)pagination.getMsgId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getTemplateId())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getTemplateId, (Object)pagination.getTemplateId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            StringBuffer sql = new StringBuffer("SELECT id FROM mc_task_msg ");
            sql.append("WHERE id LIKE '%" + pagination.getKeyword() + "%' ");
            sql.append("OR task_code LIKE '%" + pagination.getKeyword() + "%' ");
            sql.append("OR send_code LIKE '%" + pagination.getKeyword() + "%' ");
            sql.append("OR business_key LIKE '%" + pagination.getKeyword() + "%' ");
            queryWrapper.lambda().inSql(McTaskMsgReceiveEntity::getMsgId, sql.toString());
        }
        if (StringUtils.isNotEmpty((String)pagination.getContentId())) {
            ++mcTaskMsgReceiveNum;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getContentId, (Object)pagination.getContentId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getChannelType())) {
            ++mcTaskMsgReceiveNum;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getChannelType, (Object)pagination.getChannelType());
        }
        if (StringUtils.isNotEmpty((String)pagination.getSysUserId())) {
            ++mcTaskMsgReceiveNum;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getSysUserId, (Object)pagination.getSysUserId());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getSysUserIds()) && pagination.getSysUserIds().length > 0) {
            ++mcTaskMsgReceiveNum;
            queryWrapper.lambda().in(McTaskMsgReceiveEntity::getSysUserId, (Object[])pagination.getSysUserIds());
        }
        if (StringUtils.isNotEmpty((String)pagination.getReceiveUserId())) {
            ++mcTaskMsgReceiveNum;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getReceiveUserId, (Object)pagination.getReceiveUserId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getIsRead())) {
            ++mcTaskMsgReceiveNum;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getIsRead, (Object)pagination.getIsRead());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnabledMark())) {
            ++mcTaskMsgReceiveNum;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getEnabledMark, (Object)pagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)pagination.getDeleteMark())) {
            ++mcTaskMsgReceiveNum;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getDeleteMark, (Object)pagination.getDeleteMark());
        }
        if (StringUtils.isNotEmpty(pagination.getSendTime())) {
            ++mcTaskMsgReceiveNum;
            List<String> SendTimeList = pagination.getSendTime();
            Long fir = Long.valueOf(SendTimeList.get(0));
            Long sec = Long.valueOf(SendTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(McTaskMsgReceiveEntity::getSendTime, (Object)new Date(fir))).le(McTaskMsgReceiveEntity::getSendTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McTaskMsgReceiveEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McTaskMsgReceiveEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McTaskMsgReceiveEntity mcTaskMsgReceiveEntity = new McTaskMsgReceiveEntity();
                Field declaredField = mcTaskMsgReceiveEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return pagination.setData(list, list.size());
    }

    @Override
    public List<McTaskMsgReceiveEntity> getList(McTaskMsgReceiveListQuery listQuery) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)listQuery.getMsgId())) {
            queryWrapper.lambda().like(McTaskMsgReceiveEntity::getMsgId, (Object)listQuery.getMsgId());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getChannelType())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getChannelType, (Object)listQuery.getChannelType());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getTemplateId())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getTemplateId, (Object)listQuery.getTemplateId());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getMsgTemplateId())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getMsgTemplateId, (Object)listQuery.getMsgTemplateId());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getMsgAccountId())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getMsgAccountId, (Object)listQuery.getMsgAccountId());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getReceiveUserId())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getReceiveUserId, (Object)listQuery.getReceiveUserId());
        }
        if (CollectionUtil.isNotEmpty(listQuery.getReceiveUserIds())) {
            queryWrapper.lambda().in(McTaskMsgReceiveEntity::getReceiveUserId, listQuery.getReceiveUserIds());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getEnabledMark())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getEnabledMark, (Object)listQuery.getEnabledMark());
        }
        if (CollectionUtil.isNotEmpty(listQuery.getEnabledMarks())) {
            queryWrapper.lambda().in(McTaskMsgReceiveEntity::getEnabledMark, listQuery.getEnabledMarks());
        }
        if (CollectionUtil.isNotEmpty(listQuery.getIds())) {
            queryWrapper.lambda().in(McTaskMsgReceiveEntity::getId, listQuery.getIds());
        }
        queryWrapper.lambda().orderByAsc(McTaskMsgReceiveEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<McTaskMsgReceiveEntity> getTypeList(McTaskMsgReceivePagination pagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int mcTaskMsgReceiveNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getMsgId())) {
            ++mcTaskMsgReceiveNum;
            queryWrapper.lambda().like(McTaskMsgReceiveEntity::getMsgId, (Object)pagination.getMsgId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getContentId())) {
            ++mcTaskMsgReceiveNum;
            queryWrapper.lambda().like(McTaskMsgReceiveEntity::getContentId, (Object)pagination.getContentId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getChannelType())) {
            ++mcTaskMsgReceiveNum;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getChannelType, (Object)pagination.getChannelType());
        }
        if (StringUtils.isNotEmpty((String)pagination.getSysUserId())) {
            ++mcTaskMsgReceiveNum;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getSysUserId, (Object)pagination.getSysUserId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnabledMark())) {
            ++mcTaskMsgReceiveNum;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getEnabledMark, (Object)pagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty(pagination.getSendTime())) {
            ++mcTaskMsgReceiveNum;
            List<String> SendTimeList = pagination.getSendTime();
            Long fir = Long.valueOf(SendTimeList.get(0));
            Long sec = Long.valueOf(SendTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(McTaskMsgReceiveEntity::getSendTime, (Object)new Date(fir))).le(McTaskMsgReceiveEntity::getSendTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McTaskMsgReceiveEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McTaskMsgReceiveEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McTaskMsgReceiveEntity mcTaskMsgReceiveEntity = new McTaskMsgReceiveEntity();
                Field declaredField = mcTaskMsgReceiveEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return pagination.setData(list, list.size());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public McTaskMsgReceiveEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getId, (Object)id);
        return (McTaskMsgReceiveEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(McTaskMsgReceiveCrForm mcTaskMsgReceiveCrForm) {
        String mainId = RandomUtil.uuId();
        McTaskMsgReceiveEntity entity = (McTaskMsgReceiveEntity)JsonUtil.getJsonToBean((Object)mcTaskMsgReceiveCrForm, McTaskMsgReceiveEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public boolean update(String id, McTaskMsgReceiveUpForm mcTaskMsgReceiveUpForm) {
        McTaskMsgReceiveEntity entity = (McTaskMsgReceiveEntity)JsonUtil.getJsonToBean((Object)mcTaskMsgReceiveUpForm, McTaskMsgReceiveEntity.class);
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(Integer deleteMark, String[] ids) {
        String userId = this.userProvider.get().getUserId();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().in(McTaskMsgReceiveEntity::getId, (Object[])ids);
        updateWrapper.lambda().set(McTaskMsgReceiveEntity::getDeleteMark, (Object)deleteMark);
        updateWrapper.lambda().set(McTaskMsgReceiveEntity::getDeleteTime, (Object)new Date());
        updateWrapper.lambda().set(McTaskMsgReceiveEntity::getDeleteUserId, (Object)userId);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_UNCOMMITTED)
    public void postSendReceive(McTaskMsgEntity taskMsg, List<McMsgSendTemplateModel> sendTemplateList, Integer enabledMark) {
        if (ObjectUtil.isEmpty((Object)taskMsg) || CollectionUtil.isEmpty(sendTemplateList)) {
            return;
        }
        String taskMsgId = taskMsg.getId();
        McTaskMsgContentListQuery contentListQuery = new McTaskMsgContentListQuery();
        contentListQuery.setMsgId(taskMsgId);
        McTaskMsgReceiveListQuery receiveListQuery = new McTaskMsgReceiveListQuery();
        receiveListQuery.setMsgId(taskMsgId);
        if (ObjectUtil.isNotEmpty((Object)enabledMark)) {
            receiveListQuery.setEnabledMark(enabledMark.toString());
        }
        for (McMsgSendTemplateModel sendTemplate : sendTemplateList) {
            String templateId = sendTemplate.getId();
            String channelType = sendTemplate.getMessageType();
            String msgTemplateId = sendTemplate.getTemplateId();
            String msgAccountId = sendTemplate.getAccountConfigId();
            contentListQuery.setChannelType(channelType);
            contentListQuery.setMsgTemplateId(msgTemplateId);
            contentListQuery.setMsgAccountId(msgAccountId);
            contentListQuery.setTemplateId(templateId);
            List<McTaskMsgContentEntity> contentList = this.mcTaskMsgContentService.getList(contentListQuery);
            McTaskMsgContentEntity taskMsgContent = contentList.get(0);
            receiveListQuery.setChannelType(channelType);
            receiveListQuery.setMsgTemplateId(msgTemplateId);
            receiveListQuery.setMsgAccountId(msgAccountId);
            receiveListQuery.setTemplateId(templateId);
            List<McTaskMsgReceiveEntity> list = this.mcTaskMsgReceiveService.getList(receiveListQuery);
            if (!CollectionUtil.isNotEmpty(list)) continue;
            this.sendMessageService.sendMessageByChannel(false, sendTemplate, taskMsgContent, list);
        }
    }

    @Override
    @DSTransactional
    public void againSendMessage(McTaskMsgEntity taskMsgInfo, List<McTaskMsgReceiveEntity> receiveList) {
        if (ObjectUtil.isNull((Object)taskMsgInfo) || CollectionUtil.isEmpty(receiveList)) {
            return;
        }
        String sendCode = taskMsgInfo.getSendCode();
        McMsgSendInfoVO sendInfoVO = this.mcMsgSendService.getInfoByEnCode(sendCode);
        List<McMsgSendTemplateModel> sendTemplateList = sendInfoVO.getSendTemplateList();
        if (CollectionUtil.isNotEmpty(sendTemplateList)) {
            String taskMsgId = taskMsgInfo.getId();
            McTaskMsgContentListQuery contentListQuery = new McTaskMsgContentListQuery();
            contentListQuery.setMsgId(taskMsgId);
            for (McMsgSendTemplateModel sendTemplate : sendTemplateList) {
                contentListQuery.setTemplateId(sendTemplate.getId());
                contentListQuery.setChannelType(sendTemplate.getMessageType());
                McTaskMsgContentEntity taskMsgContent = this.mcTaskMsgContentService.getList(contentListQuery).get(0);
                List<McTaskMsgReceiveEntity> list = receiveList.stream().filter(t -> t.getTemplateId().equals(sendTemplate.getId()) && t.getChannelType().equals(sendTemplate.getMessageType())).collect(Collectors.toList());
                if (!CollectionUtil.isNotEmpty(list)) continue;
                this.sendMessageService.sendMessageByChannel(true, sendTemplate, taskMsgContent, list);
            }
        }
    }

    @Override
    public void autoAgainSendMessage() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().ne(McTaskMsgReceiveEntity::getChannelType, (Object)ChannelTypeEnum.SYS_MSG.getCode());
        queryWrapper.lambda().ne(McTaskMsgReceiveEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().lt(McTaskMsgReceiveEntity::getAutoAgainNum, (Object)1000);
        queryWrapper.lambda().apply("auto_again_num < auto_again_max_num", new Object[0]);
        queryWrapper.lambda().orderByAsc(McTaskMsgReceiveEntity::getCreatorTime);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            this.threadPoolExecutor.execute(() -> {
                Map<String, List<McTaskMsgReceiveEntity>> taskMsgMap = list.stream().collect(Collectors.groupingBy(McTaskMsgReceiveEntity::getMsgId));
                try {
                    if (CollectionUtil.isNotEmpty(taskMsgMap)) {
                        for (String key : taskMsgMap.keySet()) {
                            McTaskMsgEntity taskMsgInfo = this.mcTaskMsgService.getInfo(key);
                            if (!ObjectUtil.isNotEmpty((Object)taskMsgInfo)) continue;
                            this.againSendMessage(taskMsgInfo, taskMsgMap.get(key));
                        }
                    }
                }
                catch (Exception e) {
                    this.log.error("\u6d88\u606f\u4e2d\u5fc3-\u6839\u636etask_msg_receive\u6570\u636e\uff0c\u6e20\u9053\u6d88\u606f\u4e0b\u53d1\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
    }

    @Override
    public void updateByList(boolean isAgain, List<McTaskMsgReceiveEntity> list, Integer enabledMark, String remark) {
        if (!isAgain) {
            list.stream().forEach(s -> {
                s.setEnabledMark(enabledMark);
                s.setSendTime(new Date());
                s.setSendUserId(this.userProvider.get().getUserId());
                s.setDescription(remark);
                s.setAutoAgainNum(0);
            });
        } else {
            list.stream().forEach(s -> {
                s.setEnabledMark(enabledMark);
                s.setAgainTime(new Date());
                s.setAgainUserId(this.userProvider.get().getUserId());
                s.setDescription(remark);
                if (ObjectUtil.isEmpty((Object)s.getAutoAgainNum())) {
                    s.setAutoAgainNum(0);
                } else {
                    s.setAutoAgainNum(s.getAutoAgainNum() + 1);
                }
            });
        }
        this.updateBatchById(list);
    }

    @Override
    public void updateBlacklist(List<McTaskMsgReceiveEntity> receiveBlacklist) {
        receiveBlacklist.stream().forEach(s -> {
            s.setDescription("\u672a\u53d1\u9001\uff1a\u9ed1\u540d\u5355\u6210\u5458");
            s.setDeleteMark(1);
            s.setEnabledMark(2);
            s.setSendTime(new Date());
            s.setSendUserId(this.userProvider.get().getUserId());
        });
        this.updateBatchById(receiveBlacklist);
    }

    @Override
    public void isRead(String isAll, String[] ids) {
        String[] split;
        String userId = this.userProvider.get().getUserId();
        boolean isAllRead = false;
        String channelType = ChannelTypeEnum.SYS_MSG.getCode();
        if (StringUtils.isNotEmpty((String)isAll) && ObjectUtil.isNotEmpty((Object)(split = isAll.split("-")))) {
            if ("1".equals(split[0])) {
                isAllRead = true;
            }
            if (split.length > 1) {
                channelType = split[1];
            }
        }
        if (isAllRead) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().eq(McTaskMsgReceiveEntity::getSysUserId, (Object)userId);
            updateWrapper.lambda().eq(McTaskMsgReceiveEntity::getChannelType, (Object)channelType);
            updateWrapper.lambda().ne(McTaskMsgReceiveEntity::getIsRead, (Object)CommonConsts.IS_READ);
            updateWrapper.lambda().set(McTaskMsgReceiveEntity::getIsRead, (Object)CommonConsts.IS_READ);
            updateWrapper.lambda().set(McTaskMsgReceiveEntity::getReadTime, (Object)new Date());
            updateWrapper.lambda().set(McTaskMsgReceiveEntity::getReadCount, (Object)1);
            this.update((Wrapper)updateWrapper);
        } else if (ObjectUtil.isNotEmpty((Object)ids) && ids.length > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(McTaskMsgReceiveEntity::getId, (Object[])ids);
            List list = this.list((Wrapper)queryWrapper);
            list.stream().forEach(item -> {
                item.setIsRead(CommonConsts.IS_READ);
                if (ObjectUtil.isNotEmpty((Object)item.getReadCount()) && item.getReadCount() > 0) {
                    item.setReadCount(item.getReadCount() + 1);
                } else {
                    item.setReadTime(new Date());
                    item.setReadCount(1);
                }
            });
            this.updateBatchById(list);
        }
    }

    @Override
    public List<Map<String, Object>> isReadCount() {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.select(new String[]{"is_read, count(1) AS total"}).eq((Object)"receive_user_id", (Object)userInfo.getUserId())).groupBy((Object)"is_read");
        return ((McTaskMsgReceiveMapper)this.baseMapper).selectMaps((Wrapper)queryWrapper);
    }

    @Override
    public void updateIsReadByMsgIdAndUserId(String msgId, String userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getMsgId, (Object)msgId);
        queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getReceiveUserId, (Object)userId);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            List<String> ids = list.stream().map(item -> item.getId()).collect(Collectors.toList());
            this.isRead("0", ids.toArray(new String[ids.size()]));
        }
    }

    @Override
    public List<Map<String, Object>> selectGroupByEnabledMark(McTaskMsgReceivePagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty(pagination.getSendTime())) {
            List<String> SendTimeList = pagination.getSendTime();
            Long fir = Long.valueOf(SendTimeList.get(0));
            Long sec = Long.valueOf(SendTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(McTaskMsgReceiveEntity::getSendTime, (Object)new Date(fir))).le(McTaskMsgReceiveEntity::getSendTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        return this.mcTaskMsgReceiveMapper.selectGroupByEnabledMark((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> selectDataPanel(McTaskMsgReceivePagination pagination) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        long sendTaskTotal = 0L;
        long sendTaskErr = 0L;
        McTaskMsgPagination mcTaskMsgPagination = new McTaskMsgPagination();
        mcTaskMsgPagination.setMenuId(pagination.getMenuId());
        mcTaskMsgPagination.setCreatorTime(pagination.getSendTime());
        List<Map<String, Object>> maps1 = this.mcTaskMsgService.selectGroupByEnabledMark(mcTaskMsgPagination);
        if (CollectionUtil.isNotEmpty(maps1)) {
            for (Map<String, Object> obj : maps1) {
                Object scount = obj.get("scount");
                sendTaskTotal += ((Long)scount).longValue();
                Object enabled_mark = obj.get("enabled_mark");
                if ("2".equals(String.valueOf(enabled_mark))) continue;
                sendTaskErr += ((Long)scount).longValue();
            }
        }
        data.put("sendTaskTotal", sendTaskTotal);
        data.put("sendTaskErr", sendTaskErr);
        long sendReceiveTotal = 0L;
        long sendReceiveErr = 0L;
        List<Map<String, Object>> maps = this.selectGroupByEnabledMark(pagination);
        if (CollectionUtil.isNotEmpty(maps)) {
            for (Map<String, Object> obj : maps) {
                Object scount = obj.get("scount");
                sendReceiveTotal += ((Long)scount).longValue();
                Object enabled_mark = obj.get("enabled_mark");
                if ("1".equals(String.valueOf(enabled_mark))) continue;
                sendReceiveErr += ((Long)scount).longValue();
            }
        }
        data.put("sendReceiveTotal", sendReceiveTotal);
        data.put("sendReceiveErr", sendReceiveErr);
        return data;
    }

    @Override
    public List<Map<String, Object>> selectGroupByChannelType(McTaskMsgReceivePagination pagination) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        Map<String, ChannelTypeEnum> allToMap = ChannelTypeEnum.getAllToMap();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty(pagination.getSendTime())) {
            List<String> SendTimeList = pagination.getSendTime();
            Long fir = Long.valueOf(SendTimeList.get(0));
            Long sec = Long.valueOf(SendTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(McTaskMsgReceiveEntity::getSendTime, (Object)new Date(fir))).le(McTaskMsgReceiveEntity::getSendTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        List<Map<String, Object>> maps = this.mcTaskMsgReceiveMapper.selectGroupByChannelType((Wrapper)queryWrapper);
        for (Map.Entry<String, ChannelTypeEnum> entry : allToMap.entrySet()) {
            System.out.println("Key = " + entry.getKey() + ", Value = " + (Object)((Object)entry.getValue()));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("code", entry.getValue().getCode());
            data.put("channel", entry.getValue().getChannel());
            Map channelType = maps.stream().filter(t -> ((String)entry.getKey()).equals(t.get("channel_type"))).findFirst().orElse(null);
            if (CollectionUtil.isNotEmpty((Map)channelType)) {
                data.put("scount", channelType.get("scount"));
            } else {
                data.put("scount", 0);
            }
            resultMap.add(data);
        }
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> selectGroupBySendTime(McTaskMsgReceivePagination pagination, int i) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        ArrayList<String> frontDate = new ArrayList<String>();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty(pagination.getSendTime())) {
            List<String> SendTimeList = pagination.getSendTime();
            Long fir = Long.valueOf(SendTimeList.get(0));
            Long sec = Long.valueOf(SendTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(McTaskMsgReceiveEntity::getSendTime, (Object)new Date(fir))).le(McTaskMsgReceiveEntity::getSendTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
            List allDays = DateUtil.getAllDays((Date)new Date(fir), (Date)new Date(sec));
            for (Date date : allDays) {
                frontDate.add(DateUtil.daFormat((Date)date));
            }
        }
        if (CollectionUtil.isEmpty(frontDate)) {
            if (ObjectUtil.isEmpty((Object)i) || i == 0) {
                i = 7;
            }
            frontDate.addAll(DateUtil.getFrontDate((Date)new Date(), (int)i));
        }
        String firstDate = (String)frontDate.get(i - 1);
        queryWrapper.lambda().gt(McTaskMsgReceiveEntity::getSendTime, (Object)firstDate);
        List<Map<String, Object>> maps = this.mcTaskMsgReceiveMapper.selectGroupBySendTime((Wrapper)queryWrapper);
        for (String dateStr : frontDate) {
            HashMap<String, Object> sendTime = maps.stream().filter(t -> t.get("send_time").equals(dateStr)).findFirst().orElse(null);
            if (CollectionUtil.isEmpty((Map)sendTime)) {
                sendTime = new HashMap<String, Object>();
                sendTime.put("send_time", dateStr);
                sendTime.put("scount", 0);
            }
            resultMap.add((Map<String, Object>)sendTime);
        }
        return resultMap;
    }
}

