/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgCenter.constant.CommonConsts;
import com.bringspring.system.msgCenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgCenter.entity.McMsgSendEntity;
import com.bringspring.system.msgCenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgCenter.entity.McMsgTemplateFieldEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgCenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgCenter.exception.MsgCenterException;
import com.bringspring.system.msgCenter.mapper.McTaskMsgMapper;
import com.bringspring.system.msgCenter.model.mcBusiness.McBusinessInfoVO;
import com.bringspring.system.msgCenter.model.mcMsgSend.McMsgSendInfoVO;
import com.bringspring.system.msgCenter.model.mcMsgSendTemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgCenter.model.mcTaskMsg.McTaskMsgCrForm;
import com.bringspring.system.msgCenter.model.mcTaskMsg.McTaskMsgPagination;
import com.bringspring.system.msgCenter.model.mcTaskMsg.McTaskMsgUpForm;
import com.bringspring.system.msgCenter.service.McBusinessService;
import com.bringspring.system.msgCenter.service.McMsgAccountService;
import com.bringspring.system.msgCenter.service.McMsgSendService;
import com.bringspring.system.msgCenter.service.McMsgTemplateService;
import com.bringspring.system.msgCenter.service.McTaskMsgContentService;
import com.bringspring.system.msgCenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgCenter.service.McTaskMsgService;
import com.bringspring.system.msgCenter.service.SendMessageService;
import com.bringspring.system.msgCenter.util.EmailUtil;
import com.bringspring.system.msgCenter.util.SensitiveWordUtil;
import com.bringspring.system.msgCenter.util.UrlUtils;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class McTaskMsgServiceImpl
extends ServiceImpl<McTaskMsgMapper, McTaskMsgEntity>
implements McTaskMsgService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private McMsgSendService mcMsgSendService;
    @Autowired
    private McBusinessService mcBusinessService;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private WxCpConfiguration wxCpConfiguration;
    @Autowired
    private McTaskMsgContentService mcTaskMsgContentService;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;
    @Autowired
    private SendMessageService sendMessageService;
    @Autowired
    private McTaskMsgMapper mcTaskMsgMapper;
    @Autowired
    private Executor threadPoolExecutor;

    @Override
    public List<McTaskMsgEntity> getList(McTaskMsgPagination pagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int mcTaskMsgNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(McTaskMsgEntity::getId, (Object)pagination.getKeyword())).or()).like(McTaskMsgEntity::getTaskCode, (Object)pagination.getKeyword())).or()).like(McTaskMsgEntity::getSendCode, (Object)pagination.getKeyword());
            });
            ++mcTaskMsgNum;
        }
        if (StringUtils.isNotEmpty((String)pagination.getTaskCode())) {
            ++mcTaskMsgNum;
            queryWrapper.lambda().like(McTaskMsgEntity::getTaskCode, (Object)pagination.getTaskCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getSendCode())) {
            ++mcTaskMsgNum;
            queryWrapper.lambda().like(McTaskMsgEntity::getSendCode, (Object)pagination.getSendCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnabledMark())) {
            ++mcTaskMsgNum;
            queryWrapper.lambda().eq(McTaskMsgEntity::getEnabledMark, (Object)Integer.parseInt(pagination.getEnabledMark()));
        }
        if (StringUtils.isNotEmpty((String)pagination.getToUserIds())) {
            ++mcTaskMsgNum;
            queryWrapper.lambda().like(McTaskMsgEntity::getToUserIds, (Object)pagination.getToUserIds());
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McTaskMsgEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McTaskMsgEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McTaskMsgEntity mcTaskMsgEntity = new McTaskMsgEntity();
                Field declaredField = mcTaskMsgEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return pagination.setData(list, list.size());
    }

    @Override
    public List<McTaskMsgEntity> getTypeList(McTaskMsgPagination pagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int mcTaskMsgNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getTaskCode())) {
            ++mcTaskMsgNum;
            queryWrapper.lambda().like(McTaskMsgEntity::getTaskCode, (Object)pagination.getTaskCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getSendCode())) {
            ++mcTaskMsgNum;
            queryWrapper.lambda().like(McTaskMsgEntity::getSendCode, (Object)pagination.getSendCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getToUserIds())) {
            ++mcTaskMsgNum;
            queryWrapper.lambda().like(McTaskMsgEntity::getToUserIds, (Object)pagination.getToUserIds());
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McTaskMsgEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McTaskMsgEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McTaskMsgEntity mcTaskMsgEntity = new McTaskMsgEntity();
                Field declaredField = mcTaskMsgEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return pagination.setData(list, list.size());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public McTaskMsgEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McTaskMsgEntity::getId, (Object)id);
        return (McTaskMsgEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(McTaskMsgCrForm mcTaskMsgCrForm) {
        String mainId = RandomUtil.uuId();
        McTaskMsgEntity entity = (McTaskMsgEntity)JsonUtil.getJsonToBean((Object)mcTaskMsgCrForm, McTaskMsgEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public boolean update(String id, McTaskMsgUpForm mcTaskMsgUpForm) {
        McTaskMsgEntity entity = (McTaskMsgEntity)JsonUtil.getJsonToBean((Object)mcTaskMsgUpForm, McTaskMsgEntity.class);
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(McTaskMsgEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void addAndSendMessage(McTaskMsgCrForm mcTaskMsgCrForm) throws Exception {
        McTaskMsgEntity entity = this.addTaskMsg(mcTaskMsgCrForm);
        this.sendTaskMsgReceive(entity);
    }

    @Override
    public McTaskMsgEntity addTaskMsg(McTaskMsgCrForm mcTaskMsgCrForm) throws MsgCenterException {
        if (ObjectUtil.isNotEmpty((Object)mcTaskMsgCrForm)) {
            String taskCode = mcTaskMsgCrForm.getTaskCode();
            if (StringUtils.isEmpty((String)taskCode)) {
                throw new MsgCenterException("taskCode\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String sendCode = mcTaskMsgCrForm.getSendCode();
            if (StringUtils.isEmpty((String)sendCode)) {
                throw new MsgCenterException("sendCode\u4e0d\u80fd\u4e3a\u7a7a");
            }
            McMsgSendEntity msgSendEntity = this.mcMsgSendService.getValidInfo(sendCode);
            if (ObjectUtil.isEmpty((Object)msgSendEntity)) {
                throw new MsgCenterException("sendCode\u4e0d\u5b58\u5728\u6216\u7981\u7528\uff0c\u8bf7\u786e\u5b9a\u53d1\u9001\u914d\u7f6e\u7f16\u7801");
            }
            if (StringUtils.isEmpty((String)mcTaskMsgCrForm.getBusinessKey())) {
                throw new MsgCenterException("\u4f7f\u7528\u6a21\u677f\uff0cbusinessKey\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!JsonUtil.isJSONString((String)mcTaskMsgCrForm.getBusinessKey())) {
                throw new MsgCenterException("parameterMap\u975ejson\u683c\u5f0f");
            }
            String toUserIds = mcTaskMsgCrForm.getToUserIds();
            String toDeptIds = mcTaskMsgCrForm.getToDeptIds();
            if (StringUtils.isEmpty((String)toUserIds) && StringUtils.isEmpty((String)toDeptIds)) {
                throw new MsgCenterException("\u65e0\u6548\u7684\u63a5\u6536\u4eba");
            }
            mcTaskMsgCrForm.setEnabledMark("1");
            McTaskMsgEntity entity = (McTaskMsgEntity)JsonUtil.getJsonToBean((Object)mcTaskMsgCrForm, McTaskMsgEntity.class);
            entity.setId(RandomUtil.uuId());
            this.save(entity);
            return entity;
        }
        throw new MsgCenterException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional
    public void sendTaskMsgReceive(McTaskMsgEntity entity) {
        String sendCode = entity.getSendCode();
        McMsgSendInfoVO sendInfoVO = this.mcMsgSendService.getInfoByEnCode(sendCode);
        List<McMsgSendTemplateModel> sendTemplateList = sendInfoVO.getSendTemplateList();
        if (CollectionUtil.isNotEmpty(sendTemplateList)) {
            this.saveContentAndReceive(entity, sendTemplateList);
            entity.setEnabledMark(2);
            this.updateById(entity);
            this.threadPoolExecutor.execute(() -> {
                try {
                    this.mcTaskMsgReceiveService.postSendReceive(entity, sendTemplateList, 0);
                }
                catch (Exception e) {
                    this.log.error("\u6d88\u606f\u4e2d\u5fc3-\u6839\u636etask_msg_receive\u6570\u636e\uff0c\u6e20\u9053\u6d88\u606f\u4e0b\u53d1\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        } else {
            entity.setDescription("\u53d1\u9001\u914d\u7f6e-\u672a\u914d\u7f6e\u6e20\u9053\u6d88\u606f\u6a21\u677f");
            this.updateById(entity);
        }
    }

    private void saveContentAndReceive(McTaskMsgEntity taskMsg, List<McMsgSendTemplateModel> sendTemplateList) {
        List<String> orgIds;
        List<UserEntity> userList;
        if (ObjectUtil.isEmpty((Object)taskMsg) || CollectionUtil.isEmpty(sendTemplateList)) {
            return;
        }
        String taskMsgId = taskMsg.getId();
        boolean allUsers = false;
        SetUtils.SetView userSet = new HashSet();
        String toUserIds = taskMsg.getToUserIds();
        if (StringUtils.isNotEmpty((String)toUserIds)) {
            if ("@ALL".equals(toUserIds)) {
                allUsers = true;
                List<String> listId = this.userService.getListId();
                userSet.addAll(listId);
            } else {
                String[] toUserArr = toUserIds.split(",");
                Collections.addAll(userSet, toUserArr);
            }
        }
        String toDeptIds = taskMsg.getToDeptIds();
        if (!allUsers && StringUtils.isNotEmpty((String)toDeptIds) && CollectionUtil.isNotEmpty(userList = this.userService.getUserByOrgIds(orgIds = Arrays.asList(toDeptIds.split(","))))) {
            Set deptUserSet = userList.stream().map(UserEntity::getId).collect(Collectors.toSet());
            userSet = SetUtils.union(userSet, deptUserSet);
        }
        List<UserEntity> receiveUsers = this.userService.getUserByIds(new ArrayList<String>((Collection<String>)userSet));
        HashMap<String, List<Object>> receiveMap = new HashMap<String, List<Object>>();
        HashMap<String, McTaskMsgContentEntity> contentMap = new HashMap<String, McTaskMsgContentEntity>();
        for (McMsgSendTemplateModel mcMsgSendTemplateModel : sendTemplateList) {
            String templateId = mcMsgSendTemplateModel.getId();
            String channelType = mcMsgSendTemplateModel.getMessageType();
            String msgTemplateId = mcMsgSendTemplateModel.getTemplateId();
            String msgAccountId = mcMsgSendTemplateModel.getAccountConfigId();
            McMsgAccountEntity account = this.mcMsgAccountService.getInfo(mcMsgSendTemplateModel.getAccountConfigId());
            McMsgTemplateEntity msgTemplate = this.mcMsgTemplateService.getInfo(mcMsgSendTemplateModel.getTemplateId());
            ChannelTypeEnum typeEnum = ChannelTypeEnum.getByCode(channelType);
            switch (typeEnum) {
                case SYS_MSG: {
                    McTaskMsgContentEntity sysContent;
                    String sysKey = channelType + msgTemplateId;
                    if (!contentMap.containsKey(sysKey)) {
                        sysContent = this.getTaskMsgContent(templateId, channelType, taskMsg, msgTemplate, account);
                        contentMap.put(sysKey, sysContent);
                    } else {
                        sysContent = (McTaskMsgContentEntity)contentMap.get(sysKey);
                    }
                    if (receiveMap.containsKey(sysKey)) break;
                    ArrayList sysReceiveList = new ArrayList();
                    receiveUsers.stream().forEach(s -> {
                        McTaskMsgReceiveEntity receiveEntity = new McTaskMsgReceiveEntity();
                        receiveEntity.setId(RandomUtil.uuId());
                        receiveEntity.setMsgId(taskMsgId);
                        receiveEntity.setTemplateId(templateId);
                        receiveEntity.setMsgTemplateId(msgTemplateId);
                        receiveEntity.setMsgAccountId(msgAccountId);
                        receiveEntity.setContentId(sysContent.getId());
                        receiveEntity.setChannelType(channelType);
                        receiveEntity.setReceiveUserId(s.getId());
                        receiveEntity.setSysUserId(s.getId());
                        receiveEntity.setEnabledMark(0);
                        receiveEntity.setIsRead(CommonConsts.NOT_READ);
                        receiveEntity.setDescription(null);
                        sysReceiveList.add(receiveEntity);
                    });
                    receiveMap.put(sysKey, sysReceiveList);
                    break;
                }
                case MAIL_MSG: {
                    McTaskMsgContentEntity mailContent;
                    String mailKey = channelType + msgTemplateId + msgAccountId;
                    if (!contentMap.containsKey(mailKey)) {
                        mailContent = this.getTaskMsgContent(templateId, channelType, taskMsg, msgTemplate, account);
                        contentMap.put(mailKey, mailContent);
                    } else {
                        mailContent = (McTaskMsgContentEntity)contentMap.get(mailKey);
                    }
                    if (receiveMap.containsKey(mailKey)) break;
                    ArrayList mailReceiveList = new ArrayList();
                    receiveUsers.stream().forEach(s -> {
                        McTaskMsgReceiveEntity receiveEntity = new McTaskMsgReceiveEntity();
                        receiveEntity.setId(RandomUtil.uuId());
                        receiveEntity.setMsgId(taskMsgId);
                        receiveEntity.setTemplateId(templateId);
                        receiveEntity.setMsgTemplateId(msgTemplateId);
                        receiveEntity.setMsgAccountId(msgAccountId);
                        receiveEntity.setContentId(mailContent.getId());
                        receiveEntity.setChannelType(channelType);
                        if (StringUtils.isNotEmpty((String)s.getEmail()) && EmailUtil.isEmail(s.getEmail())) {
                            receiveEntity.setReceiveUserId(s.getRealName() + "<" + s.getEmail() + ">");
                        }
                        receiveEntity.setSysUserId(s.getId());
                        receiveEntity.setEnabledMark(0);
                        receiveEntity.setIsRead(CommonConsts.NOT_READ);
                        receiveEntity.setDescription(null);
                        mailReceiveList.add(receiveEntity);
                    });
                    receiveMap.put(mailKey, mailReceiveList);
                    break;
                }
                case SMS_MSG: {
                    McTaskMsgContentEntity smsContent;
                    String smsKey = channelType + msgTemplateId + msgAccountId;
                    if (!contentMap.containsKey(smsKey)) {
                        smsContent = this.getTaskMsgContentKey(templateId, channelType, taskMsg, msgTemplate, account);
                        contentMap.put(smsKey, smsContent);
                    } else {
                        smsContent = (McTaskMsgContentEntity)contentMap.get(smsKey);
                    }
                    if (receiveMap.containsKey(smsKey)) break;
                    ArrayList smsReceiveList = new ArrayList();
                    receiveUsers.stream().forEach(s -> {
                        McTaskMsgReceiveEntity receiveEntity = new McTaskMsgReceiveEntity();
                        receiveEntity.setId(RandomUtil.uuId());
                        receiveEntity.setMsgId(taskMsgId);
                        receiveEntity.setTemplateId(templateId);
                        receiveEntity.setMsgTemplateId(msgTemplateId);
                        receiveEntity.setMsgAccountId(msgAccountId);
                        receiveEntity.setContentId(smsContent.getId());
                        receiveEntity.setChannelType(channelType);
                        receiveEntity.setReceiveUserId(s.getMobilePhone());
                        receiveEntity.setSysUserId(s.getId());
                        receiveEntity.setEnabledMark(0);
                        receiveEntity.setIsRead(CommonConsts.NOT_READ);
                        receiveEntity.setDescription(null);
                        smsReceiveList.add(receiveEntity);
                    });
                    receiveMap.put(smsKey, smsReceiveList);
                    break;
                }
                case DING_MSG: {
                    List<McTaskMsgReceiveEntity> ddReceiveList;
                    List<SynThirdInfoEntity> ddThirdList;
                    String ddCrop;
                    McTaskMsgContentEntity ddContent;
                    String dingContentKey = channelType + msgTemplateId + msgAccountId;
                    String dingReceiveKey = channelType + msgTemplateId;
                    if (!contentMap.containsKey(dingContentKey)) {
                        ddContent = this.getTaskMsgContent(templateId, channelType, taskMsg, msgTemplate, account);
                        contentMap.put(dingContentKey, ddContent);
                    } else {
                        ddContent = (McTaskMsgContentEntity)contentMap.get(dingContentKey);
                    }
                    String string = ddCrop = ObjectUtil.isEmpty((Object)account) ? null : account.getEnterpriseId();
                    if (receiveMap.containsKey(dingReceiveKey)) {
                        ddThirdList = this.synThirdInfoService.getThirdInfoList("2", "2", ddCrop, (Set<String>)userSet);
                        ddReceiveList = this.packThirdReceive(receiveUsers, ddThirdList, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, ddContent.getId(), (List)receiveMap.get(dingReceiveKey));
                        receiveMap.put(dingReceiveKey, ddReceiveList);
                        break;
                    }
                    ddThirdList = this.synThirdInfoService.getThirdInfoList("2", "2", ddCrop, (Set<String>)userSet);
                    ddReceiveList = this.packThirdReceive(receiveUsers, ddThirdList, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, ddContent.getId(), null);
                    receiveMap.put(dingReceiveKey, ddReceiveList);
                    break;
                }
                case QY_MSG: {
                    List<McTaskMsgReceiveEntity> qyReceiveList;
                    List<SynThirdInfoEntity> qyThirdList;
                    String qyCrop;
                    McTaskMsgContentEntity qyContent;
                    String qyContentKey = channelType + msgTemplateId + msgAccountId;
                    String qyReceiveKey = channelType + msgTemplateId;
                    if (!contentMap.containsKey(qyContentKey)) {
                        qyContent = this.getTaskMsgContent(templateId, channelType, taskMsg, msgTemplate, account);
                        contentMap.put(qyContentKey, qyContent);
                    } else {
                        qyContent = (McTaskMsgContentEntity)contentMap.get(qyContentKey);
                    }
                    String isLinkedCorp = ObjectUtil.isEmpty((Object)account) ? null : account.getProgramState();
                    String string = qyCrop = ObjectUtil.isEmpty((Object)account) ? null : account.getEnterpriseId();
                    if (receiveMap.containsKey(qyReceiveKey)) {
                        qyThirdList = this.synThirdInfoService.getThirdInfoList("1", "2", qyCrop, (Set<String>)userSet, Boolean.parseBoolean(isLinkedCorp));
                        qyReceiveList = this.packThirdReceive(receiveUsers, qyThirdList, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, qyContent.getId(), (List)receiveMap.get(qyReceiveKey));
                        receiveMap.put(qyReceiveKey, qyReceiveList);
                        break;
                    }
                    qyThirdList = this.synThirdInfoService.getThirdInfoList("1", "2", qyCrop, (Set<String>)userSet, Boolean.parseBoolean(isLinkedCorp));
                    qyReceiveList = this.packThirdReceive(receiveUsers, qyThirdList, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, qyContent.getId(), null);
                    receiveMap.put(qyReceiveKey, qyReceiveList);
                    break;
                }
                case WX_MINIAPP: {
                    List<McTaskMsgReceiveEntity> maReceiveList;
                    List<SynThirdInfoEntity> maThirdList;
                    String maCrop;
                    McTaskMsgContentEntity maContent;
                    String maContentKey = channelType + msgTemplateId + msgAccountId;
                    String maReceiveKey = channelType + msgTemplateId;
                    if (!contentMap.containsKey(maContentKey)) {
                        maContent = this.getTaskMsgContentKey(templateId, channelType, taskMsg, msgTemplate, account);
                        contentMap.put(maContentKey, maContent);
                    } else {
                        maContent = (McTaskMsgContentEntity)contentMap.get(maContentKey);
                    }
                    String string = maCrop = ObjectUtil.isEmpty((Object)account) ? null : account.getAppId();
                    if (receiveMap.containsKey(maReceiveKey)) {
                        maThirdList = this.synThirdInfoService.getThirdInfoList("3", "2", maCrop, (Set<String>)userSet);
                        maReceiveList = this.packThirdReceive(receiveUsers, maThirdList, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, maContent.getId(), (List)receiveMap.get(maReceiveKey));
                        receiveMap.put(maReceiveKey, maReceiveList);
                        break;
                    }
                    maThirdList = this.synThirdInfoService.getThirdInfoList("3", "2", maCrop, (Set<String>)userSet);
                    maReceiveList = this.packThirdReceive(receiveUsers, maThirdList, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, maContent.getId(), null);
                    receiveMap.put(maReceiveKey, maReceiveList);
                    break;
                }
                case WX_MP: {
                    List<McTaskMsgReceiveEntity> mpReceiveList;
                    List<SynThirdInfoEntity> mpThirdList;
                    String mpCrop;
                    McTaskMsgContentEntity mpContent;
                    String mpContentKey = channelType + msgTemplateId + msgAccountId;
                    String mpReceiveKey = channelType + msgTemplateId;
                    if (!contentMap.containsKey(mpContentKey)) {
                        mpContent = this.getTaskMsgContentKey(templateId, channelType, taskMsg, msgTemplate, account);
                        contentMap.put(mpContentKey, mpContent);
                    } else {
                        mpContent = (McTaskMsgContentEntity)contentMap.get(mpContentKey);
                    }
                    String string = mpCrop = ObjectUtil.isEmpty((Object)account) ? null : account.getAppId();
                    if (receiveMap.containsKey(mpReceiveKey)) {
                        mpThirdList = this.synThirdInfoService.getThirdInfoList("7", "2", mpCrop, (Set<String>)userSet);
                        mpReceiveList = this.packThirdReceive(receiveUsers, mpThirdList, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, mpContent.getId(), (List)receiveMap.get(mpReceiveKey));
                        receiveMap.put(mpReceiveKey, mpReceiveList);
                        break;
                    }
                    mpThirdList = this.synThirdInfoService.getThirdInfoList("7", "2", mpCrop, (Set<String>)userSet);
                    mpReceiveList = this.packThirdReceive(receiveUsers, mpThirdList, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, mpContent.getId(), null);
                    receiveMap.put(mpReceiveKey, mpReceiveList);
                    break;
                }
                case WEBHOOK: {
                    McTaskMsgContentEntity webhookContent;
                    String webhookKey = channelType + msgTemplateId + msgAccountId;
                    if (!contentMap.containsKey(webhookKey)) {
                        webhookContent = this.getTaskMsgContent(templateId, channelType, taskMsg, msgTemplate, account);
                        contentMap.put(webhookKey, webhookContent);
                    } else {
                        webhookContent = (McTaskMsgContentEntity)contentMap.get(webhookKey);
                    }
                    if (receiveMap.containsKey(webhookKey)) break;
                    McTaskMsgReceiveEntity webhookReceiveEntity = new McTaskMsgReceiveEntity();
                    webhookReceiveEntity.setId(RandomUtil.uuId());
                    webhookReceiveEntity.setMsgId(taskMsgId);
                    webhookReceiveEntity.setTemplateId(templateId);
                    webhookReceiveEntity.setMsgTemplateId(msgTemplateId);
                    webhookReceiveEntity.setMsgAccountId(msgAccountId);
                    webhookReceiveEntity.setContentId(webhookContent.getId());
                    webhookReceiveEntity.setChannelType(channelType);
                    webhookReceiveEntity.setReceiveUserId(mcMsgSendTemplateModel.getAccountConfigId());
                    webhookReceiveEntity.setSysUserId(null);
                    webhookReceiveEntity.setEnabledMark(0);
                    webhookReceiveEntity.setIsRead(CommonConsts.NOT_READ);
                    webhookReceiveEntity.setDescription(null);
                    receiveMap.put(webhookKey, new ArrayList<McTaskMsgReceiveEntity>(Arrays.asList(webhookReceiveEntity)));
                    break;
                }
            }
        }
        ArrayList<McTaskMsgContentEntity> contentEntityList = new ArrayList<McTaskMsgContentEntity>();
        for (Object value : contentMap.values()) {
            contentEntityList.add((McTaskMsgContentEntity)value);
        }
        ArrayList arrayList = new ArrayList();
        for (List value : receiveMap.values()) {
            arrayList.addAll(value);
        }
        Integer autoAgainMaxNum = ObjectUtil.isEmpty((Object)taskMsg.getAutoAgainMaxNum()) ? CommonConsts.AUTO_AGAIN_MAX_NUM : taskMsg.getAutoAgainMaxNum();
        arrayList.stream().forEach(item -> item.setAutoAgainMaxNum(autoAgainMaxNum));
        this.mcTaskMsgContentService.saveBatch(contentEntityList);
        this.mcTaskMsgReceiveService.saveBatch(arrayList);
    }

    private McTaskMsgContentEntity getTaskMsgContent(String templateId, String channelType, McTaskMsgEntity taskMsg, McMsgTemplateEntity msgTemplate, McMsgAccountEntity account) {
        String taskMsgId = taskMsg.getId();
        McBusinessInfoVO businessInfoVO = this.mcBusinessService.getInfoByEnCode(msgTemplate.getMessageSource());
        String businessKey = taskMsg.getBusinessKey();
        Map businessKeyMap = JsonUtil.stringToMap((String)businessKey);
        String title = msgTemplate.getTitle();
        String content = msgTemplate.getContent();
        String description = null;
        String linkUrl = null;
        String picUrl = null;
        if (StringUtils.isNotEmpty((Map)businessKeyMap)) {
            StringSubstitutor strSubstitutor;
            if (StringUtils.isNotEmpty((String)title)) {
                strSubstitutor = new StringSubstitutor(businessKeyMap, "{", "}");
                title = strSubstitutor.replace(title);
            } else {
                title = String.valueOf(businessKeyMap.get("title"));
            }
            if (StringUtils.isNotEmpty((String)content)) {
                strSubstitutor = new StringSubstitutor(businessKeyMap, "{", "}");
                content = strSubstitutor.replace(content);
            } else {
                content = String.valueOf(businessKeyMap.get("content"));
            }
            description = businessKeyMap.containsKey("desc") && StringUtils.isNotEmpty((String)businessKeyMap.get("desc").toString()) ? businessKeyMap.get("desc").toString() : (StringUtils.isEmpty((String)content) ? null : StringUtils.substring((String)content, (int)0, (int)200));
            linkUrl = this.packLinkUrl(channelType, businessKeyMap, account, taskMsgId);
            if (businessKeyMap.containsKey("picUrl") && ObjectUtil.isNotEmpty(businessKeyMap.get("picUrl"))) {
                picUrl = String.valueOf(businessKeyMap.get("picUrl"));
            }
        }
        McTaskMsgContentEntity taskMsgContentEntity = new McTaskMsgContentEntity();
        if (StringUtils.isNotEmpty((String)title)) {
            title = SensitiveWordUtil.sensitiveFilter(title, true);
            title = StringUtils.substring((String)title, (int)0, (int)50);
            taskMsgContentEntity.setTitle(title);
        }
        if (StringUtils.isNotEmpty((String)content)) {
            content = SensitiveWordUtil.sensitiveFilter(content, true);
            taskMsgContentEntity.setContent(content);
        }
        if (StringUtils.isNotEmpty(description)) {
            description = SensitiveWordUtil.sensitiveFilter(description, true);
            taskMsgContentEntity.setDescription(description);
        }
        taskMsgContentEntity.setLinkUrl(linkUrl);
        if (StringUtils.isNotEmpty(picUrl)) {
            taskMsgContentEntity.setPicUrl(picUrl);
        }
        taskMsgContentEntity.setId(RandomUtil.uuId());
        taskMsgContentEntity.setMsgId(taskMsgId);
        taskMsgContentEntity.setChannelType(channelType);
        taskMsgContentEntity.setTemplateId(templateId);
        taskMsgContentEntity.setMsgTemplateId(msgTemplate.getId());
        taskMsgContentEntity.setMsgAccountId(ObjectUtil.isEmpty((Object)account) ? null : account.getId());
        taskMsgContentEntity.setContentType(businessInfoVO.getCategory());
        return taskMsgContentEntity;
    }

    private McTaskMsgContentEntity getTaskMsgContentKey(String templateId, String channelType, McTaskMsgEntity taskMsg, McMsgTemplateEntity msgTemplate, McMsgAccountEntity account) {
        String taskMsgId = taskMsg.getId();
        McBusinessInfoVO businessInfoVO = this.mcBusinessService.getInfoByEnCode(msgTemplate.getMessageSource());
        String businessKey = taskMsg.getBusinessKey();
        Map businessKeyMap = JsonUtil.stringToMap((String)businessKey);
        McTaskMsgContentEntity taskMsgContentEntity = new McTaskMsgContentEntity();
        List<McMsgTemplateFieldEntity> fieldList = this.mcMsgTemplateService.getMcMsgTemplateFieldList(msgTemplate.getId());
        if (CollectionUtil.isNotEmpty(fieldList) && StringUtils.isNotEmpty((Map)businessKeyMap)) {
            HashMap fieldMap = new HashMap();
            for (McMsgTemplateFieldEntity field : fieldList) {
                fieldMap.put(field.getThirdField(), businessKeyMap.get(field.getKeywordCode()));
                if (Integer.valueOf(field.getIsTitle()) != 1) continue;
                taskMsgContentEntity.setTitle(businessKeyMap.get(field.getKeywordCode()).toString());
            }
            String content = JSONObject.toJSONString(fieldMap);
            if (StringUtils.isNotEmpty((String)content)) {
                content = SensitiveWordUtil.sensitiveFilter(content, true);
                taskMsgContentEntity.setContent(content);
            }
            taskMsgContentEntity.setLinkUrl(this.packLinkUrl(channelType, businessKeyMap, account, taskMsgId));
            if (businessKeyMap.containsKey("picUrl") && ObjectUtil.isNotEmpty(businessKeyMap.get("picUrl"))) {
                taskMsgContentEntity.setLinkUrl(String.valueOf(businessKeyMap.get("picUrl")));
            }
        }
        taskMsgContentEntity.setId(RandomUtil.uuId());
        taskMsgContentEntity.setMsgId(taskMsgId);
        taskMsgContentEntity.setChannelType(channelType);
        taskMsgContentEntity.setTemplateId(templateId);
        taskMsgContentEntity.setMsgTemplateId(msgTemplate.getId());
        taskMsgContentEntity.setMsgAccountId(ObjectUtil.isEmpty((Object)account) ? null : account.getId());
        taskMsgContentEntity.setContentType(businessInfoVO.getCategory());
        return taskMsgContentEntity;
    }

    private String packLinkUrl(String channelType, Map<String, Object> businessKeyMap, McMsgAccountEntity account, String taskMsgId) {
        ChannelTypeEnum typeEnum = ChannelTypeEnum.getByCode(channelType);
        Object linkUrl = null;
        switch (typeEnum) {
            case SYS_MSG: {
                if (businessKeyMap.containsKey("linkUrl")) {
                    linkUrl = businessKeyMap.get("linkUrl");
                }
            }
            case MAIL_MSG: {
                if (businessKeyMap.containsKey("linkUrl2")) {
                    linkUrl = businessKeyMap.get("linkUrl2");
                }
            }
            case SMS_MSG: {
                if (!businessKeyMap.containsKey("linkUrl3")) break;
                linkUrl = businessKeyMap.get("linkUrl3");
                break;
            }
            case DING_MSG: {
                if (!businessKeyMap.containsKey("linkUrl4")) break;
                linkUrl = businessKeyMap.get("linkUrl4");
                break;
            }
            case QY_MSG: {
                if (!businessKeyMap.containsKey("linkUrl5")) break;
                linkUrl = businessKeyMap.get("linkUrl5");
                break;
            }
            case WX_MINIAPP: {
                if (!businessKeyMap.containsKey("linkUrl6")) break;
                linkUrl = businessKeyMap.get("linkUrl6");
                break;
            }
            case WX_MP: {
                if (!businessKeyMap.containsKey("linkUrl7")) break;
                linkUrl = businessKeyMap.get("linkUrl7");
                break;
            }
            case WEBHOOK: {
                if (!businessKeyMap.containsKey("linkUrl8")) break;
                linkUrl = businessKeyMap.get("linkUrl8");
                break;
            }
        }
        if (ObjectUtil.isEmpty(linkUrl) && ObjectUtil.isNotEmpty((Object)account)) {
            linkUrl = account.getAddress();
        }
        if (ObjectUtil.isNotEmpty(linkUrl)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("msg_id", taskMsgId);
            return UrlUtils.addParameter(String.valueOf(linkUrl), map);
        }
        return null;
    }

    private List<McTaskMsgReceiveEntity> packThirdReceive(List<UserEntity> sysList, List<SynThirdInfoEntity> thirdList, String taskMsgId, String templateId, String channelType, String msgTemplateId, String msgAccountId, String contentId, List<McTaskMsgReceiveEntity> receiveList) {
        if (CollectionUtil.isEmpty(receiveList)) {
            ArrayList<McTaskMsgReceiveEntity> receiveEntities = new ArrayList<McTaskMsgReceiveEntity>();
            for (UserEntity user : sysList) {
                McTaskMsgReceiveEntity thirdReceive = new McTaskMsgReceiveEntity();
                thirdReceive.setMsgId(taskMsgId);
                thirdReceive.setTemplateId(templateId);
                thirdReceive.setMsgTemplateId(msgTemplateId);
                thirdReceive.setMsgAccountId(msgAccountId);
                thirdReceive.setContentId(contentId);
                thirdReceive.setChannelType(channelType);
                thirdReceive.setSysUserId(user.getId());
                thirdReceive.setIsRead(CommonConsts.NOT_READ);
                List tempList = thirdList.stream().filter(s -> user.getId().equals(s.getSystemObjectId())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(tempList)) {
                    tempList.stream().forEach(s -> {
                        McTaskMsgReceiveEntity thirdReceiveNew = new McTaskMsgReceiveEntity();
                        BeanUtils.copyProperties((Object)thirdReceive, (Object)thirdReceiveNew);
                        thirdReceiveNew.setReceiveUserId(s.getId());
                        thirdReceiveNew.setEnabledMark(0);
                        thirdReceiveNew.setDescription("\u521b\u5efa\uff0c\u8bbe\u7f6e\u4e0b\u53d1\u72b6\u6001\u4e3a\u2018\u5f85\u4e0b\u53d1\u2019");
                        thirdReceiveNew.setId(RandomUtil.uuId());
                        receiveEntities.add(thirdReceiveNew);
                    });
                    continue;
                }
                thirdReceive.setEnabledMark(0);
                thirdReceive.setDescription("\u521b\u5efa\uff0c\u8bbe\u7f6e\u4e0b\u53d1\u72b6\u6001\u4e3a\u2018\u5f85\u4e0b\u53d1\u2019");
                thirdReceive.setId(RandomUtil.uuId());
                receiveEntities.add(thirdReceive);
            }
            return receiveEntities;
        }
        for (SynThirdInfoEntity thirdInfo : thirdList) {
            List rTempList = receiveList.stream().filter(r -> thirdInfo.getSystemObjectId().equals(r.getSysUserId())).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(rTempList)) continue;
            McTaskMsgReceiveEntity mcTaskMsgReceiveEntity = (McTaskMsgReceiveEntity)rTempList.get(0);
            if (StringUtils.isEmpty((String)mcTaskMsgReceiveEntity.getReceiveUserId())) {
                mcTaskMsgReceiveEntity.setReceiveUserId(thirdInfo.getId());
                mcTaskMsgReceiveEntity.setTemplateId(templateId);
                mcTaskMsgReceiveEntity.setMsgTemplateId(msgTemplateId);
                mcTaskMsgReceiveEntity.setMsgAccountId(msgAccountId);
                mcTaskMsgReceiveEntity.setContentId(contentId);
                continue;
            }
            McTaskMsgReceiveEntity thirdReceiveNew = new McTaskMsgReceiveEntity();
            BeanUtils.copyProperties((Object)mcTaskMsgReceiveEntity, (Object)thirdReceiveNew);
            thirdReceiveNew.setId(RandomUtil.uuId());
            thirdReceiveNew.setReceiveUserId(thirdInfo.getId());
            thirdReceiveNew.setTemplateId(templateId);
            thirdReceiveNew.setMsgTemplateId(msgTemplateId);
            thirdReceiveNew.setMsgAccountId(msgAccountId);
            thirdReceiveNew.setContentId(contentId);
            receiveList.add(thirdReceiveNew);
        }
        return receiveList;
    }

    @Override
    public List<Map<String, Object>> selectGroupByEnabledMark(McTaskMsgPagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty(pagination.getCreatorTime())) {
            List<String> SendTimeList = pagination.getCreatorTime();
            Long fir = Long.valueOf(SendTimeList.get(0));
            Long sec = Long.valueOf(SendTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(McTaskMsgEntity::getCreatorTime, (Object)new Date(fir))).le(McTaskMsgEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        return this.mcTaskMsgMapper.selectGroupByEnabledMark((Wrapper)queryWrapper);
    }
}

