/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.util;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgCenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgCenter.enums.ContentTypeEnum;
import com.bringspring.system.msgCenter.model.message.DingSentResult;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingTalkUtil {
    private static final Logger log = LoggerFactory.getLogger(DingTalkUtil.class);
    public static final String SEND_MESSAGE = "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2";
    public static final String TOKEN = "https://oapi.dingtalk.com/gettoken";

    public static JSONObject getAccessToken(String appkey, String appsecret) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"");
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient(TOKEN);
            OapiGettokenRequest req = new OapiGettokenRequest();
            req.setAppkey(appkey);
            req.setAppsecret(appsecret);
            req.setHttpMethod("GET");
            OapiGettokenResponse rsp = (OapiGettokenResponse)client.execute((TaobaoRequest)req);
            retMsg.put("access_token", (Object)rsp.getAccessToken());
            if (!rsp.isSuccess()) {
                retMsg.put("code", (Object)false);
                retMsg.put("error", (Object)rsp.getErrmsg());
                retMsg.put("access_token", (Object)"");
            }
        }
        catch (ApiException e) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)e.toString());
            retMsg.put("access_token", (Object)"");
        }
        return retMsg;
    }

    public static DingSentResult sendDingMessage(String appkey, String appsecret, String agentid, String userIds, McTaskMsgContentEntity content) {
        if (StringUtils.isEmpty((String)agentid) || StringUtils.isEmpty((String)userIds) || ObjectUtil.isEmpty((Object)content)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u6267\u884c \u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u6d88\u606fpost\u4e0b\u53d1\uff0ccontent \u6216 corpId\u4f01\u4e1aid \u6216 touser\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        DefaultDingTalkClient client = new DefaultDingTalkClient(SEND_MESSAGE);
        Boolean toUserIdAll = "@to_all_user".equals(userIds);
        String contentType = content.getContentType();
        OapiMessageCorpconversationAsyncsendV2Request request = new OapiMessageCorpconversationAsyncsendV2Request();
        request.setAgentId(Long.valueOf(Long.parseLong(agentid)));
        request.setUseridList(userIds);
        request.setToAllUser(toUserIdAll);
        OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
        if (ContentTypeEnum.LINK_MSG.getCode().equals(contentType)) {
            msg.setActionCard(new OapiMessageCorpconversationAsyncsendV2Request.ActionCard());
            msg.setMsgtype("action_card");
            msg.getActionCard().setTitle(content.getTitle());
            msg.getActionCard().setMarkdown(content.getContent());
            msg.getActionCard().setSingleTitle("\u67e5\u770b\u8be6\u60c5");
            msg.getActionCard().setSingleUrl(content.getLinkUrl());
        } else if (ContentTypeEnum.IMG_TEXT_MSG.getCode().equals(contentType)) {
            msg.setMsgtype("link");
            msg.setLink(new OapiMessageCorpconversationAsyncsendV2Request.Link());
            msg.getLink().setTitle(content.getTitle());
            msg.getLink().setText(content.getContent());
            msg.getLink().setMessageUrl(content.getLinkUrl());
            msg.getLink().setPicUrl(content.getPicUrl());
        } else {
            msg.setMsgtype("text");
            msg.setText(new OapiMessageCorpconversationAsyncsendV2Request.Text());
            String randomCode = "\u968f\u673a\u9a8c\u8bc1\u7801\uff1a" + RandomUtil.uuId();
            msg.getText().setContent(content.getContent() + randomCode);
        }
        request.setMsg(msg);
        DingSentResult dingSentResult = new DingSentResult();
        dingSentResult.setMsgId(content.getMsgId());
        try {
            JSONObject retMsg = DingTalkUtil.getAccessToken(appkey, appsecret);
            if (retMsg.getBoolean("code").booleanValue()) {
                OapiMessageCorpconversationAsyncsendV2Response response = (OapiMessageCorpconversationAsyncsendV2Response)client.execute((TaobaoRequest)request, retMsg.getString("access_token"));
                if (response.getErrcode() > 0L) {
                    dingSentResult.setErrCode(false);
                    dingSentResult.setErrMsg(response.getErrmsg());
                    dingSentResult.setFailUser(userIds);
                } else {
                    dingSentResult.setErrCode(true);
                    dingSentResult.setErrMsg("");
                }
            } else {
                dingSentResult.setErrCode(false);
                dingSentResult.setErrMsg("\u83b7\u53d6token\u5931\u8d25:" + retMsg.getString("error"));
                dingSentResult.setFailUser(userIds);
            }
            return dingSentResult;
        }
        catch (ApiException e) {
            dingSentResult.setErrCode(false);
            dingSentResult.setErrMsg(e.toString());
            dingSentResult.setFailUser(userIds);
            return dingSentResult;
        }
    }
}

