/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.util;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.system.msgCenter.model.message.MyEmailModel;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class EmailUtil {
    public static boolean isEmail(String email) {
        String EMAIL_REGEX = "^[\\w-_\\.+]*[\\w-_\\.]\\@([\\w]+\\.)+[\\w]+[\\w]$";
        Boolean b = email.matches(EMAIL_REGEX);
        return b;
    }

    public static JSONObject sendMail(MyEmailModel emailModel) {
        JSONObject retMsg = new JSONObject();
        String from = emailModel.getEmailAccount();
        String to = emailModel.getEmailToUsers();
        Properties props = System.getProperties();
        props.setProperty("mail.smtp.host", emailModel.getEmailSmtpHost());
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.smtp.ssl.enable", emailModel.getEmailSsl());
        props.setProperty("mail.transport.protocol", "smtp");
        if ("587".equals(emailModel.getEmailSmtpPort())) {
            props.put("mail.smtp.starttls.enable", "true");
        }
        Session session = Session.getInstance((Properties)props);
        session.setDebug(true);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from, emailModel.getEmailSenderName(), "UTF-8"));
            InternetAddress[] sendTo = InternetAddress.parse((String)to);
            message.setRecipients(MimeMessage.RecipientType.TO, (Address[])sendTo);
            message.setSubject(emailModel.getEmailTitle());
            message.setContent((Object)emailModel.getEmailContent(), "text/html;charset=utf-8");
            Transport transport = session.getTransport();
            transport.connect(emailModel.getEmailSmtpHost(), Integer.parseInt(emailModel.getEmailSmtpPort()), emailModel.getEmailAccount(), emailModel.getEmailPassword());
            transport.sendMessage((Message)message, (Address[])sendTo);
            transport.close();
            retMsg.put("code", (Object)true);
            retMsg.put("error", (Object)"");
            return retMsg;
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)e.toString());
            return retMsg;
        }
    }
}

