/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgCenter.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.msgCenter.constant.CommonConsts;
import com.bringspring.system.msgCenter.model.BusinessKeys;
import com.bringspring.system.msgCenter.model.CustomKeysLink;
import com.bringspring.system.msgCenter.model.TaskMsg;
import com.bringspring.system.msgCenter.model.mcTaskMsg.McTaskMsgCrForm;
import com.bringspring.system.msgCenter.service.McTaskMsgService;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SendTaskMsgUtils {
    private static final Logger log = LoggerFactory.getLogger(SendTaskMsgUtils.class);
    @Autowired
    private McTaskMsgService mcTaskMsgService;

    public void sendTaskMsg(TaskMsg taskMsg) throws Exception {
        CustomKeysLink customKey;
        McTaskMsgCrForm mcTaskMsgCrForm = new McTaskMsgCrForm();
        mcTaskMsgCrForm.setTaskCode(taskMsg.getTaskCode());
        mcTaskMsgCrForm.setSendCode(taskMsg.getSendCode());
        mcTaskMsgCrForm.setToUserIds(taskMsg.getToUserIds());
        mcTaskMsgCrForm.setToDeptIds(taskMsg.getToDeptIds());
        mcTaskMsgCrForm.setDescription(taskMsg.getDescription());
        mcTaskMsgCrForm.setAutoAgainMaxNum(ObjectUtil.isEmpty((Object)taskMsg.getAutoAgainMaxNum()) ? CommonConsts.AUTO_AGAIN_MAX_NUM : taskMsg.getAutoAgainMaxNum());
        BusinessKeys businessKey = taskMsg.getBusinessKey();
        if (ObjectUtil.isNotNull((Object)businessKey)) {
            Map<String, String> keys = businessKey.getKeys();
            if (ObjectUtil.isNull(keys)) {
                keys = new HashMap<String, String>();
            }
            Field[] fieldsDirectly = ReflectUtil.getFieldsDirectly(businessKey.getClass(), (boolean)false);
            for (int i = 0; i < fieldsDirectly.length; ++i) {
                String key = fieldsDirectly[i].getName();
                Object val = ReflectUtil.getFieldValue((Object)businessKey, (String)key);
                if (ObjectUtil.isNull((Object)val)) {
                    keys.put(key, null);
                    continue;
                }
                keys.put(key, val.toString());
            }
            mcTaskMsgCrForm.setBusinessKey(JsonUtil.getObjectToString(keys));
        }
        if (ObjectUtil.isNotNull((Object)(customKey = taskMsg.getCustomKey()))) {
            mcTaskMsgCrForm.setCustomKey(JsonUtil.getObjectToString((Object)customKey));
        }
        this.mcTaskMsgService.addAndSendMessage(mcTaskMsgCrForm);
    }
}

