/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.aop;

import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.aop.PermissionAdminBase;
import com.bringspring.system.permission.entity.OrganizeRelationEntity;
import com.bringspring.system.permission.model.user.form.UserCrForm;
import com.bringspring.system.permission.model.user.form.UserUpForm;
import com.bringspring.system.permission.model.userrelation.UserRelationForm;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.util.PermissionAspectUtil;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PermissionUserAspect
implements PermissionAdminBase {
    private static final Logger log = LoggerFactory.getLogger(PermissionUserAspect.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private PositionService positionService;

    @Pointcut(value="@annotation(com.bringspring.common.annotation.UserPermission)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        return PermissionAdminBase.permissionCommon(pjp, this.userProvider, this);
    }

    @Override
    public Boolean detailPermission(ProceedingJoinPoint pjp, String operatorUserId, String methodName) {
        switch (methodName) {
            case "create": {
                UserCrForm userCrForm = (UserCrForm)pjp.getArgs()[0];
                return PermissionAspectUtil.getPermitByOrgIds(userCrForm.getOrganizeId(), operatorUserId, "create");
            }
            case "update": {
                return PermissionAspectUtil.getPermitByUserId(String.valueOf(pjp.getArgs()[0]), operatorUserId, "update") != false || PermissionAspectUtil.getPermitByOrgIds(((UserUpForm)pjp.getArgs()[1]).getOrganizeId(), operatorUserId, "update") != false;
            }
            case "modifyPassword": {
                return PermissionAspectUtil.getPermitByUserId(String.valueOf(pjp.getArgs()[0]), operatorUserId, "update");
            }
            case "delete": {
                return PermissionAspectUtil.getPermitByUserId(pjp.getArgs()[0].toString(), operatorUserId, "delete");
            }
            case "save": {
                String objId = pjp.getArgs()[0].toString();
                UserRelationForm userRelationForm = (UserRelationForm)pjp.getArgs()[1];
                ArrayList<String> orgIds = new ArrayList<String>();
                if (userRelationForm.getObjectType().equals("Role")) {
                    if (this.userProvider.get().getIsAdministrator().booleanValue()) {
                        return true;
                    }
                    orgIds.addAll(this.organizeRelationService.getRelationListByRoleId(objId).stream().map(OrganizeRelationEntity::getOrganizeId).collect(Collectors.toList()));
                    return PermissionAspectUtil.getPermitByOrgIds(String.join((CharSequence)",", orgIds), operatorUserId, "update");
                }
                orgIds.add(this.positionService.getInfo(objId).getOrganizeId());
                return PermissionAspectUtil.getPermitByOrgIds(String.join((CharSequence)",", orgIds), operatorUserId, "update");
            }
        }
        return false;
    }
}

