/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.HandleLog;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.GlobalMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.entity.AuthorizeEntity;
import com.bringspring.system.permission.entity.BasePositionRelationEntity;
import com.bringspring.system.permission.entity.OrganizeAdministratorEntity;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.OrganizeRelationEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.model.role.RoleCrForm;
import com.bringspring.system.permission.model.role.RoleInfoVO;
import com.bringspring.system.permission.model.role.RoleListVO;
import com.bringspring.system.permission.model.role.RoleModel;
import com.bringspring.system.permission.model.role.RolePagination;
import com.bringspring.system.permission.model.role.RoleSelectorVO;
import com.bringspring.system.permission.model.role.RoleUpForm;
import com.bringspring.system.permission.service.BasePositionRelationService;
import com.bringspring.system.permission.service.OrganizeAdministratorService;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.PermissionUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u89d2\u8272\u7ba1\u7406"}, value="Role")
@RestController
@RequestMapping(value={"/api/permission/Role"})
public class RoleController {
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private OrganizeAdministratorService organizeAdministratorService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private BasePositionRelationService positionRelationService;

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868")
    @GetMapping
    public ActionResult list(RolePagination pagination) {
        List<RoleEntity> list = this.roleService.getListByDataPermission(pagination);
        ArrayList<RoleListVO> listVO = new ArrayList<RoleListVO>();
        for (RoleEntity entity : list) {
            RoleListVO vo = (RoleListVO)JsonUtil.getJsonToBean((Object)entity, RoleListVO.class);
            if (StringUtils.isNotEmpty((String)entity.getType())) {
                String type = "";
                String[] split = entity.getType().split(",");
                for (int i = 0; i < split.length; ++i) {
                    DictionaryDataEntity swapInfo = this.dictionaryDataService.getSwapInfo(split[i], "4501f6f26a384757bce12d4c4b03342c");
                    if (!ObjectUtil.isNotNull((Object)swapInfo) || !StringUtils.isNotEmpty((String)swapInfo.getFullName())) continue;
                    type = type + swapInfo.getFullName() + "\uff0c";
                }
                vo.setRoleType(type.substring(0, type.length() - 1));
            }
            if (ObjectUtil.isNotEmpty((Object)entity) && entity.getGlobalMark().equals(GlobalMarkEnum.NOT_ORGANIZE.getCode())) {
                vo.setType("\u5168\u5c40");
            } else {
                vo.setType("\u7ec4\u7ec7");
                QueryWrapper query = new QueryWrapper();
                query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)"Role");
                query.lambda().eq(OrganizeRelationEntity::getObjectId, (Object)entity.getId());
                ArrayList<String> ids = new ArrayList<String>();
                for (OrganizeRelationEntity relation : this.organizeRelationService.list((Wrapper)query)) {
                    ids.add(relation.getOrganizeId());
                }
                String orgInfos = PermissionUtil.getLinkInfoByOrgId(ids, this.organizeService);
                if (orgInfos.length() > 0) {
                    vo.setOrganizeInfo(orgInfos.substring(0, orgInfos.length() - 1));
                } else {
                    vo.setOrganizeInfo("");
                }
            }
            listVO.add(vo);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page(listVO, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u89d2\u8272\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/Selector"})
    public ActionResult<ListVO<RoleSelectorVO>> listAll() {
        List<RoleEntity> list1 = this.roleService.getList();
        List<OrganizeEntity> list2 = this.organizeService.getList();
        ArrayList<RoleModel> roleModels = new ArrayList<RoleModel>();
        ArrayList<Object> modelList = new ArrayList<Object>();
        if (this.userProvider.get().getIsAdministrator().booleanValue()) {
            RoleSelectorVO globalParent = new RoleSelectorVO();
            String globalParentId = "1";
            globalParent.setFullName("\u5168\u5c40");
            globalParent.setId("1");
            globalParent.setId(globalParentId);
            globalParent.setOnlyId("organizeList_0");
            List globalModelList = JsonUtil.getJsonToList(this.roleService.getGlobalList(), RoleSelectorVO.class);
            globalModelList.forEach(g -> {
                g.setType("role");
                g.setOnlyId(UUID.randomUUID().toString());
                g.setParentId(globalParentId);
            });
            globalParent.setHasChildren(globalModelList.size() > 0);
            globalParent.setChildren(globalModelList);
            globalParent.setIsLeaf(false);
            globalParent.setIcon("icon-ym icon-ym-global-role");
            modelList.add(globalParent);
        }
        for (RoleEntity roleEntity : list1) {
            List<OrganizeRelationEntity> relationListByObjectIdAndType = this.organizeRelationService.getRelationListByObjectIdAndType("Role", roleEntity.getId());
            for (OrganizeRelationEntity entity : relationListByObjectIdAndType) {
                RoleModel roleVo = (RoleModel)((Object)JsonUtil.getJsonToBean((Object)roleEntity, RoleModel.class));
                roleVo.setType("role");
                roleVo.setOnlyId(UUID.randomUUID().toString());
                roleVo.setParentId(entity.getOrganizeId());
                roleModels.add(roleVo);
            }
        }
        ArrayList orgList = new ArrayList(16);
        list2.stream().forEach(org -> {
            RoleModel orgVo = (RoleModel)((Object)((Object)JsonUtil.getJsonToBean((Object)org, RoleModel.class)));
            orgVo.setType(org.getCategory());
            orgVo.setIcon(StringUtils.isNotEmpty((String)org.getCategory()) ? ("company".equals(org.getCategory()) ? "icon-ym icon-ym-tree-organization3" : "icon-ym icon-ym-tree-department1") : "");
            orgVo.setOnlyId(UUID.randomUUID().toString());
            orgList.add(orgVo);
        });
        JSONArray objects = ListToTreeUtil.treeWhere(roleModels, orgList);
        List jsonToList = JsonUtil.getJsonToList((Object)objects, RoleModel.class);
        ArrayList list = new ArrayList(16);
        List collect = jsonToList.stream().filter(t -> "role".equals(t.getType())).sorted(Comparator.comparing(RoleModel::getSortCode)).collect(Collectors.toList());
        list.addAll(collect);
        jsonToList.removeAll(collect);
        List collect1 = jsonToList.stream().sorted(Comparator.comparing(RoleModel::getSortCode).thenComparing(RoleModel::getCreatorTime, Comparator.reverseOrder())).collect(Collectors.toList());
        list.addAll(collect1);
        List trees = TreeDotUtils.convertListToTreeDot(list);
        modelList.addAll(JsonUtil.getJsonToList((Object)trees, RoleSelectorVO.class));
        ListVO vo = new ListVO();
        vo.setList(modelList);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5206\u7ea7\u7ba1\u7406\u4e0b\u89d2\u8272\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/SelectorByPermission"})
    public ActionResult<ListVO<RoleSelectorVO>> roleListAll() {
        boolean isAdministrator = this.userProvider.get().getIsAdministrator();
        List<Object> list1 = new ArrayList(16);
        List<OrganizeEntity> list2 = this.organizeService.getList();
        ArrayList<RoleModel> roleModels = new ArrayList<RoleModel>();
        ArrayList<RoleSelectorVO> modelList = new ArrayList<RoleSelectorVO>();
        if (isAdministrator) {
            RoleSelectorVO globalParent = new RoleSelectorVO();
            String string = "global";
            globalParent.setFullName("\u5168\u5c40");
            globalParent.setId(string);
            globalParent.setOnlyId("organizeList_0");
            List globalModelList = JsonUtil.getJsonToList(this.roleService.getGlobalList(), RoleSelectorVO.class);
            globalModelList.forEach(g -> {
                g.setType("role");
                g.setOnlyId(UUID.randomUUID().toString());
                g.setParentId(globalParentId);
            });
            globalParent.setHasChildren(globalModelList.size() > 0);
            globalParent.setChildren(globalModelList);
            globalParent.setIsLeaf(false);
            globalParent.setIcon("icon-ym icon-ym-global-role");
            modelList.add(globalParent);
        }
        if (!isAdministrator) {
            HashSet set = new HashSet(16);
            List<OrganizeAdministratorEntity> list = this.organizeAdministratorService.getOrganizeAdministratorEntity(this.userProvider.get().getUserId());
            list.stream().forEach(t -> {
                if ("1".equals(String.valueOf(t.getThisLayerEdit()))) {
                    set.add(t.getOrganizeId());
                }
                if ("1".equals(String.valueOf(t.getSubLayerEdit()))) {
                    List<String> underOrganizations = this.organizeService.getUnderOrganizations(t.getOrganizeId());
                    set.addAll(underOrganizations);
                }
            });
            ArrayList finalOrganizeEntities = new ArrayList(16);
            set.forEach(t -> {
                OrganizeEntity entity = this.organizeService.getInfo((String)t);
                if (entity != null) {
                    finalOrganizeEntities.add(entity);
                }
            });
            List<OrganizeRelationEntity> relationListByOrganizeId = this.organizeRelationService.getRelationListByOrganizeId(finalOrganizeEntities.stream().map(OrganizeEntity::getId).collect(Collectors.toList()));
            list1 = this.roleService.getListByIds(relationListByOrganizeId.stream().filter(t -> "Role".equals(t.getObjectType())).map(OrganizeRelationEntity::getObjectId).collect(Collectors.toList()));
        } else {
            list1 = this.roleService.getList();
        }
        for (RoleEntity roleEntity : list1) {
            List<OrganizeRelationEntity> relationListByObjectIdAndType = this.organizeRelationService.getRelationListByObjectIdAndType("Role", roleEntity.getId());
            for (OrganizeRelationEntity entity : relationListByObjectIdAndType) {
                RoleModel roleVo = (RoleModel)((Object)JsonUtil.getJsonToBean((Object)roleEntity, RoleModel.class));
                roleVo.setType("role");
                roleVo.setOnlyId(UUID.randomUUID().toString());
                roleVo.setParentId(entity.getOrganizeId());
                roleModels.add(roleVo);
            }
        }
        ArrayList orgList = new ArrayList(16);
        list2.stream().forEach(org -> {
            RoleModel orgVo = (RoleModel)((Object)((Object)((Object)JsonUtil.getJsonToBean((Object)org, RoleModel.class))));
            orgVo.setType(org.getCategory());
            orgVo.setIcon(StringUtils.isNotEmpty((String)org.getCategory()) ? ("company".equals(org.getCategory()) ? "icon-ym icon-ym-tree-organization3" : "icon-ym icon-ym-tree-department1") : "");
            orgVo.setOnlyId(UUID.randomUUID().toString());
            orgList.add(orgVo);
        });
        JSONArray jSONArray = ListToTreeUtil.treeWhere(roleModels, orgList);
        List jsonToList = JsonUtil.getJsonToList((Object)jSONArray, RoleModel.class);
        ArrayList list = new ArrayList(16);
        List collect = jsonToList.stream().filter(t -> "role".equals(t.getType())).sorted(Comparator.comparing(RoleModel::getSortCode)).collect(Collectors.toList());
        list.addAll(collect);
        jsonToList.removeAll(collect);
        List collect1 = jsonToList.stream().sorted(Comparator.comparing(RoleModel::getSortCode).thenComparing(RoleModel::getCreatorTime, Comparator.reverseOrder())).collect(Collectors.toList());
        list.addAll(collect1);
        List trees = TreeDotUtils.convertListToTreeDot(list);
        modelList.addAll(JsonUtil.getJsonToList((Object)trees, RoleSelectorVO.class));
        ListVO vo = new ListVO();
        vo.setList(modelList);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5206\u7ea7\u7ba1\u7406\u4e0b\u89d2\u8272\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/SelectorRoleByPermission/{menuId}"})
    public ActionResult<ListVO<RoleSelectorVO>> roleListPermissionAll(@PathVariable(value="menuId") String menuId) {
        boolean isAdministrator = this.userProvider.get().getIsAdministrator();
        List<Object> list1 = new ArrayList(16);
        List<OrganizeEntity> list2 = this.organizeService.getList();
        ArrayList<RoleModel> roleModels = new ArrayList<RoleModel>();
        ArrayList<RoleSelectorVO> modelList = new ArrayList<RoleSelectorVO>();
        if (isAdministrator) {
            RoleSelectorVO globalParent = new RoleSelectorVO();
            String string = "global";
            globalParent.setFullName("\u5168\u5c40");
            globalParent.setId(string);
            globalParent.setOnlyId("organizeList_0");
            List globalModelList = JsonUtil.getJsonToList(this.roleService.getGlobalList(), RoleSelectorVO.class);
            globalModelList.forEach(g -> {
                g.setType("role");
                g.setOnlyId(UUID.randomUUID().toString());
                g.setParentId(globalParentId);
            });
            globalParent.setHasChildren(globalModelList.size() > 0);
            globalParent.setChildren(globalModelList);
            globalParent.setIsLeaf(false);
            globalParent.setIcon("icon-ym icon-ym-global-role");
            modelList.add(globalParent);
        }
        if (!isAdministrator) {
            List<OrganizeEntity> companyList = this.organizeService.getCompanyList(menuId);
            List<OrganizeEntity> list = this.organizeService.getCompanyById(((OrganizeEntity)companyList.get(0)).getId());
            List<OrganizeRelationEntity> relationListByOrganizeId = this.organizeRelationService.getRelationListByOrganizeId(list.stream().map(OrganizeEntity::getId).collect(Collectors.toList()));
            list1 = this.roleService.getListByIds(relationListByOrganizeId.stream().filter(t -> "Role".equals(t.getObjectType())).map(OrganizeRelationEntity::getObjectId).collect(Collectors.toList()));
        } else {
            list1 = this.roleService.getList();
        }
        for (RoleEntity roleEntity : list1) {
            List<OrganizeRelationEntity> relationListByObjectIdAndType = this.organizeRelationService.getRelationListByObjectIdAndType("Role", roleEntity.getId());
            for (OrganizeRelationEntity entity : relationListByObjectIdAndType) {
                RoleModel roleVo = (RoleModel)((Object)JsonUtil.getJsonToBean((Object)roleEntity, RoleModel.class));
                roleVo.setType("role");
                roleVo.setOnlyId(UUID.randomUUID().toString());
                roleVo.setParentId(entity.getOrganizeId());
                roleModels.add(roleVo);
            }
        }
        ArrayList orgList = new ArrayList(16);
        list2.stream().forEach(org -> {
            RoleModel orgVo = (RoleModel)((Object)((Object)((Object)JsonUtil.getJsonToBean((Object)org, RoleModel.class))));
            orgVo.setType(org.getCategory());
            orgVo.setIcon(StringUtils.isNotEmpty((String)org.getCategory()) ? ("company".equals(org.getCategory()) ? "icon-ym icon-ym-tree-organization3" : "icon-ym icon-ym-tree-department1") : "");
            orgVo.setOnlyId(UUID.randomUUID().toString());
            orgList.add(orgVo);
        });
        JSONArray jSONArray = ListToTreeUtil.treeWhere(roleModels, orgList);
        List jsonToList = JsonUtil.getJsonToList((Object)jSONArray, RoleModel.class);
        ArrayList list = new ArrayList(16);
        List collect = jsonToList.stream().filter(t -> "role".equals(t.getType())).sorted(Comparator.comparing(RoleModel::getSortCode)).collect(Collectors.toList());
        list.addAll(collect);
        jsonToList.removeAll(collect);
        List collect1 = jsonToList.stream().sorted(Comparator.comparing(RoleModel::getSortCode).thenComparing(RoleModel::getCreatorTime, Comparator.reverseOrder())).collect(Collectors.toList());
        list.addAll(collect1);
        List trees = TreeDotUtils.convertListToTreeDot(list);
        modelList.addAll(JsonUtil.getJsonToList((Object)trees, RoleSelectorVO.class));
        ListVO vo = new ListVO();
        vo.setList(modelList);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<RoleInfoVO> getInfo(@PathVariable(value="id") String id) throws DataException {
        RoleEntity entity = this.roleService.getInfo(id);
        RoleInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, RoleInfoVO.class);
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)"Role");
        query.lambda().eq(OrganizeRelationEntity::getObjectId, (Object)id);
        ArrayList<String> ids = new ArrayList<String>();
        this.organizeRelationService.list((Wrapper)query).forEach(relation -> ids.add(relation.getOrganizeId()));
        vo.setOrganizeIdsTree(PermissionUtil.getOrgIdsTree(ids, 1, this.organizeService));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u65b0\u5efa\u89d2\u8272")
    @PostMapping
    @DSTransactional
    @HandleLog(moduleName="\u89d2\u8272\u7ba1\u7406", requestMethod="\u65b0\u5efa\u89d2\u8272")
    public ActionResult<String> create(@RequestBody @Valid RoleCrForm roleCrForm) {
        RoleEntity entity = (RoleEntity)JsonUtil.getJsonToBean((Object)roleCrForm, RoleEntity.class);
        if (this.roleService.isExistByFullName(roleCrForm.getFullName(), entity.getId()).booleanValue()) {
            return ActionResult.fail((String)"\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.roleService.isExistByEnCode(roleCrForm.getEnCode(), entity.getId()).booleanValue()) {
            return ActionResult.fail((String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        String roleId = RandomUtil.uuId();
        entity.setId(roleId);
        this.roleService.createOrganizeRoleRelation(roleCrForm.getOrganizeIdsTree(), roleId, roleCrForm.getGlobalMark());
        this.roleService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272")
    @PutMapping(value={"/{id}"})
    @HandleLog(moduleName="\u89d2\u8272\u7ba1\u7406", requestMethod="\u66f4\u65b0\u89d2\u8272")
    public ActionResult<String> update(@RequestBody @Valid RoleUpForm roleUpForm, @PathVariable(value="id") String id) throws DataException, PermissionException {
        boolean flag = this.roleService.update(id, roleUpForm);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272\u9a8c\u8bc1")
    @PutMapping(value={"/updateVerify/{id}"})
    public ActionResult<Integer> updateVerify(@RequestBody @Valid RoleUpForm roleUpForm, @PathVariable(value="id") String id) throws DataException, PermissionException {
        Integer errorCount = this.roleService.updateVerify(id, roleUpForm);
        if (errorCount > 0) {
            return ActionResult.success((Object)errorCount);
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u590d\u5236\u89d2\u8272")
    @PostMapping(value={"/copy/{id}"})
    @DSTransactional
    @HandleLog(moduleName="\u89d2\u8272\u7ba1\u7406", requestMethod="\u590d\u5236\u89d2\u8272")
    public ActionResult<String> copyRole(@RequestBody @Valid RoleUpForm roleUpForm, @PathVariable(value="id") String id) throws BaseException {
        this.roleService.copyRole(roleUpForm, id);
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272")
    @DeleteMapping(value={"/{id}"})
    @HandleLog(moduleName="\u89d2\u8272\u7ba1\u7406", requestMethod="\u5220\u9664\u89d2\u8272")
    public ActionResult<String> delete(@PathVariable(value="id") String id) {
        if (this.userRelationService.existByObjectId(id, "Role").booleanValue()) {
            return ActionResult.fail((String)MsgCode.FA024.get());
        }
        RoleEntity entity = this.roleService.getInfo(id);
        if (entity != null) {
            List<UserRelationEntity> userRelList = this.userRelationService.getListByObjectId(id);
            if (userRelList.size() > 0) {
                return ActionResult.fail((String)"\u8be5\u89d2\u8272\u4e0b\u6709\u6570\u636e\u6743\u9650");
            }
            for (UserRelationEntity entity1 : userRelList) {
                UserEntity entity2 = (UserEntity)this.userService.getById((Serializable)((Object)entity1.getUserId()));
                if (entity2 == null) continue;
                String newRoleId = entity2.getRoleId().replace(id, "");
                if (!entity2.getRoleId().contains(id)) continue;
                if (newRoleId.length() != 0 && newRoleId.substring(0, 1) == ",") {
                    entity2.setRoleId(newRoleId.substring(1));
                    continue;
                }
                if (newRoleId.length() == 0) continue;
                entity2.setRoleId(newRoleId.replace(",,", ","));
            }
            this.userRelationService.deleteAllByObjId(id);
            this.organizeRelationService.deleteAllByObjectId(id, "Role");
            this.roleService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    @HandleLog(moduleName="\u89d2\u8272\u7ba1\u7406", requestMethod="\u66f4\u65b0\u89d2\u8272\u72b6\u6001")
    public ActionResult<String> disable(@PathVariable(value="id") String id) {
        RoleEntity entity = this.roleService.getInfo(id);
        if (entity != null) {
            if ("1".equals(String.valueOf(entity.getEnabledMark()))) {
                entity.setEnabledMark(0);
            } else {
                entity.setEnabledMark(1);
            }
            this.roleService.updateById(entity);
            return ActionResult.success((String)MsgCode.SU005.get());
        }
        return ActionResult.fail((String)MsgCode.FA007.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868\u901a\u8fc7\u7ec4\u7ec7id\u6570\u7ec4")
    @PostMapping(value={"/getListByOrgIds"})
    public ActionResult<ListVO<RoleModel>> getListByOrganizeIds(@RequestBody @Valid Map<String, List<String>> organizeIds) {
        ArrayList<RoleModel> modelAll = new ArrayList<RoleModel>();
        ArrayList models = new ArrayList();
        this.roleService.getGlobalList().forEach(r -> models.add(JsonUtil.getJsonToBean((Object)r, RoleModel.class)));
        RoleModel modelGlobal = new RoleModel();
        modelGlobal.setFullName("\u5168\u5c40");
        modelGlobal.setHasChildren(true);
        modelGlobal.setId("0");
        modelGlobal.setChildren(models);
        modelAll.add(modelGlobal);
        List<String> organizeIdList = organizeIds.get("organizeIds");
        if (CollectionUtil.isNotEmpty(organizeIdList)) {
            for (String organizeId : organizeIds.get("organizeIds")) {
                OrganizeEntity organizeEntity = this.organizeService.getInfo(organizeId);
                if (!ObjectUtil.isNotEmpty((Object)organizeEntity)) continue;
                RoleModel organizeModel = (RoleModel)((Object)JsonUtil.getJsonToBean((Object)organizeEntity, RoleModel.class));
                List<OrganizeRelationEntity> roleRelations = this.organizeRelationService.getListByTypeAndOrgId("Role", organizeId);
                ArrayList<RoleModel> roleList = new ArrayList<RoleModel>();
                for (OrganizeRelationEntity roleRelation : roleRelations) {
                    RoleEntity roleEntity = this.roleService.getInfo(roleRelation.getObjectId());
                    if (!StringUtils.isNotNull((Object)roleEntity) || roleEntity.getGlobalMark() != GlobalMarkEnum.ORGANIZE.getCode()) continue;
                    RoleModel roleModel = (RoleModel)((Object)JsonUtil.getJsonToBean((Object)this.roleService.getInfo(roleRelation.getObjectId()), RoleModel.class));
                    roleModel.setHasChildren(false);
                    roleList.add(roleModel);
                }
                organizeModel.setHasChildren(true);
                organizeModel.setChildren(roleList);
                modelAll.add(organizeModel);
            }
        }
        ListVO vo = new ListVO();
        vo.setList(modelAll);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5c97\u4f4d\u5217\u8868\uff08\u5206\u9875\uff09")
    @GetMapping(value={"/roleDataPermission"})
    public ActionResult<PageListVO<RoleListVO>> listDataPermission(RolePagination paginationPosition) {
        List list = this.organizeService.getList().stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
        List<RoleEntity> data = this.roleService.getListPositionDataPermission(paginationPosition);
        ArrayList<RoleListVO> voList = new ArrayList<RoleListVO>();
        for (RoleEntity entity : data) {
            RoleListVO vo = (RoleListVO)JsonUtil.getJsonToBean((Object)entity, RoleListVO.class);
            DictionaryDataEntity swapInfo = this.dictionaryDataService.getSwapInfo(entity.getType(), "4501f6f26a384757bce12d4c4b03342c");
            if (ObjectUtil.isNotNull((Object)swapInfo) && StringUtils.isNotEmpty((String)swapInfo.getFullName())) {
                vo.setRoleType(swapInfo.getFullName());
            }
            if (ObjectUtil.isNotEmpty((Object)entity) && entity.getGlobalMark().equals(GlobalMarkEnum.NOT_ORGANIZE.getCode())) {
                vo.setType("\u5168\u5c40");
            } else {
                vo.setType("\u7ec4\u7ec7");
                QueryWrapper query = new QueryWrapper();
                query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)"Role");
                query.lambda().eq(OrganizeRelationEntity::getObjectId, (Object)entity.getId());
                ArrayList<String> ids = new ArrayList<String>();
                for (OrganizeRelationEntity relation : this.organizeRelationService.list((Wrapper)query)) {
                    ids.add(relation.getOrganizeId());
                }
                String orgInfos = PermissionUtil.getLinkInfoByOrgId(ids, this.organizeService);
                if (orgInfos.length() > 0) {
                    vo.setOrganizeInfo(orgInfos.substring(0, orgInfos.length() - 1));
                } else {
                    vo.setOrganizeInfo("");
                }
            }
            voList.add(vo);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationPosition), PaginationVO.class);
        return ActionResult.page(voList, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868\u901a\u8fc7\u7ec4\u7ec7id\u6570\u7ec4")
    @PostMapping(value={"/getListByPositionIds"})
    public ActionResult<ListVO<RoleModel>> getListByPositionIds(@RequestBody @Valid Map<String, List<String>> positionIds) {
        ArrayList<RoleModel> modelAll = new ArrayList<RoleModel>();
        ArrayList models = new ArrayList();
        this.roleService.getGlobalList().forEach(r -> models.add(JsonUtil.getJsonToBean((Object)r, RoleModel.class)));
        RoleModel modelGlobal = new RoleModel();
        modelGlobal.setFullName("\u5168\u5c40");
        modelGlobal.setHasChildren(true);
        modelGlobal.setId("0");
        modelGlobal.setChildren(models);
        modelAll.add(modelGlobal);
        List<String> organizeIdList = positionIds.get("positionIds");
        if (CollectionUtil.isNotEmpty(organizeIdList)) {
            for (String positionId : positionIds.get("positionIds")) {
                PositionEntity positionEntity = this.positionService.getInfo(positionId);
                if (!ObjectUtil.isNotEmpty((Object)positionEntity)) continue;
                RoleModel organizeModel = (RoleModel)((Object)JsonUtil.getJsonToBean((Object)positionEntity, RoleModel.class));
                List<BasePositionRelationEntity> posRelations = this.positionRelationService.getListByTypeAndPosId("Role", positionId);
                ArrayList<RoleModel> roleList = new ArrayList<RoleModel>();
                for (BasePositionRelationEntity roleRelation : posRelations) {
                    RoleEntity roleEntity = this.roleService.getInfo(roleRelation.getObjectId());
                    if (roleEntity.getGlobalMark() != GlobalMarkEnum.ORGANIZE.getCode()) continue;
                    RoleModel roleModel = (RoleModel)((Object)JsonUtil.getJsonToBean((Object)this.roleService.getInfo(roleRelation.getObjectId()), RoleModel.class));
                    roleModel.setHasChildren(false);
                    roleList.add(roleModel);
                }
                organizeModel.setHasChildren(true);
                organizeModel.setChildren(roleList);
                modelAll.add(organizeModel);
            }
        }
        ListVO vo = new ListVO();
        vo.setList(modelAll);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6839\u636e\u83dc\u5355id\u83b7\u53d6\u89d2\u8272\u5217\u8868\u4fe1\u606f")
    @GetMapping(value={"/getListBymenuId/{menuId}"})
    public ActionResult<List<RoleListVO>> getListBymenuId(@PathVariable(value="menuId") String menuId) throws DataException {
        List<AuthorizeEntity> authorizeEntityList = this.roleService.getListBymenuId(menuId);
        UserInfo userInfo = this.userProvider.get();
        ArrayList<RoleEntity> list = new ArrayList<RoleEntity>();
        for (AuthorizeEntity authorizeEntity : authorizeEntityList) {
            RoleEntity entity = this.roleService.getInfo(authorizeEntity.getObjectId());
            if (!StringUtils.isNotNull((Object)entity)) continue;
            list.add(entity);
        }
        ArrayList<RoleListVO> listVO = new ArrayList<RoleListVO>();
        for (int i = 0; i < list.size(); ++i) {
            RoleListVO vo = (RoleListVO)JsonUtil.getJsonToBean(list.get(i), RoleListVO.class);
            if (((RoleEntity)list.get(i)).getGlobalMark() != null && ((RoleEntity)list.get(i)).getGlobalMark().equals(GlobalMarkEnum.NOT_ORGANIZE.getCode())) {
                vo.setType("\u5168\u5c40");
                listVO.add(vo);
                continue;
            }
            vo.setType("\u7ec4\u7ec7");
            QueryWrapper query = new QueryWrapper();
            query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)"Role");
            query.lambda().eq(OrganizeRelationEntity::getObjectId, (Object)((RoleEntity)list.get(i)).getId());
            ArrayList<String> ids = new ArrayList<String>();
            for (OrganizeRelationEntity relation : this.organizeRelationService.list((Wrapper)query)) {
                OrganizeEntity info = this.organizeService.getInfo(relation.getOrganizeId());
                if (!StringUtils.isNotNull((Object)info) || !info.getId().equals(userInfo.getOrganizeId()) && !info.getParentId().equals(userInfo.getOrganizeId())) continue;
                ids.add(relation.getOrganizeId());
            }
            String orgInfos = PermissionUtil.getLinkInfoByOrgId(ids, this.organizeService);
            if (orgInfos.length() <= 0) continue;
            vo.setOrganizeInfo(orgInfos.substring(0, orgInfos.length() - 1));
            listVO.add(vo);
        }
        return ActionResult.success(listVO);
    }
}

